/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.admin.cli.io;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import xyz.tcheeric.cashu.mint.admin.cli.io.JsonResponseRenderer;
import xyz.tcheeric.cashu.mint.admin.cli.io.OutputFormat;
import xyz.tcheeric.cashu.mint.admin.cli.io.ResponseRenderer;
import xyz.tcheeric.cashu.mint.admin.cli.io.ResponseRenderingException;
import xyz.tcheeric.cashu.mint.admin.cli.io.TableResponseRenderer;

public final class ResponseRenderingService {
    private final Map<OutputFormat, ResponseRenderer> renderers;

    public ResponseRenderingService(Collection<ResponseRenderer> renderers) {
        EnumMap<OutputFormat, ResponseRenderer> lookup = new EnumMap<OutputFormat, ResponseRenderer>(OutputFormat.class);
        for (ResponseRenderer renderer : renderers) {
            lookup.put(renderer.format(), renderer);
        }
        this.renderers = Map.copyOf(lookup);
    }

    public static ResponseRenderingService createDefault(ObjectMapper jsonMapper) {
        Objects.requireNonNull(jsonMapper, "jsonMapper");
        return new ResponseRenderingService(List.of(new JsonResponseRenderer(jsonMapper), new TableResponseRenderer(jsonMapper)));
    }

    public String render(Object response, OutputFormat format) {
        Objects.requireNonNull(format, "format");
        if (response == null) {
            return "";
        }
        ResponseRenderer renderer = this.renderers.get((Object)format);
        if (renderer == null) {
            throw new ResponseRenderingException("No renderer registered for format " + String.valueOf((Object)format));
        }
        return renderer.render(response);
    }
}

