/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.admin.cli.model;

import java.util.UUID;
import xyz.tcheeric.cashu.mint.admin.cli.model.ModelValidations;

public record MintLifecycleRequest(String mintId, String operatorId, String versionTag, String requestId, String correlationId) {
    public MintLifecycleRequest {
        mintId = ModelValidations.requireMintId(mintId);
        operatorId = ModelValidations.requireText(operatorId, "operatorId");
        versionTag = ModelValidations.requireText(versionTag, "versionTag");
        MintLifecycleRequest.validateOperator(operatorId);
        requestId = MintLifecycleRequest.sanitizeRequestId(requestId);
        correlationId = ModelValidations.optionalText(correlationId, "correlationId");
    }

    private static void validateOperator(String operatorId) {
        try {
            UUID.fromString(operatorId);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("operatorId must be a valid UUID", ex);
        }
    }

    private static String sanitizeRequestId(String requestId) {
        if (requestId == null || requestId.isBlank()) {
            return null;
        }
        try {
            return UUID.fromString(requestId.trim()).toString();
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("requestId must be a valid UUID", ex);
        }
    }
}

