/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.admin.cli.port.stub;

import java.time.OffsetDateTime;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import xyz.tcheeric.cashu.mint.admin.cli.model.MintAlertRecord;
import xyz.tcheeric.cashu.mint.admin.cli.model.MintAlertsRequest;
import xyz.tcheeric.cashu.mint.admin.cli.port.MintAlertsPort;

public final class StubMintAlertsPort
implements MintAlertsPort {
    private static final List<MintAlertRecord> ALERTS = List.of(new MintAlertRecord("alert-1", "INFO", "Scheduled maintenance window", OffsetDateTime.now().minusHours(12L).toString()), new MintAlertRecord("alert-2", "WARN", "Pending rate limit breach", OffsetDateTime.now().minusHours(2L).toString()), new MintAlertRecord("alert-3", "ERROR", "Lightning backend unreachable", OffsetDateTime.now().minusMinutes(15L).toString()));

    @Override
    public List<MintAlertRecord> listAlerts(MintAlertsRequest request) {
        String severity = request.severity().toUpperCase(Locale.ROOT);
        return ALERTS.stream().filter(alert -> this.alertSeverityAtLeast(alert.severity(), severity)).collect(Collectors.toList());
    }

    private boolean alertSeverityAtLeast(String candidate, String threshold) {
        int thresholdIndex;
        List<String> ordering = List.of("INFO", "WARN", "ERROR");
        int candidateIndex = ordering.indexOf(candidate.toUpperCase(Locale.ROOT));
        return candidateIndex >= (thresholdIndex = ordering.indexOf(threshold.toUpperCase(Locale.ROOT))) && candidateIndex >= 0;
    }
}

