/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.admin.domain;

import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import xyz.tcheeric.cashu.mint.admin.domain.AutomationContext;
import xyz.tcheeric.cashu.mint.admin.domain.ConfigurationRevisionId;
import xyz.tcheeric.cashu.mint.admin.domain.LifecycleContext;
import xyz.tcheeric.cashu.mint.admin.domain.NotificationPolicy;
import xyz.tcheeric.cashu.mint.admin.domain.NotificationPolicySnapshot;

public final class AuditMetadata {
    private final String actor;
    private final String action;
    private final Instant timestamp;
    private final List<String> reasonCodes;
    private final List<String> ticketReferences;
    private final AutomationContext automationContext;
    private final LifecycleContext lifecycleContext;
    private final UUID requestId;
    private final String correlationId;

    public AuditMetadata(String actor, String action, Instant timestamp) {
        this(actor, action, timestamp, List.of(), List.of(), AutomationContext.manual(), LifecycleContext.empty(), null, null);
    }

    public AuditMetadata(String actor, String action, Instant timestamp, List<String> reasonCodes, List<String> ticketReferences, AutomationContext automationContext) {
        this(actor, action, timestamp, reasonCodes, ticketReferences, automationContext, LifecycleContext.empty(), null, null);
    }

    public AuditMetadata(String actor, String action, Instant timestamp, List<String> reasonCodes, List<String> ticketReferences, AutomationContext automationContext, LifecycleContext lifecycleContext) {
        this(actor, action, timestamp, reasonCodes, ticketReferences, automationContext, lifecycleContext, null, null);
    }

    public AuditMetadata(String actor, String action, Instant timestamp, UUID requestId, String correlationId) {
        this(actor, action, timestamp, List.of(), List.of(), AutomationContext.manual(), LifecycleContext.empty(), requestId, correlationId);
    }

    public AuditMetadata(String actor, String action, Instant timestamp, List<String> reasonCodes, List<String> ticketReferences, AutomationContext automationContext, LifecycleContext lifecycleContext, UUID requestId, String correlationId) {
        this.actor = AuditMetadata.requireNonBlank(actor, "actor");
        this.action = AuditMetadata.requireNonBlank(action, "action");
        this.timestamp = Objects.requireNonNull(timestamp, "timestamp must not be null");
        this.reasonCodes = AuditMetadata.sanitizeList(reasonCodes, "reason code");
        this.ticketReferences = AuditMetadata.sanitizeList(ticketReferences, "ticket reference");
        this.automationContext = automationContext == null ? AutomationContext.manual() : automationContext;
        this.lifecycleContext = lifecycleContext == null ? LifecycleContext.empty() : lifecycleContext;
        this.requestId = requestId;
        this.correlationId = AuditMetadata.sanitizeCorrelationId(correlationId);
    }

    public AuditMetadata withLifecycleContext(ConfigurationRevisionId configurationRevisionId, NotificationPolicy notificationPolicy) {
        LifecycleContext context;
        if (configurationRevisionId == null && notificationPolicy == null) {
            context = LifecycleContext.empty();
        } else {
            NotificationPolicySnapshot snapshot = notificationPolicy == null ? null : NotificationPolicySnapshot.fromPolicy(notificationPolicy);
            context = new LifecycleContext(configurationRevisionId, snapshot);
        }
        return new AuditMetadata(this.actor, this.action, this.timestamp, this.reasonCodes, this.ticketReferences, this.automationContext, context, this.requestId, this.correlationId);
    }

    private static String requireNonBlank(String value, String fieldName) {
        if (value == null || value.isBlank()) {
            throw new IllegalArgumentException(fieldName + " must not be blank");
        }
        return value;
    }

    private static List<String> sanitizeList(List<String> values, String fieldName) {
        if (values == null || values.isEmpty()) {
            return List.of();
        }
        return values.stream().map(value -> AuditMetadata.sanitizeValue(value, fieldName)).collect(Collectors.toUnmodifiableList());
    }

    private static String sanitizeValue(String value, String fieldName) {
        if (value == null) {
            throw new IllegalArgumentException(fieldName + " must not be blank");
        }
        String sanitized = value.strip();
        if (sanitized.isEmpty()) {
            throw new IllegalArgumentException(fieldName + " must not be blank");
        }
        return sanitized;
    }

    private static String sanitizeCorrelationId(String value) {
        if (value == null) {
            return null;
        }
        String sanitized = value.strip();
        if (sanitized.isEmpty()) {
            throw new IllegalArgumentException("correlation id must not be blank");
        }
        return sanitized;
    }

    @Generated
    public String actor() {
        return this.actor;
    }

    @Generated
    public String action() {
        return this.action;
    }

    @Generated
    public Instant timestamp() {
        return this.timestamp;
    }

    @Generated
    public List<String> reasonCodes() {
        return this.reasonCodes;
    }

    @Generated
    public List<String> ticketReferences() {
        return this.ticketReferences;
    }

    @Generated
    public AutomationContext automationContext() {
        return this.automationContext;
    }

    @Generated
    public LifecycleContext lifecycleContext() {
        return this.lifecycleContext;
    }

    @Generated
    public UUID requestId() {
        return this.requestId;
    }

    @Generated
    public String correlationId() {
        return this.correlationId;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuditMetadata)) {
            return false;
        }
        AuditMetadata other = (AuditMetadata)o;
        String this$actor = this.actor();
        String other$actor = other.actor();
        if (this$actor == null ? other$actor != null : !this$actor.equals(other$actor)) {
            return false;
        }
        String this$action = this.action();
        String other$action = other.action();
        if (this$action == null ? other$action != null : !this$action.equals(other$action)) {
            return false;
        }
        Instant this$timestamp = this.timestamp();
        Instant other$timestamp = other.timestamp();
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        List<String> this$reasonCodes = this.reasonCodes();
        List<String> other$reasonCodes = other.reasonCodes();
        if (this$reasonCodes == null ? other$reasonCodes != null : !((Object)this$reasonCodes).equals(other$reasonCodes)) {
            return false;
        }
        List<String> this$ticketReferences = this.ticketReferences();
        List<String> other$ticketReferences = other.ticketReferences();
        if (this$ticketReferences == null ? other$ticketReferences != null : !((Object)this$ticketReferences).equals(other$ticketReferences)) {
            return false;
        }
        AutomationContext this$automationContext = this.automationContext();
        AutomationContext other$automationContext = other.automationContext();
        if (this$automationContext == null ? other$automationContext != null : !((Object)this$automationContext).equals(other$automationContext)) {
            return false;
        }
        LifecycleContext this$lifecycleContext = this.lifecycleContext();
        LifecycleContext other$lifecycleContext = other.lifecycleContext();
        if (this$lifecycleContext == null ? other$lifecycleContext != null : !((Object)this$lifecycleContext).equals(other$lifecycleContext)) {
            return false;
        }
        UUID this$requestId = this.requestId();
        UUID other$requestId = other.requestId();
        if (this$requestId == null ? other$requestId != null : !((Object)this$requestId).equals(other$requestId)) {
            return false;
        }
        String this$correlationId = this.correlationId();
        String other$correlationId = other.correlationId();
        return !(this$correlationId == null ? other$correlationId != null : !this$correlationId.equals(other$correlationId));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $actor = this.actor();
        result = result * 59 + ($actor == null ? 43 : $actor.hashCode());
        String $action = this.action();
        result = result * 59 + ($action == null ? 43 : $action.hashCode());
        Instant $timestamp = this.timestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        List<String> $reasonCodes = this.reasonCodes();
        result = result * 59 + ($reasonCodes == null ? 43 : ((Object)$reasonCodes).hashCode());
        List<String> $ticketReferences = this.ticketReferences();
        result = result * 59 + ($ticketReferences == null ? 43 : ((Object)$ticketReferences).hashCode());
        AutomationContext $automationContext = this.automationContext();
        result = result * 59 + ($automationContext == null ? 43 : ((Object)$automationContext).hashCode());
        LifecycleContext $lifecycleContext = this.lifecycleContext();
        result = result * 59 + ($lifecycleContext == null ? 43 : ((Object)$lifecycleContext).hashCode());
        UUID $requestId = this.requestId();
        result = result * 59 + ($requestId == null ? 43 : ((Object)$requestId).hashCode());
        String $correlationId = this.correlationId();
        result = result * 59 + ($correlationId == null ? 43 : $correlationId.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AuditMetadata(actor=" + this.actor() + ", action=" + this.action() + ", timestamp=" + String.valueOf(this.timestamp()) + ", reasonCodes=" + String.valueOf(this.reasonCodes()) + ", ticketReferences=" + String.valueOf(this.ticketReferences()) + ", automationContext=" + String.valueOf(this.automationContext()) + ", lifecycleContext=" + String.valueOf(this.lifecycleContext()) + ", requestId=" + String.valueOf(this.requestId()) + ", correlationId=" + this.correlationId() + ")";
    }
}

