/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.admin.domain;

import java.util.Objects;
import lombok.Generated;

public final class ConfigurationRevisionId
implements Comparable<ConfigurationRevisionId> {
    private final long value;

    private ConfigurationRevisionId(long value) {
        if (value <= 0L) {
            throw new IllegalArgumentException("configuration revision id must be positive");
        }
        this.value = value;
    }

    public static ConfigurationRevisionId of(long value) {
        return new ConfigurationRevisionId(value);
    }

    public ConfigurationRevisionId next() {
        return new ConfigurationRevisionId(this.value + 1L);
    }

    public boolean isAfter(ConfigurationRevisionId other) {
        Objects.requireNonNull(other, "other revision id must not be null");
        return this.value > other.value;
    }

    @Override
    public int compareTo(ConfigurationRevisionId other) {
        Objects.requireNonNull(other, "other revision id must not be null");
        return Long.compare(this.value, other.value);
    }

    public String toString() {
        return Long.toString(this.value);
    }

    @Generated
    public long value() {
        return this.value;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConfigurationRevisionId)) {
            return false;
        }
        ConfigurationRevisionId other = (ConfigurationRevisionId)o;
        return this.value() == other.value();
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $value = this.value();
        result = result * 59 + (int)($value >>> 32 ^ $value);
        return result;
    }
}

