/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.admin.domain;

import java.util.Objects;
import java.util.UUID;
import lombok.Generated;

public final class MintId {
    private final UUID value;

    private MintId(UUID value) {
        this.value = Objects.requireNonNull(value, "mint identifier must not be null");
    }

    public static MintId of(UUID value) {
        return new MintId(value);
    }

    public static MintId fromString(String raw) {
        if (raw == null || raw.isBlank()) {
            throw new IllegalArgumentException("mint identifier must not be blank");
        }
        try {
            return MintId.of(UUID.fromString(raw));
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("mint identifier must be a valid UUID", ex);
        }
    }

    public String asString() {
        return this.value.toString();
    }

    @Generated
    public UUID value() {
        return this.value;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MintId)) {
            return false;
        }
        MintId other = (MintId)o;
        UUID this$value = this.value();
        UUID other$value = other.value();
        return !(this$value == null ? other$value != null : !((Object)this$value).equals(other$value));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $value = this.value();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MintId(value=" + String.valueOf(this.value()) + ")";
    }
}

