/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.admin.domain;

import java.time.Duration;
import java.util.Objects;
import lombok.Generated;
import xyz.tcheeric.cashu.mint.admin.domain.AuditMetadata;

public final class NotificationPolicy {
    private final boolean emailEnabled;
    private final boolean webhookEnabled;
    private final Duration throttleInterval;
    private final AuditMetadata auditMetadata;

    public NotificationPolicy(boolean emailEnabled, boolean webhookEnabled, Duration throttleInterval, AuditMetadata auditMetadata) {
        this.emailEnabled = emailEnabled;
        this.webhookEnabled = webhookEnabled;
        this.throttleInterval = NotificationPolicy.validateInterval(throttleInterval);
        this.auditMetadata = Objects.requireNonNull(auditMetadata, "audit metadata must not be null");
    }

    private static Duration validateInterval(Duration interval) {
        Duration validated = Objects.requireNonNull(interval, "throttle interval must not be null");
        if (validated.isNegative()) {
            throw new IllegalArgumentException("throttle interval must not be negative");
        }
        return validated;
    }

    public NotificationPolicy updateEmail(boolean enabled, AuditMetadata metadata) {
        return new NotificationPolicy(enabled, this.webhookEnabled, this.throttleInterval, Objects.requireNonNull(metadata, "audit metadata must not be null"));
    }

    public NotificationPolicy updateWebhook(boolean enabled, AuditMetadata metadata) {
        return new NotificationPolicy(this.emailEnabled, enabled, this.throttleInterval, Objects.requireNonNull(metadata, "audit metadata must not be null"));
    }

    public NotificationPolicy updateThrottleInterval(Duration interval, AuditMetadata metadata) {
        return new NotificationPolicy(this.emailEnabled, this.webhookEnabled, NotificationPolicy.validateInterval(interval), Objects.requireNonNull(metadata, "audit metadata must not be null"));
    }

    @Generated
    public boolean emailEnabled() {
        return this.emailEnabled;
    }

    @Generated
    public boolean webhookEnabled() {
        return this.webhookEnabled;
    }

    @Generated
    public Duration throttleInterval() {
        return this.throttleInterval;
    }

    @Generated
    public AuditMetadata auditMetadata() {
        return this.auditMetadata;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NotificationPolicy)) {
            return false;
        }
        NotificationPolicy other = (NotificationPolicy)o;
        if (this.emailEnabled() != other.emailEnabled()) {
            return false;
        }
        if (this.webhookEnabled() != other.webhookEnabled()) {
            return false;
        }
        Duration this$throttleInterval = this.throttleInterval();
        Duration other$throttleInterval = other.throttleInterval();
        if (this$throttleInterval == null ? other$throttleInterval != null : !((Object)this$throttleInterval).equals(other$throttleInterval)) {
            return false;
        }
        AuditMetadata this$auditMetadata = this.auditMetadata();
        AuditMetadata other$auditMetadata = other.auditMetadata();
        return !(this$auditMetadata == null ? other$auditMetadata != null : !((Object)this$auditMetadata).equals(other$auditMetadata));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.emailEnabled() ? 79 : 97);
        result = result * 59 + (this.webhookEnabled() ? 79 : 97);
        Duration $throttleInterval = this.throttleInterval();
        result = result * 59 + ($throttleInterval == null ? 43 : ((Object)$throttleInterval).hashCode());
        AuditMetadata $auditMetadata = this.auditMetadata();
        result = result * 59 + ($auditMetadata == null ? 43 : ((Object)$auditMetadata).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "NotificationPolicy(emailEnabled=" + this.emailEnabled() + ", webhookEnabled=" + this.webhookEnabled() + ", throttleInterval=" + String.valueOf(this.throttleInterval()) + ", auditMetadata=" + String.valueOf(this.auditMetadata()) + ")";
    }
}

