/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.admin.domain;

import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import xyz.tcheeric.cashu.mint.admin.domain.AuditMetadata;

public final class OperatorAccount {
    private final UUID operatorId;
    private final String displayName;
    private final Set<String> roles;
    private final AuditMetadata auditMetadata;

    public OperatorAccount(UUID operatorId, String displayName, Set<String> roles, AuditMetadata auditMetadata) {
        this.operatorId = Objects.requireNonNull(operatorId, "operator id must not be null");
        this.displayName = OperatorAccount.requireNonBlank(displayName, "display name");
        this.roles = Set.copyOf(OperatorAccount.validateRoles(roles));
        this.auditMetadata = Objects.requireNonNull(auditMetadata, "audit metadata must not be null");
    }

    private static Set<String> validateRoles(Set<String> roles) {
        Objects.requireNonNull(roles, "roles must not be null");
        for (String role : roles) {
            OperatorAccount.requireNonBlank(role, "role");
        }
        return roles;
    }

    private static String requireNonBlank(String value, String fieldName) {
        if (value == null || value.isBlank()) {
            throw new IllegalArgumentException(fieldName + " must not be blank");
        }
        return value;
    }

    public OperatorAccount rename(String newDisplayName, AuditMetadata metadata) {
        return new OperatorAccount(this.operatorId, OperatorAccount.requireNonBlank(newDisplayName, "display name"), this.roles, Objects.requireNonNull(metadata, "audit metadata must not be null"));
    }

    public OperatorAccount updateRoles(Set<String> newRoles, AuditMetadata metadata) {
        return new OperatorAccount(this.operatorId, this.displayName, Set.copyOf(OperatorAccount.validateRoles(newRoles)), Objects.requireNonNull(metadata, "audit metadata must not be null"));
    }

    @Generated
    public UUID operatorId() {
        return this.operatorId;
    }

    @Generated
    public String displayName() {
        return this.displayName;
    }

    @Generated
    public Set<String> roles() {
        return this.roles;
    }

    @Generated
    public AuditMetadata auditMetadata() {
        return this.auditMetadata;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OperatorAccount)) {
            return false;
        }
        OperatorAccount other = (OperatorAccount)o;
        UUID this$operatorId = this.operatorId();
        UUID other$operatorId = other.operatorId();
        if (this$operatorId == null ? other$operatorId != null : !((Object)this$operatorId).equals(other$operatorId)) {
            return false;
        }
        String this$displayName = this.displayName();
        String other$displayName = other.displayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        Set<String> this$roles = this.roles();
        Set<String> other$roles = other.roles();
        if (this$roles == null ? other$roles != null : !((Object)this$roles).equals(other$roles)) {
            return false;
        }
        AuditMetadata this$auditMetadata = this.auditMetadata();
        AuditMetadata other$auditMetadata = other.auditMetadata();
        return !(this$auditMetadata == null ? other$auditMetadata != null : !((Object)this$auditMetadata).equals(other$auditMetadata));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $operatorId = this.operatorId();
        result = result * 59 + ($operatorId == null ? 43 : ((Object)$operatorId).hashCode());
        String $displayName = this.displayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        Set<String> $roles = this.roles();
        result = result * 59 + ($roles == null ? 43 : ((Object)$roles).hashCode());
        AuditMetadata $auditMetadata = this.auditMetadata();
        result = result * 59 + ($auditMetadata == null ? 43 : ((Object)$auditMetadata).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "OperatorAccount(operatorId=" + String.valueOf(this.operatorId()) + ", displayName=" + this.displayName() + ", roles=" + String.valueOf(this.roles()) + ", auditMetadata=" + String.valueOf(this.auditMetadata()) + ")";
    }
}

