/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.admin.framework;

import java.util.Objects;
import org.slf4j.MDC;
import xyz.tcheeric.cashu.mint.admin.framework.CorrelationIdGenerator;

public final class CorrelationIdContext {
    public static final String MDC_KEY = "correlationId";
    private static final ThreadLocal<String> CURRENT = new ThreadLocal();

    private CorrelationIdContext() {
    }

    public static String init(String correlationId) {
        String resolved = CorrelationIdContext.normalise(correlationId);
        String valueToUse = resolved != null ? resolved : CorrelationIdGenerator.generate();
        CorrelationIdContext.set(valueToUse);
        return valueToUse;
    }

    public static String init() {
        return CorrelationIdContext.init(null);
    }

    public static Scope open(String correlationId) {
        String previous = CURRENT.get();
        String assigned = CorrelationIdContext.init(correlationId);
        return new Scope(previous, assigned);
    }

    public static Scope open() {
        return CorrelationIdContext.open(null);
    }

    public static String currentId() {
        return CURRENT.get();
    }

    public static void clear() {
        CURRENT.remove();
        MDC.remove(MDC_KEY);
    }

    private static void set(String correlationId) {
        String value = Objects.requireNonNull(correlationId, MDC_KEY);
        CURRENT.set(value);
        MDC.put(MDC_KEY, value);
    }

    private static String normalise(String candidate) {
        if (candidate == null) {
            return null;
        }
        String trimmed = candidate.trim();
        return trimmed.isEmpty() ? null : trimmed;
    }

    public static final class Scope
    implements AutoCloseable {
        private final String previous;
        private final String assigned;
        private boolean closed;

        private Scope(String previous, String assigned) {
            this.previous = previous;
            this.assigned = Objects.requireNonNull(assigned, "assigned");
        }

        public String correlationId() {
            return this.assigned;
        }

        @Override
        public void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            String current = CURRENT.get();
            if (!Objects.equals(current, this.assigned)) {
                return;
            }
            if (this.previous != null) {
                CorrelationIdContext.set(this.previous);
            } else {
                CorrelationIdContext.clear();
            }
        }
    }
}

