/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.admin.cli.command;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import picocli.CommandLine;
import xyz.tcheeric.cashu.mint.admin.cli.command.CommandIOOptions;
import xyz.tcheeric.cashu.mint.admin.cli.io.CommandPayloadMapper;
import xyz.tcheeric.cashu.mint.admin.cli.io.ResponseRenderingService;
import xyz.tcheeric.cashu.mint.admin.cli.model.MintAlertRecord;
import xyz.tcheeric.cashu.mint.admin.cli.model.MintAlertsRequest;
import xyz.tcheeric.cashu.mint.admin.cli.port.MintAlertsPort;

@CommandLine.Command(name="alerts", description={"Inspect mint alerts"}, mixinStandardHelpOptions=true)
public final class MintAlertsCommand
implements Callable<Integer> {
    private final MintAlertsPort alertsPort;
    private final CommandPayloadMapper payloadMapper;
    private final ResponseRenderingService renderingService;
    @CommandLine.Spec
    private CommandLine.Model.CommandSpec spec;
    @CommandLine.Option(names={"-m", "--mint-id"}, description={"Mint identifier when no payload is supplied."}, defaultValue="default-mint")
    private String mintId = "default-mint";
    @CommandLine.Option(names={"-s", "--severity"}, description={"Minimum severity filter when no payload is supplied."}, defaultValue="INFO")
    private String severity = "INFO";
    @CommandLine.Mixin
    private final CommandIOOptions ioOptions = new CommandIOOptions();

    public MintAlertsCommand(MintAlertsPort alertsPort, CommandPayloadMapper payloadMapper, ResponseRenderingService renderingService) {
        this.alertsPort = Objects.requireNonNull(alertsPort, "alertsPort");
        this.payloadMapper = Objects.requireNonNull(payloadMapper, "payloadMapper");
        this.renderingService = Objects.requireNonNull(renderingService, "renderingService");
    }

    @Override
    public Integer call() {
        MintAlertsRequest request = this.ioOptions.readPayload(this.payloadMapper, MintAlertsRequest.class).orElseGet(() -> new MintAlertsRequest(this.mintId, this.severity));
        List<MintAlertRecord> alerts = this.alertsPort.listAlerts(request);
        this.spec.commandLine().getOut().println(this.renderingService.render(alerts, this.ioOptions.outputFormat()));
        return 0;
    }
}

