/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.admin.cli.command;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.Callable;
import picocli.CommandLine;
import xyz.tcheeric.cashu.mint.admin.cli.command.CommandIOOptions;
import xyz.tcheeric.cashu.mint.admin.cli.io.CommandPayloadMapper;
import xyz.tcheeric.cashu.mint.admin.cli.model.MintLifecycleRequest;
import xyz.tcheeric.cashu.mint.admin.cli.port.MintLifecyclePort;
import xyz.tcheeric.cashu.mint.admin.cli.presentation.lifecycle.LifecycleSummaryCliPresenter;
import xyz.tcheeric.cashu.mint.admin.presentation.lifecycle.LifecycleAction;
import xyz.tcheeric.cashu.mint.admin.presentation.lifecycle.LifecycleSummary;

abstract class MintLifecycleCommandSupport
implements Callable<Integer> {
    private final LifecycleAction operation;
    private final MintLifecyclePort lifecyclePort;
    private final CommandPayloadMapper payloadMapper;
    private final LifecycleSummaryCliPresenter summaryPresenter;
    @CommandLine.Spec
    private CommandLine.Model.CommandSpec spec;
    @CommandLine.Mixin
    private final CommandIOOptions ioOptions = new CommandIOOptions();
    @CommandLine.Option(names={"--mint-id"}, description={"Identifier of the mint to operate on."})
    private String mintId;
    @CommandLine.Option(names={"--operator-id"}, description={"Operator UUID authorising the lifecycle change."})
    private String operatorId;
    @CommandLine.Option(names={"--version-tag"}, description={"Version tag recorded with the lifecycle change."})
    private String versionTag;
    @CommandLine.Option(names={"--request-id"}, description={"Unique identifier for this lifecycle invocation."})
    private String requestId;
    @CommandLine.Option(names={"--correlation-id"}, description={"External correlation identifier linking related changes."})
    private String correlationId;
    @CommandLine.Option(names={"-y", "--yes"}, description={"Automatically confirm the lifecycle action."})
    private boolean autoConfirm;

    MintLifecycleCommandSupport(LifecycleAction operation, MintLifecyclePort lifecyclePort, CommandPayloadMapper payloadMapper, LifecycleSummaryCliPresenter summaryPresenter) {
        this.operation = Objects.requireNonNull(operation, "operation");
        this.lifecyclePort = Objects.requireNonNull(lifecyclePort, "lifecyclePort");
        this.payloadMapper = Objects.requireNonNull(payloadMapper, "payloadMapper");
        this.summaryPresenter = Objects.requireNonNull(summaryPresenter, "summaryPresenter");
    }

    @Override
    public final Integer call() {
        try {
            MintLifecycleRequest request = this.resolveRequest();
            if (!this.autoConfirm && !this.confirm(request)) {
                this.spec.commandLine().getOut().println("Lifecycle command aborted by user.");
                return 1;
            }
            MintLifecyclePort.MintLifecycleCommand command = new MintLifecyclePort.MintLifecycleCommand(this.operation, request);
            LifecycleSummary response = this.lifecyclePort.execute(command);
            String rendered = this.summaryPresenter.present(response, this.ioOptions.outputFormat());
            this.spec.commandLine().getOut().println(rendered);
            if (response.idempotent()) {
                this.spec.commandLine().getErr().println("No changes applied (idempotent request).");
            }
            return 0;
        }
        catch (IllegalArgumentException ex) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), ex.getMessage(), (Throwable)ex);
        }
    }

    private MintLifecycleRequest resolveRequest() {
        return this.ioOptions.readPayload(this.payloadMapper, MintLifecycleRequest.class).map(this::ensureRequestIdentifiers).orElseGet(() -> this.ensureRequestIdentifiers(this.buildFromOptions()));
    }

    private MintLifecycleRequest buildFromOptions() {
        if (this.mintId == null || this.operatorId == null || this.versionTag == null) {
            throw new IllegalArgumentException("Lifecycle command requires --mint-id, --operator-id, and --version-tag when no payload is provided.");
        }
        return new MintLifecycleRequest(this.mintId, this.operatorId, this.versionTag, this.requestId, this.correlationId);
    }

    private boolean confirm(MintLifecycleRequest request) {
        PrintWriter out = this.spec.commandLine().getOut();
        out.printf("%s [y/N]: ", this.confirmationPrompt(request));
        out.flush();
        try {
            BufferedReader reader = this.inputReader();
            String line = reader.readLine();
            if (line == null) {
                return false;
            }
            String trimmed = line.trim().toLowerCase();
            return "y".equals(trimmed) || "yes".equals(trimmed);
        }
        catch (IOException ex) {
            throw new CommandLine.ExecutionException(this.spec.commandLine(), "Failed to read confirmation input", (Throwable)ex);
        }
    }

    protected abstract String confirmationPrompt(MintLifecycleRequest var1);

    private BufferedReader inputReader() {
        Reader consoleReader;
        Reader reader = consoleReader = System.console() != null ? System.console().reader() : null;
        if (consoleReader != null) {
            return new BufferedReader(consoleReader);
        }
        return new BufferedReader(new InputStreamReader(System.in));
    }

    private MintLifecycleRequest ensureRequestIdentifiers(MintLifecycleRequest request) {
        String resolvedCorrelationId;
        String resolvedRequestId = request.requestId() == null ? UUID.randomUUID().toString() : request.requestId();
        String string = resolvedCorrelationId = request.correlationId() == null ? resolvedRequestId : request.correlationId();
        if (resolvedRequestId.equals(request.requestId()) && resolvedCorrelationId.equals(request.correlationId())) {
            return request;
        }
        return new MintLifecycleRequest(request.mintId(), request.operatorId(), request.versionTag(), resolvedRequestId, resolvedCorrelationId);
    }
}

