/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.admin.cli.io;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Objects;
import xyz.tcheeric.cashu.mint.admin.cli.io.OutputFormat;
import xyz.tcheeric.cashu.mint.admin.cli.io.ResponseRenderer;
import xyz.tcheeric.cashu.mint.admin.cli.io.ResponseRenderingException;

public final class JsonResponseRenderer
implements ResponseRenderer {
    private final ObjectMapper objectMapper;

    public JsonResponseRenderer(ObjectMapper objectMapper) {
        this.objectMapper = Objects.requireNonNull(objectMapper, "objectMapper").copy();
    }

    @Override
    public OutputFormat format() {
        return OutputFormat.JSON;
    }

    @Override
    public String render(Object response) {
        try {
            return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(response);
        }
        catch (JsonProcessingException ex) {
            throw new ResponseRenderingException("Failed to render response as JSON", ex);
        }
    }
}

