/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.admin.cli.io;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import xyz.tcheeric.cashu.mint.admin.cli.io.OutputFormat;
import xyz.tcheeric.cashu.mint.admin.cli.io.ResponseRenderer;

public final class TableResponseRenderer
implements ResponseRenderer {
    private final ObjectMapper mapper;

    public TableResponseRenderer(ObjectMapper mapper) {
        this.mapper = Objects.requireNonNull(mapper, "mapper").copy();
    }

    @Override
    public OutputFormat format() {
        return OutputFormat.TABLE;
    }

    @Override
    public String render(Object response) {
        if (response == null) {
            return "";
        }
        JsonNode node = this.mapper.valueToTree(response);
        List<Map<String, String>> rows = this.extractRows(node);
        if (rows.isEmpty()) {
            return "(no data)";
        }
        ArrayList<String> headers = new ArrayList<String>(this.collectHeaders(rows));
        Map<String, Integer> widths = this.computeColumnWidths(headers, rows);
        String border = this.buildBorder(widths);
        StringBuilder builder = new StringBuilder();
        builder.append(border).append(System.lineSeparator());
        builder.append(this.buildHeaderRow(headers, widths)).append(System.lineSeparator());
        builder.append(border).append(System.lineSeparator());
        for (Map<String, String> row : rows) {
            builder.append(this.buildRow(headers, row, widths)).append(System.lineSeparator());
        }
        builder.append(border);
        return builder.toString();
    }

    private List<Map<String, String>> extractRows(JsonNode node) {
        ArrayList<Map<String, String>> rows = new ArrayList<Map<String, String>>();
        if (node == null || node.isNull()) {
            return rows;
        }
        if (node.isArray()) {
            for (JsonNode child : node) {
                rows.add(this.asRow(child));
            }
        } else {
            rows.add(this.asRow(node));
        }
        return rows;
    }

    private Map<String, String> asRow(JsonNode node) {
        LinkedHashMap<String, String> row = new LinkedHashMap<String, String>();
        if (node != null && node.isObject()) {
            node.fields().forEachRemaining(entry -> row.put((String)entry.getKey(), this.toCellValue((JsonNode)entry.getValue())));
        } else {
            row.put("value", this.toCellValue(node));
        }
        return row;
    }

    private String toCellValue(JsonNode node) {
        if (node == null || node.isNull()) {
            return "";
        }
        if (node.isValueNode()) {
            return node.asText();
        }
        return node.toString();
    }

    private Set<String> collectHeaders(List<Map<String, String>> rows) {
        LinkedHashSet<String> headers = new LinkedHashSet<String>();
        for (Map<String, String> row : rows) {
            headers.addAll(row.keySet());
        }
        return headers;
    }

    private Map<String, Integer> computeColumnWidths(List<String> headers, List<Map<String, String>> rows) {
        LinkedHashMap<String, Integer> widths = new LinkedHashMap<String, Integer>();
        for (String string : headers) {
            widths.put(string, string.length());
        }
        for (Map map : rows) {
            for (String header : headers) {
                String value = map.getOrDefault(header, "");
                widths.compute(header, (key, width) -> Math.max(width, value.length()));
            }
        }
        return widths;
    }

    private String buildBorder(Map<String, Integer> widths) {
        StringBuilder border = new StringBuilder();
        border.append('+');
        for (int width : widths.values()) {
            border.append("-".repeat(width + 2)).append('+');
        }
        return border.toString();
    }

    private String buildHeaderRow(List<String> headers, Map<String, Integer> widths) {
        LinkedHashMap<String, String> headerRow = new LinkedHashMap<String, String>();
        for (String header : headers) {
            headerRow.put(header, header);
        }
        return this.buildRow(headers, headerRow, widths);
    }

    private String buildRow(List<String> headers, Map<String, String> row, Map<String, Integer> widths) {
        StringBuilder builder = new StringBuilder();
        builder.append('|');
        for (String header : headers) {
            String value = row.getOrDefault(header, "");
            builder.append(' ').append(this.padRight(value, widths.get(header))).append(' ').append('|');
        }
        return builder.toString();
    }

    private String padRight(String value, int width) {
        int padding = Math.max(0, width - value.length());
        return value + " ".repeat(padding);
    }
}

