/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.admin.cli.port.stub;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import xyz.tcheeric.cashu.mint.admin.cli.model.MintLifecycleRequest;
import xyz.tcheeric.cashu.mint.admin.cli.port.MintLifecyclePort;
import xyz.tcheeric.cashu.mint.admin.domain.LifecycleState;
import xyz.tcheeric.cashu.mint.admin.presentation.lifecycle.LifecycleAction;
import xyz.tcheeric.cashu.mint.admin.presentation.lifecycle.LifecycleSummary;
import xyz.tcheeric.cashu.mint.admin.presentation.lifecycle.LifecycleSummaryPresenter;

public class StubMintLifecyclePort
implements MintLifecyclePort {
    private final Map<String, MintState> states = new ConcurrentHashMap<String, MintState>();
    private final LifecycleSummaryPresenter presenter;

    public StubMintLifecyclePort() {
        this(new LifecycleSummaryPresenter());
    }

    public StubMintLifecyclePort(LifecycleSummaryPresenter presenter) {
        this.presenter = Objects.requireNonNull(presenter, "presenter");
    }

    public StubMintLifecyclePort seed(String mintId, LifecycleState.State state, String versionTag) {
        this.states.put(mintId, new MintState(state, versionTag));
        return this;
    }

    @Override
    public LifecycleSummary execute(MintLifecyclePort.MintLifecycleCommand command) {
        Objects.requireNonNull(command, "command");
        MintLifecycleRequest request = command.request();
        return switch (command.operation()) {
            default -> throw new MatchException(null, null);
            case LifecycleAction.CREATE -> this.handleCreate(request);
            case LifecycleAction.UPDATE -> this.handleUpdate(request);
            case LifecycleAction.PAUSE -> this.handleTransition(request, LifecycleState.State.SUSPENDED);
            case LifecycleAction.RESUME -> this.handleTransition(request, LifecycleState.State.ACTIVE);
            case LifecycleAction.RETIRE -> this.handleTransition(request, LifecycleState.State.DECOMMISSIONED);
        };
    }

    private LifecycleSummary handleCreate(MintLifecycleRequest request) {
        MintState existing = this.states.get(request.mintId());
        if (existing != null) {
            return this.presenter.present(new LifecycleSummaryPresenter.LifecycleSummaryRequest(LifecycleAction.CREATE, request.mintId(), existing.state.name(), existing.state.name(), existing.versionTag, false));
        }
        MintState created = new MintState(LifecycleState.State.PROVISIONED, request.versionTag());
        this.states.put(request.mintId(), created);
        return this.presenter.present(new LifecycleSummaryPresenter.LifecycleSummaryRequest(LifecycleAction.CREATE, request.mintId(), null, created.state.name(), created.versionTag, true));
    }

    private LifecycleSummary handleUpdate(MintLifecycleRequest request) {
        MintState state = this.requireExistingState(request.mintId());
        boolean changed = !Objects.equals(state.versionTag, request.versionTag());
        state.versionTag = request.versionTag();
        return this.presenter.present(new LifecycleSummaryPresenter.LifecycleSummaryRequest(LifecycleAction.UPDATE, request.mintId(), state.state.name(), state.state.name(), state.versionTag, changed));
    }

    private LifecycleSummary handleTransition(MintLifecycleRequest request, LifecycleState.State target) {
        MintState state = this.requireExistingState(request.mintId());
        LifecycleState.State previous = state.state;
        boolean changed = previous != target;
        state.state = target;
        state.versionTag = request.versionTag();
        return this.presenter.present(new LifecycleSummaryPresenter.LifecycleSummaryRequest(this.actionFor(target), request.mintId(), previous.name(), state.state.name(), state.versionTag, changed));
    }

    private LifecycleAction actionFor(LifecycleState.State target) {
        return switch (target) {
            default -> throw new MatchException(null, null);
            case LifecycleState.State.PROVISIONED -> LifecycleAction.CREATE;
            case LifecycleState.State.ACTIVE -> LifecycleAction.RESUME;
            case LifecycleState.State.SUSPENDED -> LifecycleAction.PAUSE;
            case LifecycleState.State.DECOMMISSIONED -> LifecycleAction.RETIRE;
        };
    }

    private MintState requireExistingState(String mintId) {
        MintState state = this.states.get(mintId);
        if (state == null) {
            throw new IllegalStateException("mint not found: " + mintId);
        }
        return state;
    }

    private static final class MintState {
        private LifecycleState.State state;
        private String versionTag;

        private MintState(LifecycleState.State state, String versionTag) {
            this.state = Objects.requireNonNull(state, "state");
            this.versionTag = Objects.requireNonNull(versionTag, "versionTag");
        }
    }
}

