/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.admin.adapter.out.jdbc;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.sql.DataSource;
import xyz.tcheeric.cashu.mint.admin.adapter.out.jdbc.JdbcConfigurationSetRepository;
import xyz.tcheeric.cashu.mint.admin.adapter.out.jdbc.JdbcRepositoryException;
import xyz.tcheeric.cashu.mint.admin.application.port.out.MintRepository;
import xyz.tcheeric.cashu.mint.admin.domain.AuditMetadata;
import xyz.tcheeric.cashu.mint.admin.domain.AuditTrail;
import xyz.tcheeric.cashu.mint.admin.domain.AutomationContext;
import xyz.tcheeric.cashu.mint.admin.domain.ConfigurationRevisionId;
import xyz.tcheeric.cashu.mint.admin.domain.ConfigurationSet;
import xyz.tcheeric.cashu.mint.admin.domain.LifecycleContext;
import xyz.tcheeric.cashu.mint.admin.domain.LifecycleState;
import xyz.tcheeric.cashu.mint.admin.domain.MintAggregate;
import xyz.tcheeric.cashu.mint.admin.domain.MintId;
import xyz.tcheeric.cashu.mint.admin.domain.NotificationPolicy;
import xyz.tcheeric.cashu.mint.admin.domain.NotificationPolicySnapshot;
import xyz.tcheeric.cashu.mint.admin.domain.OperatorAccount;

public class JdbcMintRepository
implements MintRepository {
    private static final String UPSERT_MINT_SQL = "    INSERT INTO mints (\n        mint_id,\n        lifecycle_state,\n        current_configuration_revision,\n        last_actor,\n        last_action,\n        last_timestamp,\n        last_reason_codes,\n        last_ticket_references,\n        last_automation_automated,\n        last_automation_system,\n        last_automation_run_id,\n        version)\n    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)\n    ON CONFLICT (mint_id) DO UPDATE SET\n        lifecycle_state = EXCLUDED.lifecycle_state,\n        current_configuration_revision = EXCLUDED.current_configuration_revision,\n        last_actor = EXCLUDED.last_actor,\n        last_action = EXCLUDED.last_action,\n        last_timestamp = EXCLUDED.last_timestamp,\n        last_reason_codes = EXCLUDED.last_reason_codes,\n        last_ticket_references = EXCLUDED.last_ticket_references,\n        last_automation_automated = EXCLUDED.last_automation_automated,\n        last_automation_system = EXCLUDED.last_automation_system,\n        last_automation_run_id = EXCLUDED.last_automation_run_id,\n        version = EXCLUDED.version\n";
    private static final String H2_UPSERT_MINT_SQL = "    MERGE INTO mints (\n        mint_id,\n        lifecycle_state,\n        current_configuration_revision,\n        last_actor,\n        last_action,\n        last_timestamp,\n        last_reason_codes,\n        last_ticket_references,\n        last_automation_automated,\n        last_automation_system,\n        last_automation_run_id,\n        version)\n    KEY (mint_id)\n    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)\n";
    private static final String UPSERT_OPERATOR_SQL = "    INSERT INTO operator_accounts (\n        mint_id,\n        operator_id,\n        display_name,\n        roles,\n        audit_actor,\n        audit_action,\n        audit_timestamp,\n        audit_reason_codes,\n        audit_ticket_references,\n        audit_automation_automated,\n        audit_automation_system,\n        audit_automation_run_id)\n    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)\n    ON CONFLICT (mint_id) DO UPDATE SET\n        operator_id = EXCLUDED.operator_id,\n        display_name = EXCLUDED.display_name,\n        roles = EXCLUDED.roles,\n        audit_actor = EXCLUDED.audit_actor,\n        audit_action = EXCLUDED.audit_action,\n        audit_timestamp = EXCLUDED.audit_timestamp,\n        audit_reason_codes = EXCLUDED.audit_reason_codes,\n        audit_ticket_references = EXCLUDED.audit_ticket_references,\n        audit_automation_automated = EXCLUDED.audit_automation_automated,\n        audit_automation_system = EXCLUDED.audit_automation_system,\n        audit_automation_run_id = EXCLUDED.audit_automation_run_id\n";
    private static final String H2_UPSERT_OPERATOR_SQL = "    MERGE INTO operator_accounts (\n        mint_id,\n        operator_id,\n        display_name,\n        roles,\n        audit_actor,\n        audit_action,\n        audit_timestamp,\n        audit_reason_codes,\n        audit_ticket_references,\n        audit_automation_automated,\n        audit_automation_system,\n        audit_automation_run_id)\n    KEY (mint_id)\n    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)\n";
    private static final String UPSERT_NOTIFICATION_SQL = "    INSERT INTO notification_policies (\n        mint_id,\n        email_enabled,\n        webhook_enabled,\n        throttle_interval_seconds,\n        audit_actor,\n        audit_action,\n        audit_timestamp,\n        audit_reason_codes,\n        audit_ticket_references,\n        audit_automation_automated,\n        audit_automation_system,\n        audit_automation_run_id)\n    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)\n    ON CONFLICT (mint_id) DO UPDATE SET\n        email_enabled = EXCLUDED.email_enabled,\n        webhook_enabled = EXCLUDED.webhook_enabled,\n        throttle_interval_seconds = EXCLUDED.throttle_interval_seconds,\n        audit_actor = EXCLUDED.audit_actor,\n        audit_action = EXCLUDED.audit_action,\n        audit_timestamp = EXCLUDED.audit_timestamp,\n        audit_reason_codes = EXCLUDED.audit_reason_codes,\n        audit_ticket_references = EXCLUDED.audit_ticket_references,\n        audit_automation_automated = EXCLUDED.audit_automation_automated,\n        audit_automation_system = EXCLUDED.audit_automation_system,\n        audit_automation_run_id = EXCLUDED.audit_automation_run_id\n";
    private static final String H2_UPSERT_NOTIFICATION_SQL = "    MERGE INTO notification_policies (\n        mint_id,\n        email_enabled,\n        webhook_enabled,\n        throttle_interval_seconds,\n        audit_actor,\n        audit_action,\n        audit_timestamp,\n        audit_reason_codes,\n        audit_ticket_references,\n        audit_automation_automated,\n        audit_automation_system,\n        audit_automation_run_id)\n    KEY (mint_id)\n    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)\n";
    private static final String DELETE_AUDIT_SQL = "DELETE FROM audit_events WHERE mint_id = ?";
    private static final String INSERT_AUDIT_SQL = "    INSERT INTO audit_events (mint_id, sequence, actor, action, event_timestamp,\n        reason_codes,\n        ticket_references,\n        automation_automated,\n        automation_system,\n        automation_run_id,\n        configuration_revision_id,\n        notification_policy_email_enabled,\n        notification_policy_webhook_enabled,\n        notification_policy_throttle_interval_seconds,\n        notification_policy_audit_actor,\n        notification_policy_audit_action,\n        notification_policy_audit_timestamp,\n        request_id,\n        correlation_id)\n    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)\n";
    private static final String SELECT_MINT_SQL = "    SELECT lifecycle_state, current_configuration_revision, last_actor, last_action, last_timestamp, version\n    FROM mints\n    WHERE mint_id = ?\n";
    private static final String SELECT_ALL_IDS_SQL = "SELECT mint_id FROM mints ORDER BY mint_id";
    private static final String SELECT_OPERATOR_SQL = "    SELECT operator_id, display_name, roles, audit_actor, audit_action, audit_timestamp,\n           audit_reason_codes, audit_ticket_references, audit_automation_automated,\n           audit_automation_system, audit_automation_run_id\n    FROM operator_accounts\n    WHERE mint_id = ?\n";
    private static final String SELECT_NOTIFICATION_SQL = "    SELECT email_enabled, webhook_enabled, throttle_interval_seconds, audit_actor, audit_action, audit_timestamp,\n           audit_reason_codes, audit_ticket_references, audit_automation_automated,\n           audit_automation_system, audit_automation_run_id\n    FROM notification_policies\n    WHERE mint_id = ?\n";
    private static final String SELECT_AUDIT_SQL = "    SELECT sequence,\n           actor,\n           action,\n           event_timestamp,\n           reason_codes,\n           ticket_references,\n           automation_automated,\n           automation_system,\n           automation_run_id,\n           configuration_revision_id,\n           notification_policy_email_enabled,\n           notification_policy_webhook_enabled,\n           notification_policy_throttle_interval_seconds,\n           notification_policy_audit_actor,\n           notification_policy_audit_action,\n           notification_policy_audit_timestamp,\n           request_id,\n           correlation_id\n    FROM audit_events\n    WHERE mint_id = ?\n    ORDER BY sequence\n";
    private static final TypeReference<Set<String>> ROLE_TYPE = new TypeReference<Set<String>>(){};
    private static final TypeReference<List<String>> LIST_TYPE = new TypeReference<List<String>>(){};
    private final DataSource dataSource;
    private final JdbcConfigurationSetRepository configurationRepository;
    private final ObjectMapper objectMapper;

    public JdbcMintRepository(DataSource dataSource, JdbcConfigurationSetRepository configurationRepository, ObjectMapper objectMapper) {
        this.dataSource = dataSource;
        this.configurationRepository = configurationRepository;
        this.objectMapper = objectMapper;
    }

    @Override
    public void save(MintAggregate aggregate) {
        try (Connection connection = this.dataSource.getConnection();){
            connection.setAutoCommit(false);
            try {
                this.configurationRepository.save(connection, aggregate.mintId(), aggregate.configurationSet());
                this.upsertMint(connection, aggregate);
                this.upsertOperator(connection, aggregate.mintId(), aggregate.operatorAccount());
                this.upsertNotification(connection, aggregate.mintId(), aggregate.notificationPolicy());
                this.replaceAuditTrail(connection, aggregate.mintId(), aggregate.auditTrail());
                connection.commit();
            }
            catch (IOException | SQLException ex) {
                connection.rollback();
                throw new JdbcRepositoryException("Failed to persist mint aggregate", ex);
            }
            finally {
                connection.setAutoCommit(true);
            }
        }
        catch (SQLException ex) {
            throw new JdbcRepositoryException("Failed to persist mint aggregate", ex);
        }
    }

    @Override
    public Optional<MintAggregate> findById(MintId mintId) {
        Optional<MintAggregate> optional;
        block8: {
            Connection connection = this.dataSource.getConnection();
            try {
                optional = this.loadAggregate(connection, mintId);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | SQLException ex) {
                    throw new JdbcRepositoryException("Failed to load mint aggregate", ex);
                }
            }
            connection.close();
        }
        return optional;
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<MintAggregate> findAll() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void upsertMint(Connection connection, MintAggregate aggregate) throws SQLException, IOException {
        try (PreparedStatement statement = this.prepareStatement(connection, UPSERT_MINT_SQL, H2_UPSERT_MINT_SQL);){
            AuditMetadata audit = aggregate.auditMetadata();
            statement.setObject(1, aggregate.mintId().value());
            statement.setString(2, aggregate.lifecycleState().value().name());
            statement.setLong(3, aggregate.configurationSet().revisionId().value());
            statement.setString(4, audit.actor());
            statement.setString(5, audit.action());
            statement.setTimestamp(6, Timestamp.from(audit.timestamp()));
            statement.setString(7, this.writeList(audit.reasonCodes()));
            statement.setString(8, this.writeList(audit.ticketReferences()));
            statement.setBoolean(9, audit.automationContext().automated());
            statement.setString(10, audit.automationContext().system());
            statement.setString(11, audit.automationContext().runId());
            statement.setLong(12, aggregate.auditTrail().entries().size());
            statement.executeUpdate();
        }
    }

    private void upsertOperator(Connection connection, MintId mintId, OperatorAccount operator) throws SQLException, IOException {
        try (PreparedStatement statement = this.prepareStatement(connection, UPSERT_OPERATOR_SQL, H2_UPSERT_OPERATOR_SQL);){
            AuditMetadata audit = operator.auditMetadata();
            statement.setObject(1, mintId.value());
            statement.setObject(2, operator.operatorId());
            statement.setString(3, operator.displayName());
            statement.setString(4, this.objectMapper.writeValueAsString(operator.roles()));
            statement.setString(5, audit.actor());
            statement.setString(6, audit.action());
            statement.setTimestamp(7, Timestamp.from(audit.timestamp()));
            statement.setString(8, this.writeList(audit.reasonCodes()));
            statement.setString(9, this.writeList(audit.ticketReferences()));
            statement.setBoolean(10, audit.automationContext().automated());
            statement.setString(11, audit.automationContext().system());
            statement.setString(12, audit.automationContext().runId());
            statement.executeUpdate();
        }
    }

    private void upsertNotification(Connection connection, MintId mintId, NotificationPolicy policy) throws SQLException, IOException {
        try (PreparedStatement statement = this.prepareStatement(connection, UPSERT_NOTIFICATION_SQL, H2_UPSERT_NOTIFICATION_SQL);){
            AuditMetadata audit = policy.auditMetadata();
            statement.setObject(1, mintId.value());
            statement.setBoolean(2, policy.emailEnabled());
            statement.setBoolean(3, policy.webhookEnabled());
            statement.setLong(4, policy.throttleInterval().toSeconds());
            statement.setString(5, audit.actor());
            statement.setString(6, audit.action());
            statement.setTimestamp(7, Timestamp.from(audit.timestamp()));
            statement.setString(8, this.writeList(audit.reasonCodes()));
            statement.setString(9, this.writeList(audit.ticketReferences()));
            statement.setBoolean(10, audit.automationContext().automated());
            statement.setString(11, audit.automationContext().system());
            statement.setString(12, audit.automationContext().runId());
            statement.executeUpdate();
        }
    }

    private void replaceAuditTrail(Connection connection, MintId mintId, AuditTrail auditTrail) throws SQLException, IOException {
        try (PreparedStatement delete = connection.prepareStatement(DELETE_AUDIT_SQL);){
            delete.setObject(1, mintId.value());
            delete.executeUpdate();
        }
        List<AuditMetadata> entries = auditTrail.entries();
        for (int index = 0; index < entries.size(); ++index) {
            AuditMetadata entry = entries.get(index);
            try (PreparedStatement insert = connection.prepareStatement(INSERT_AUDIT_SQL);){
                insert.setObject(1, mintId.value());
                insert.setLong(2, index + 1);
                insert.setString(3, entry.actor());
                insert.setString(4, entry.action());
                insert.setTimestamp(5, Timestamp.from(entry.timestamp()));
                insert.setString(6, this.writeList(entry.reasonCodes()));
                insert.setString(7, this.writeList(entry.ticketReferences()));
                insert.setBoolean(8, entry.automationContext().automated());
                insert.setString(9, entry.automationContext().system());
                insert.setString(10, entry.automationContext().runId());
                LifecycleContext context = entry.lifecycleContext();
                ConfigurationRevisionId revisionId = context.configurationRevisionId();
                if (revisionId == null) {
                    insert.setNull(11, -5);
                } else {
                    insert.setLong(11, revisionId.value());
                }
                NotificationPolicySnapshot snapshot = context.notificationPolicySnapshot();
                if (snapshot == null) {
                    insert.setNull(12, 16);
                    insert.setNull(13, 16);
                    insert.setNull(14, -5);
                    insert.setNull(15, 12);
                    insert.setNull(16, 12);
                    insert.setNull(17, 2014);
                } else {
                    insert.setBoolean(12, snapshot.emailEnabled());
                    insert.setBoolean(13, snapshot.webhookEnabled());
                    insert.setLong(14, snapshot.throttleInterval().getSeconds());
                    insert.setString(15, snapshot.auditActor());
                    insert.setString(16, snapshot.auditAction());
                    insert.setTimestamp(17, Timestamp.from(snapshot.auditTimestamp()));
                }
                insert.setObject(18, entry.requestId());
                insert.setString(19, entry.correlationId());
                insert.executeUpdate();
                continue;
            }
        }
    }

    private Optional<MintAggregate> loadAggregate(Connection connection, MintId mintId) throws SQLException, IOException {
        try (PreparedStatement statement = connection.prepareStatement(SELECT_MINT_SQL);){
            Optional<MintAggregate> optional;
            block16: {
                ResultSet resultSet;
                block14: {
                    Optional<MintAggregate> optional2;
                    block15: {
                        statement.setObject(1, mintId.value());
                        resultSet = statement.executeQuery();
                        try {
                            if (resultSet.next()) break block14;
                            optional2 = Optional.empty();
                            if (resultSet == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (resultSet != null) {
                                try {
                                    resultSet.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        resultSet.close();
                    }
                    return optional2;
                }
                LifecycleState lifecycleState = LifecycleState.of(LifecycleState.State.valueOf(resultSet.getString("lifecycle_state")));
                ConfigurationRevisionId revisionId = ConfigurationRevisionId.of(resultSet.getLong("current_configuration_revision"));
                ConfigurationSet configuration = this.configurationRepository.findByRevision(mintId, revisionId).orElseThrow(() -> new JdbcRepositoryException("Missing configuration revision " + revisionId.value() + " for mint " + mintId.asString()));
                OperatorAccount operator = this.loadOperatorAccount(connection, mintId);
                NotificationPolicy policy = this.loadNotificationPolicy(connection, mintId);
                AuditTrail auditTrail = this.loadAuditTrail(connection, mintId);
                AuditMetadata audit = auditTrail.latestMetadata();
                optional = Optional.of(MintAggregate.reconstitute(mintId, lifecycleState, configuration, operator, policy, auditTrail, audit));
                if (resultSet == null) break block16;
                resultSet.close();
            }
            return optional;
        }
    }

    private OperatorAccount loadOperatorAccount(Connection connection, MintId mintId) throws SQLException, IOException {
        try (PreparedStatement statement = connection.prepareStatement(SELECT_OPERATOR_SQL);){
            OperatorAccount operatorAccount;
            block13: {
                statement.setObject(1, mintId.value());
                ResultSet resultSet = statement.executeQuery();
                try {
                    if (!resultSet.next()) {
                        throw new JdbcRepositoryException("Operator account missing for mint " + mintId.asString());
                    }
                    UUID operatorId = this.getUuid(resultSet, "operator_id");
                    LinkedHashSet<String> roles = new LinkedHashSet<String>((Collection)this.objectMapper.readValue(resultSet.getString("roles"), ROLE_TYPE));
                    AuditMetadata audit = new AuditMetadata(resultSet.getString("audit_actor"), resultSet.getString("audit_action"), this.getInstant(resultSet, "audit_timestamp"), this.readList(resultSet, "audit_reason_codes"), this.readList(resultSet, "audit_ticket_references"), this.mapAutomationContext(resultSet, "audit_automation_automated", "audit_automation_system", "audit_automation_run_id"));
                    operatorAccount = new OperatorAccount(operatorId, resultSet.getString("display_name"), roles, audit);
                    if (resultSet == null) break block13;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return operatorAccount;
        }
    }

    private NotificationPolicy loadNotificationPolicy(Connection connection, MintId mintId) throws SQLException, IOException {
        try (PreparedStatement statement = connection.prepareStatement(SELECT_NOTIFICATION_SQL);){
            NotificationPolicy notificationPolicy;
            block13: {
                statement.setObject(1, mintId.value());
                ResultSet resultSet = statement.executeQuery();
                try {
                    if (!resultSet.next()) {
                        throw new JdbcRepositoryException("Notification policy missing for mint " + mintId.asString());
                    }
                    AuditMetadata audit = new AuditMetadata(resultSet.getString("audit_actor"), resultSet.getString("audit_action"), this.getInstant(resultSet, "audit_timestamp"), this.readList(resultSet, "audit_reason_codes"), this.readList(resultSet, "audit_ticket_references"), this.mapAutomationContext(resultSet, "audit_automation_automated", "audit_automation_system", "audit_automation_run_id"));
                    Duration interval = Duration.ofSeconds(resultSet.getLong("throttle_interval_seconds"));
                    notificationPolicy = new NotificationPolicy(resultSet.getBoolean("email_enabled"), resultSet.getBoolean("webhook_enabled"), interval, audit);
                    if (resultSet == null) break block13;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return notificationPolicy;
        }
    }

    private AuditTrail loadAuditTrail(Connection connection, MintId mintId) throws SQLException, IOException {
        try (PreparedStatement statement = connection.prepareStatement(SELECT_AUDIT_SQL);){
            AuditTrail auditTrail;
            block14: {
                statement.setObject(1, mintId.value());
                ResultSet resultSet = statement.executeQuery();
                try {
                    if (!resultSet.next()) {
                        throw new JdbcRepositoryException("Audit trail missing for mint " + mintId.asString());
                    }
                    AuditTrail trail = AuditTrail.create(this.mapAuditEntry(resultSet));
                    while (resultSet.next()) {
                        trail = trail.append(this.mapAuditEntry(resultSet));
                    }
                    auditTrail = trail;
                    if (resultSet == null) break block14;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return auditTrail;
        }
    }

    private AuditMetadata mapAuditEntry(ResultSet resultSet) throws SQLException, IOException {
        LifecycleContext context = this.mapLifecycleContext(resultSet);
        UUID requestId = this.getNullableUuid(resultSet, "request_id");
        String correlationId = resultSet.getString("correlation_id");
        return new AuditMetadata(resultSet.getString("actor"), resultSet.getString("action"), this.getInstant(resultSet, "event_timestamp"), this.readList(resultSet, "reason_codes"), this.readList(resultSet, "ticket_references"), this.mapAutomationContext(resultSet, "automation_automated", "automation_system", "automation_run_id"), context, requestId, correlationId);
    }

    private String writeList(List<String> values) throws IOException {
        if (values == null || values.isEmpty()) {
            return "[]";
        }
        return this.objectMapper.writeValueAsString(values);
    }

    private List<String> readList(ResultSet resultSet, String column) throws SQLException, IOException {
        String raw = resultSet.getString(column);
        if (raw == null || raw.isBlank()) {
            return List.of();
        }
        return (List)this.objectMapper.readValue(raw, LIST_TYPE);
    }

    private AutomationContext mapAutomationContext(ResultSet resultSet, String automatedColumn, String systemColumn, String runIdColumn) throws SQLException {
        Boolean automated = (Boolean)resultSet.getObject(automatedColumn);
        String system = resultSet.getString(systemColumn);
        String runId = resultSet.getString(runIdColumn);
        if (automated == null) {
            return AutomationContext.manual();
        }
        return new AutomationContext(automated, system, runId);
    }

    private LifecycleContext mapLifecycleContext(ResultSet resultSet) throws SQLException {
        long revisionValue = resultSet.getLong("configuration_revision_id");
        ConfigurationRevisionId revisionId = resultSet.wasNull() ? null : ConfigurationRevisionId.of(revisionValue);
        Boolean emailEnabled = (Boolean)resultSet.getObject("notification_policy_email_enabled");
        Boolean webhookEnabled = (Boolean)resultSet.getObject("notification_policy_webhook_enabled");
        Long throttleSeconds = (Long)resultSet.getObject("notification_policy_throttle_interval_seconds");
        String auditActor = resultSet.getString("notification_policy_audit_actor");
        String auditAction = resultSet.getString("notification_policy_audit_action");
        Instant auditTimestamp = this.getInstant(resultSet, "notification_policy_audit_timestamp");
        NotificationPolicySnapshot snapshot = null;
        if (emailEnabled != null && webhookEnabled != null && throttleSeconds != null && auditActor != null && auditAction != null && auditTimestamp != null) {
            snapshot = new NotificationPolicySnapshot(emailEnabled, webhookEnabled, Duration.ofSeconds(throttleSeconds), auditActor, auditAction, auditTimestamp);
        }
        if (revisionId == null && snapshot == null) {
            return LifecycleContext.empty();
        }
        return new LifecycleContext(revisionId, snapshot);
    }

    private Instant getInstant(ResultSet resultSet, String column) throws SQLException {
        Timestamp timestamp = resultSet.getTimestamp(column);
        if (timestamp == null) {
            return null;
        }
        return timestamp.toInstant();
    }

    private PreparedStatement prepareStatement(Connection connection, String postgresSql, String h2Sql) throws SQLException {
        if (this.isH2(connection)) {
            return connection.prepareStatement(h2Sql);
        }
        return connection.prepareStatement(postgresSql);
    }

    private boolean isH2(Connection connection) throws SQLException {
        String productName = connection.getMetaData().getDatabaseProductName();
        return "H2".equalsIgnoreCase(productName);
    }

    private UUID getUuid(ResultSet resultSet, String column) throws SQLException {
        Object value = resultSet.getObject(column);
        if (value instanceof UUID) {
            UUID uuid = (UUID)value;
            return uuid;
        }
        return UUID.fromString(resultSet.getString(column));
    }

    private UUID getNullableUuid(ResultSet resultSet, String column) throws SQLException {
        Object value = resultSet.getObject(column);
        if (value == null) {
            return null;
        }
        if (value instanceof UUID) {
            UUID uuid = (UUID)value;
            return uuid;
        }
        String text = value.toString();
        if (text.isBlank()) {
            return null;
        }
        return UUID.fromString(text);
    }
}

