/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.admin.domain;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import xyz.tcheeric.cashu.mint.admin.domain.AuditMetadata;
import xyz.tcheeric.cashu.mint.admin.domain.AutomationContext;
import xyz.tcheeric.cashu.mint.admin.domain.LifecycleContext;

public final class AuditTrail {
    private final List<AuditMetadata> entries;
    private final AuditMetadata auditMetadata;

    private AuditTrail(List<AuditMetadata> entries, AuditMetadata auditMetadata) {
        this.entries = List.copyOf(entries);
        this.auditMetadata = Objects.requireNonNull(auditMetadata, "audit metadata must not be null");
    }

    public static AuditTrail create(AuditMetadata initialEntry) {
        Objects.requireNonNull(initialEntry, "initial audit entry must not be null");
        return new AuditTrail(List.of(initialEntry), initialEntry);
    }

    public AuditTrail append(AuditMetadata entry) {
        Objects.requireNonNull(entry, "audit entry must not be null");
        ArrayList<AuditMetadata> updated = new ArrayList<AuditMetadata>(this.entries);
        updated.add(entry);
        return new AuditTrail(updated, entry);
    }

    public AuditMetadata latestMetadata() {
        return this.auditMetadata;
    }

    public List<String> latestReasonCodes() {
        return this.auditMetadata.reasonCodes();
    }

    public List<String> latestTicketReferences() {
        return this.auditMetadata.ticketReferences();
    }

    public AutomationContext latestAutomationContext() {
        return this.auditMetadata.automationContext();
    }

    public LifecycleContext latestLifecycleContext() {
        return this.auditMetadata.lifecycleContext();
    }

    @Generated
    public List<AuditMetadata> entries() {
        return this.entries;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuditTrail)) {
            return false;
        }
        AuditTrail other = (AuditTrail)o;
        List<AuditMetadata> this$entries = this.entries();
        List<AuditMetadata> other$entries = other.entries();
        if (this$entries == null ? other$entries != null : !((Object)this$entries).equals(other$entries)) {
            return false;
        }
        AuditMetadata this$auditMetadata = this.auditMetadata;
        AuditMetadata other$auditMetadata = other.auditMetadata;
        return !(this$auditMetadata == null ? other$auditMetadata != null : !((Object)this$auditMetadata).equals(other$auditMetadata));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<AuditMetadata> $entries = this.entries();
        result = result * 59 + ($entries == null ? 43 : ((Object)$entries).hashCode());
        AuditMetadata $auditMetadata = this.auditMetadata;
        result = result * 59 + ($auditMetadata == null ? 43 : ((Object)$auditMetadata).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AuditTrail(entries=" + String.valueOf(this.entries()) + ", auditMetadata=" + String.valueOf(this.auditMetadata) + ")";
    }
}

