/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.admin.domain;

import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import xyz.tcheeric.cashu.mint.admin.domain.AuditMetadata;
import xyz.tcheeric.cashu.mint.admin.domain.AuditTrail;
import xyz.tcheeric.cashu.mint.admin.domain.ConfigurationSet;
import xyz.tcheeric.cashu.mint.admin.domain.LifecycleContext;
import xyz.tcheeric.cashu.mint.admin.domain.LifecycleState;
import xyz.tcheeric.cashu.mint.admin.domain.MintId;
import xyz.tcheeric.cashu.mint.admin.domain.NotificationPolicy;
import xyz.tcheeric.cashu.mint.admin.domain.NotificationPolicySnapshot;
import xyz.tcheeric.cashu.mint.admin.domain.OperatorAccount;

public final class MintAggregate {
    private final MintId mintId;
    private final LifecycleState lifecycleState;
    private final ConfigurationSet configurationSet;
    private final OperatorAccount operatorAccount;
    private final NotificationPolicy notificationPolicy;
    private final AuditTrail auditTrail;
    private final AuditMetadata auditMetadata;

    private MintAggregate(MintId mintId, LifecycleState lifecycleState, ConfigurationSet configurationSet, OperatorAccount operatorAccount, NotificationPolicy notificationPolicy, AuditTrail auditTrail, AuditMetadata auditMetadata) {
        this.mintId = Objects.requireNonNull(mintId, "mint id must not be null");
        this.lifecycleState = Objects.requireNonNull(lifecycleState, "lifecycle state must not be null");
        this.configurationSet = Objects.requireNonNull(configurationSet, "configuration set must not be null");
        this.operatorAccount = Objects.requireNonNull(operatorAccount, "operator account must not be null");
        this.notificationPolicy = Objects.requireNonNull(notificationPolicy, "notification policy must not be null");
        this.auditTrail = Objects.requireNonNull(auditTrail, "audit trail must not be null");
        this.auditMetadata = Objects.requireNonNull(auditMetadata, "audit metadata must not be null");
        if (auditTrail.entries().isEmpty()) {
            throw new IllegalArgumentException("audit trail must contain at least one entry");
        }
        if (!auditTrail.latestMetadata().equals(auditMetadata)) {
            throw new IllegalArgumentException("latest audit metadata must match aggregate audit metadata");
        }
        LifecycleContext context = this.auditMetadata.lifecycleContext();
        if (context.hasConfigurationRevision() && !context.configurationRevisionId().equals(configurationSet.revisionId())) {
            throw new IllegalArgumentException("audit configuration revision must match aggregate configuration revision");
        }
        if (context.hasNotificationPolicySnapshot()) {
            boolean matchesPolicy;
            NotificationPolicySnapshot snapshot = context.notificationPolicySnapshot();
            AuditMetadata policyAudit = notificationPolicy.auditMetadata();
            boolean bl = matchesPolicy = snapshot.emailEnabled() == notificationPolicy.emailEnabled() && snapshot.webhookEnabled() == notificationPolicy.webhookEnabled() && snapshot.throttleInterval().equals(notificationPolicy.throttleInterval()) && snapshot.auditActor().equals(policyAudit.actor()) && snapshot.auditAction().equals(policyAudit.action()) && snapshot.auditTimestamp().equals(policyAudit.timestamp());
            if (!matchesPolicy) {
                throw new IllegalArgumentException("audit notification policy snapshot must match aggregate policy");
            }
        }
    }

    public static MintAggregate create(MintId mintId, ConfigurationSet configurationSet, OperatorAccount operatorAccount, NotificationPolicy notificationPolicy, AuditMetadata metadata) {
        AuditMetadata creationMetadata = Objects.requireNonNull(metadata, "audit metadata must not be null").withLifecycleContext(configurationSet.revisionId(), notificationPolicy);
        AuditTrail trail = AuditTrail.create(creationMetadata);
        return new MintAggregate(mintId, LifecycleState.provisioned(), configurationSet, operatorAccount, notificationPolicy, trail, creationMetadata);
    }

    public static MintAggregate reconstitute(MintId mintId, LifecycleState lifecycleState, ConfigurationSet configurationSet, OperatorAccount operatorAccount, NotificationPolicy notificationPolicy, AuditTrail auditTrail, AuditMetadata auditMetadata) {
        return new MintAggregate(mintId, lifecycleState, configurationSet, operatorAccount, notificationPolicy, auditTrail, auditMetadata);
    }

    public MintAggregate activate(AuditMetadata metadata) {
        return this.transitionLifecycleTo(LifecycleState.State.ACTIVE, metadata);
    }

    public MintAggregate suspend(AuditMetadata metadata) {
        return this.transitionLifecycleTo(LifecycleState.State.SUSPENDED, metadata);
    }

    public MintAggregate decommission(AuditMetadata metadata) {
        return this.transitionLifecycleTo(LifecycleState.State.DECOMMISSIONED, metadata);
    }

    public Optional<LifecycleState.TransitionApproval> approvalRequirementsFor(LifecycleState.State targetState) {
        return this.lifecycleState.approvalRequirementsFor(targetState);
    }

    public MintAggregate updateConfiguration(ConfigurationSet newConfiguration, AuditMetadata metadata) {
        ConfigurationSet configuration = Objects.requireNonNull(newConfiguration, "configuration must not be null");
        if (!configuration.revisionId().isAfter(this.configurationSet.revisionId())) {
            throw new IllegalArgumentException("configuration revision must advance");
        }
        return this.withChange(this.lifecycleState, configuration, this.operatorAccount, this.notificationPolicy, metadata);
    }

    public MintAggregate updateOperatorAccount(OperatorAccount newOperator, AuditMetadata metadata) {
        OperatorAccount operator = Objects.requireNonNull(newOperator, "operator account must not be null");
        return this.withChange(this.lifecycleState, this.configurationSet, operator, this.notificationPolicy, metadata);
    }

    public MintAggregate updateNotificationPolicy(NotificationPolicy newPolicy, AuditMetadata metadata) {
        NotificationPolicy policy = Objects.requireNonNull(newPolicy, "notification policy must not be null");
        return this.withChange(this.lifecycleState, this.configurationSet, this.operatorAccount, policy, metadata);
    }

    private MintAggregate withChange(LifecycleState state, ConfigurationSet configuration, OperatorAccount operator, NotificationPolicy policy, AuditMetadata metadata) {
        AuditMetadata audit = Objects.requireNonNull(metadata, "audit metadata must not be null").withLifecycleContext(configuration.revisionId(), policy);
        AuditTrail trail = this.auditTrail.append(audit);
        return new MintAggregate(this.mintId, state, configuration, operator, policy, trail, audit);
    }

    private MintAggregate transitionLifecycleTo(LifecycleState.State targetState, AuditMetadata metadata) {
        LifecycleState nextState = this.lifecycleState.transitionTo(targetState);
        return this.withChange(nextState, this.configurationSet, this.operatorAccount, this.notificationPolicy, metadata);
    }

    @Generated
    public MintId mintId() {
        return this.mintId;
    }

    @Generated
    public LifecycleState lifecycleState() {
        return this.lifecycleState;
    }

    @Generated
    public ConfigurationSet configurationSet() {
        return this.configurationSet;
    }

    @Generated
    public OperatorAccount operatorAccount() {
        return this.operatorAccount;
    }

    @Generated
    public NotificationPolicy notificationPolicy() {
        return this.notificationPolicy;
    }

    @Generated
    public AuditTrail auditTrail() {
        return this.auditTrail;
    }

    @Generated
    public AuditMetadata auditMetadata() {
        return this.auditMetadata;
    }
}

