/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.admin.domain;

import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import lombok.Generated;
import xyz.tcheeric.cashu.mint.admin.domain.MintId;

public final class OutboxMessage {
    private final UUID eventId;
    private final MintId aggregateId;
    private final String aggregateType;
    private final String eventType;
    private final String payload;
    private final Map<String, String> attributes;
    private final Instant occurredAt;
    private final Instant availableAt;
    private final Instant lastAttemptAt;
    private final Instant dispatchedAt;
    private final int deliveryAttempts;

    public OutboxMessage(UUID eventId, MintId aggregateId, String aggregateType, String eventType, String payload, Map<String, String> attributes, Instant occurredAt, Instant availableAt, Instant lastAttemptAt, Instant dispatchedAt, int deliveryAttempts) {
        this.eventId = Objects.requireNonNull(eventId, "event id must not be null");
        this.aggregateId = Objects.requireNonNull(aggregateId, "aggregate id must not be null");
        this.aggregateType = OutboxMessage.requireNonBlank(aggregateType, "aggregate type");
        this.eventType = OutboxMessage.requireNonBlank(eventType, "event type");
        this.payload = OutboxMessage.requireNonBlank(payload, "payload");
        this.attributes = Map.copyOf(attributes == null ? Map.of() : attributes);
        this.occurredAt = Objects.requireNonNull(occurredAt, "occurred at must not be null");
        this.availableAt = Objects.requireNonNull(availableAt, "available at must not be null");
        this.lastAttemptAt = lastAttemptAt;
        this.dispatchedAt = dispatchedAt;
        if (deliveryAttempts < 0) {
            throw new IllegalArgumentException("delivery attempts must not be negative");
        }
        this.deliveryAttempts = deliveryAttempts;
    }

    private static String requireNonBlank(String value, String fieldName) {
        if (value == null || value.isBlank()) {
            throw new IllegalArgumentException(fieldName + " must not be blank");
        }
        return value;
    }

    public OutboxMessage scheduleRetry(Instant attemptTime, Instant nextAvailableAt) {
        Instant lastAttempt = Objects.requireNonNull(attemptTime, "attempt time must not be null");
        Instant nextAvailable = Objects.requireNonNull(nextAvailableAt, "next availability must not be null");
        return new OutboxMessage(this.eventId, this.aggregateId, this.aggregateType, this.eventType, this.payload, this.attributes, this.occurredAt, nextAvailable, lastAttempt, this.dispatchedAt, this.deliveryAttempts + 1);
    }

    public OutboxMessage markDispatched(Instant dispatchTime) {
        Instant dispatched = Objects.requireNonNull(dispatchTime, "dispatch time must not be null");
        return new OutboxMessage(this.eventId, this.aggregateId, this.aggregateType, this.eventType, this.payload, this.attributes, this.occurredAt, this.availableAt, dispatched, dispatched, this.deliveryAttempts);
    }

    @Generated
    public UUID eventId() {
        return this.eventId;
    }

    @Generated
    public MintId aggregateId() {
        return this.aggregateId;
    }

    @Generated
    public String aggregateType() {
        return this.aggregateType;
    }

    @Generated
    public String eventType() {
        return this.eventType;
    }

    @Generated
    public String payload() {
        return this.payload;
    }

    @Generated
    public Map<String, String> attributes() {
        return this.attributes;
    }

    @Generated
    public Instant occurredAt() {
        return this.occurredAt;
    }

    @Generated
    public Instant availableAt() {
        return this.availableAt;
    }

    @Generated
    public Instant lastAttemptAt() {
        return this.lastAttemptAt;
    }

    @Generated
    public Instant dispatchedAt() {
        return this.dispatchedAt;
    }

    @Generated
    public int deliveryAttempts() {
        return this.deliveryAttempts;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OutboxMessage)) {
            return false;
        }
        OutboxMessage other = (OutboxMessage)o;
        if (this.deliveryAttempts() != other.deliveryAttempts()) {
            return false;
        }
        UUID this$eventId = this.eventId();
        UUID other$eventId = other.eventId();
        if (this$eventId == null ? other$eventId != null : !((Object)this$eventId).equals(other$eventId)) {
            return false;
        }
        MintId this$aggregateId = this.aggregateId();
        MintId other$aggregateId = other.aggregateId();
        if (this$aggregateId == null ? other$aggregateId != null : !((Object)this$aggregateId).equals(other$aggregateId)) {
            return false;
        }
        String this$aggregateType = this.aggregateType();
        String other$aggregateType = other.aggregateType();
        if (this$aggregateType == null ? other$aggregateType != null : !this$aggregateType.equals(other$aggregateType)) {
            return false;
        }
        String this$eventType = this.eventType();
        String other$eventType = other.eventType();
        if (this$eventType == null ? other$eventType != null : !this$eventType.equals(other$eventType)) {
            return false;
        }
        String this$payload = this.payload();
        String other$payload = other.payload();
        if (this$payload == null ? other$payload != null : !this$payload.equals(other$payload)) {
            return false;
        }
        Map<String, String> this$attributes = this.attributes();
        Map<String, String> other$attributes = other.attributes();
        if (this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes)) {
            return false;
        }
        Instant this$occurredAt = this.occurredAt();
        Instant other$occurredAt = other.occurredAt();
        if (this$occurredAt == null ? other$occurredAt != null : !((Object)this$occurredAt).equals(other$occurredAt)) {
            return false;
        }
        Instant this$availableAt = this.availableAt();
        Instant other$availableAt = other.availableAt();
        if (this$availableAt == null ? other$availableAt != null : !((Object)this$availableAt).equals(other$availableAt)) {
            return false;
        }
        Instant this$lastAttemptAt = this.lastAttemptAt();
        Instant other$lastAttemptAt = other.lastAttemptAt();
        if (this$lastAttemptAt == null ? other$lastAttemptAt != null : !((Object)this$lastAttemptAt).equals(other$lastAttemptAt)) {
            return false;
        }
        Instant this$dispatchedAt = this.dispatchedAt();
        Instant other$dispatchedAt = other.dispatchedAt();
        return !(this$dispatchedAt == null ? other$dispatchedAt != null : !((Object)this$dispatchedAt).equals(other$dispatchedAt));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.deliveryAttempts();
        UUID $eventId = this.eventId();
        result = result * 59 + ($eventId == null ? 43 : ((Object)$eventId).hashCode());
        MintId $aggregateId = this.aggregateId();
        result = result * 59 + ($aggregateId == null ? 43 : ((Object)$aggregateId).hashCode());
        String $aggregateType = this.aggregateType();
        result = result * 59 + ($aggregateType == null ? 43 : $aggregateType.hashCode());
        String $eventType = this.eventType();
        result = result * 59 + ($eventType == null ? 43 : $eventType.hashCode());
        String $payload = this.payload();
        result = result * 59 + ($payload == null ? 43 : $payload.hashCode());
        Map<String, String> $attributes = this.attributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        Instant $occurredAt = this.occurredAt();
        result = result * 59 + ($occurredAt == null ? 43 : ((Object)$occurredAt).hashCode());
        Instant $availableAt = this.availableAt();
        result = result * 59 + ($availableAt == null ? 43 : ((Object)$availableAt).hashCode());
        Instant $lastAttemptAt = this.lastAttemptAt();
        result = result * 59 + ($lastAttemptAt == null ? 43 : ((Object)$lastAttemptAt).hashCode());
        Instant $dispatchedAt = this.dispatchedAt();
        result = result * 59 + ($dispatchedAt == null ? 43 : ((Object)$dispatchedAt).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "OutboxMessage(eventId=" + String.valueOf(this.eventId()) + ", aggregateId=" + String.valueOf(this.aggregateId()) + ", aggregateType=" + this.aggregateType() + ", eventType=" + this.eventType() + ", payload=" + this.payload() + ", attributes=" + String.valueOf(this.attributes()) + ", occurredAt=" + String.valueOf(this.occurredAt()) + ", availableAt=" + String.valueOf(this.availableAt()) + ", lastAttemptAt=" + String.valueOf(this.lastAttemptAt()) + ", dispatchedAt=" + String.valueOf(this.dispatchedAt()) + ", deliveryAttempts=" + this.deliveryAttempts() + ")";
    }
}

