/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.admin.presentation.lifecycle;

import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import xyz.tcheeric.cashu.mint.admin.presentation.lifecycle.LifecycleAction;
import xyz.tcheeric.cashu.mint.admin.presentation.lifecycle.LifecycleSummary;

public final class LifecycleSummaryPresenter {
    private final Map<LifecycleAction, MessageTemplate> templates;

    public LifecycleSummaryPresenter() {
        this.templates = this.defaultTemplates();
    }

    public LifecycleSummaryPresenter(Map<LifecycleAction, MessageTemplate> templates) {
        this.templates = Map.copyOf(Objects.requireNonNull(templates, "templates"));
    }

    public LifecycleSummary present(LifecycleSummaryRequest request) {
        Objects.requireNonNull(request, "request");
        MessageTemplate template = this.templates.get((Object)request.operation());
        if (template == null) {
            throw new IllegalArgumentException("No message template configured for " + String.valueOf((Object)request.operation()));
        }
        String message = template.messageFor(request.changed());
        return new LifecycleSummary(request.operation(), request.mintId(), request.previousState(), request.currentState(), request.versionTag(), request.changed(), message);
    }

    public LifecycleSummary present(LifecycleAction operation, String mintId, String previousState, String currentState, String versionTag, boolean changed) {
        return this.present(new LifecycleSummaryRequest(operation, mintId, previousState, currentState, versionTag, changed));
    }

    private Map<LifecycleAction, MessageTemplate> defaultTemplates() {
        EnumMap<LifecycleAction, MessageTemplate> defaults = new EnumMap<LifecycleAction, MessageTemplate>(LifecycleAction.class);
        defaults.put(LifecycleAction.CREATE, new MessageTemplate("Mint created", "Mint already exists"));
        defaults.put(LifecycleAction.UPDATE, new MessageTemplate("Mint updated", "No changes applied"));
        defaults.put(LifecycleAction.PAUSE, new MessageTemplate("Mint paused", "Mint already suspended"));
        defaults.put(LifecycleAction.RESUME, new MessageTemplate("Mint resumed", "Mint already active"));
        defaults.put(LifecycleAction.RETIRE, new MessageTemplate("Mint retired", "Mint already retired"));
        return defaults;
    }

    public record LifecycleSummaryRequest(LifecycleAction operation, String mintId, String previousState, String currentState, String versionTag, boolean changed) {
        public LifecycleSummaryRequest {
            operation = Objects.requireNonNull(operation, "operation");
            mintId = LifecycleSummaryRequest.requireText(mintId, "mintId");
            currentState = LifecycleSummaryRequest.requireText(currentState, "currentState");
            versionTag = LifecycleSummaryRequest.requireText(versionTag, "versionTag");
        }

        private static String requireText(String value, String fieldName) {
            if (value == null || value.isBlank()) {
                throw new IllegalArgumentException(fieldName + " must not be blank");
            }
            return value;
        }
    }

    public record MessageTemplate(String changedMessage, String idempotentMessage) {
        public MessageTemplate {
            changedMessage = Objects.requireNonNull(changedMessage, "changedMessage");
            idempotentMessage = Objects.requireNonNull(idempotentMessage, "idempotentMessage");
        }

        String messageFor(boolean changed) {
            return changed ? this.changedMessage : this.idempotentMessage;
        }
    }
}

