/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.admin.rest.controller;

import java.util.Locale;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.server.ResponseStatusException;
import xyz.tcheeric.cashu.mint.admin.rest.dto.common.AdminErrorResponse;
import xyz.tcheeric.cashu.mint.admin.rest.service.AdminServiceException;

@RestControllerAdvice(basePackages={"xyz.tcheeric.cashu.mint.admin.rest"})
@Order(value=-2147483648)
class AdminApiExceptionHandler {
    AdminApiExceptionHandler() {
    }

    @ExceptionHandler(value={ResponseStatusException.class})
    ResponseEntity<AdminErrorResponse> onResponseStatusException(ResponseStatusException ex) {
        int statusCode = ex.getStatusCode().value();
        HttpStatus status = HttpStatus.resolve((int)statusCode);
        String error = status != null ? status.getReasonPhrase() : ex.getStatusCode().toString();
        String code = status != null ? status.name().toLowerCase(Locale.ROOT) : "error";
        String message = ex.getReason() != null && !ex.getReason().isBlank() ? ex.getReason() : error;
        AdminErrorResponse body = new AdminErrorResponse(statusCode, error, code, message);
        return ResponseEntity.status((int)statusCode).body((Object)body);
    }

    @ExceptionHandler(value={AdminServiceException.class})
    ResponseEntity<AdminErrorResponse> onAdminServiceException(AdminServiceException ex) {
        HttpStatus status = ex.getStatus();
        AdminErrorResponse body = new AdminErrorResponse(status.value(), status.getReasonPhrase(), ex.getCode(), ex.getMessage());
        return ResponseEntity.status((HttpStatusCode)status).body((Object)body);
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    ResponseEntity<AdminErrorResponse> onIllegalArgument(IllegalArgumentException ex) {
        HttpStatus status = HttpStatus.BAD_REQUEST;
        AdminErrorResponse body = new AdminErrorResponse(status.value(), status.getReasonPhrase(), "invalid_request", ex.getMessage() == null ? status.getReasonPhrase() : ex.getMessage());
        return ResponseEntity.status((HttpStatusCode)status).body((Object)body);
    }
}

