/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.admin.rest.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import xyz.tcheeric.cashu.mint.admin.rest.dto.common.AdminErrorResponse;
import xyz.tcheeric.cashu.mint.admin.rest.dto.users.AssignRolesRequest;
import xyz.tcheeric.cashu.mint.admin.rest.dto.users.CreateUserRequest;
import xyz.tcheeric.cashu.mint.admin.rest.dto.users.CredentialResetResponse;
import xyz.tcheeric.cashu.mint.admin.rest.dto.users.ResetCredentialsRequest;
import xyz.tcheeric.cashu.mint.admin.rest.dto.users.UpdateUserRequest;
import xyz.tcheeric.cashu.mint.admin.rest.dto.users.UserLifecycleRequest;
import xyz.tcheeric.cashu.mint.admin.rest.dto.users.UserResponse;
import xyz.tcheeric.cashu.mint.admin.rest.service.AdminUserService;

@Tag(name="Admin Users", description="Operator management workflows mirrored from CLI commands")
@SecurityRequirements(value={@SecurityRequirement(name="AdminToken"), @SecurityRequirement(name="AdminRoles")})
@RestController
@RequestMapping(value={"/admin/users"})
public class UsersAdminController {
    private final AdminUserService userService;

    public UsersAdminController(AdminUserService userService) {
        this.userService = userService;
    }

    @Operation(summary="Create an operator", description="Provision a new operator account, mirroring the CLI workflow.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="User created", content={@Content(schema=@Schema(implementation=UserResponse.class))}), @ApiResponse(responseCode="409", description="User already exists", content={@Content(schema=@Schema(implementation=AdminErrorResponse.class))})})
    @PostMapping
    public ResponseEntity<UserResponse> createUser(@Valid @RequestBody CreateUserRequest request) {
        return ResponseEntity.ok((Object)this.userService.createUser(request));
    }

    @Operation(summary="Update an operator", description="Update operator details, mirroring the CLI user update command.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="User updated", content={@Content(schema=@Schema(implementation=UserResponse.class))}), @ApiResponse(responseCode="404", description="User not found", content={@Content(schema=@Schema(implementation=AdminErrorResponse.class))})})
    @PutMapping(value={"/{userId}"})
    public ResponseEntity<UserResponse> updateUser(@PathVariable(value="userId") String userId, @Valid @RequestBody UpdateUserRequest request) {
        return ResponseEntity.ok((Object)this.userService.updateUser(userId, request));
    }

    @Operation(summary="Assign operator roles", description="Assign or replace roles on an operator account.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Roles updated", content={@Content(schema=@Schema(implementation=UserResponse.class))}), @ApiResponse(responseCode="404", description="User not found", content={@Content(schema=@Schema(implementation=AdminErrorResponse.class))})})
    @PostMapping(value={"/{userId}/roles"})
    public ResponseEntity<UserResponse> assignRoles(@PathVariable(value="userId") String userId, @Valid @RequestBody AssignRolesRequest request) {
        return ResponseEntity.ok((Object)this.userService.assignRoles(userId, request));
    }

    @Operation(summary="Reset operator credentials", description="Initiate a credential reset workflow for an operator.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Reset token issued", content={@Content(schema=@Schema(implementation=CredentialResetResponse.class))}), @ApiResponse(responseCode="404", description="User not found", content={@Content(schema=@Schema(implementation=AdminErrorResponse.class))})})
    @PostMapping(value={"/{userId}/reset-credentials"})
    public ResponseEntity<CredentialResetResponse> resetCredentials(@PathVariable(value="userId") String userId, @Valid @RequestBody ResetCredentialsRequest request) {
        return ResponseEntity.ok((Object)this.userService.resetCredentials(userId, request));
    }

    @Operation(summary="Deactivate an operator", description="Deactivate an operator account, mirroring the CLI lifecycle flow.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="User deactivated", content={@Content(schema=@Schema(implementation=UserResponse.class))}), @ApiResponse(responseCode="404", description="User not found", content={@Content(schema=@Schema(implementation=AdminErrorResponse.class))})})
    @PostMapping(value={"/{userId}/deactivate"})
    public ResponseEntity<UserResponse> deactivateUser(@PathVariable(value="userId") String userId, @Valid @RequestBody UserLifecycleRequest request) {
        return ResponseEntity.ok((Object)this.userService.deactivateUser(userId, request));
    }
}

