/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.admin.rest.service;

import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import xyz.tcheeric.cashu.mint.admin.framework.CorrelationIdContext;
import xyz.tcheeric.cashu.mint.admin.presentation.lifecycle.LifecycleAction;
import xyz.tcheeric.cashu.mint.admin.presentation.lifecycle.LifecycleSummary;
import xyz.tcheeric.cashu.mint.admin.presentation.lifecycle.LifecycleSummaryPresenter;
import xyz.tcheeric.cashu.mint.admin.rest.dto.lifecycle.CreateMintRequest;
import xyz.tcheeric.cashu.mint.admin.rest.dto.lifecycle.LifecycleActionResponse;
import xyz.tcheeric.cashu.mint.admin.rest.dto.lifecycle.LifecycleChangeRequest;
import xyz.tcheeric.cashu.mint.admin.rest.dto.lifecycle.UpdateMintRequest;
import xyz.tcheeric.cashu.mint.admin.rest.presenter.LifecycleSummaryApiPresenter;
import xyz.tcheeric.cashu.mint.admin.rest.service.AdminLifecycleService;
import xyz.tcheeric.cashu.mint.admin.rest.service.AdminServiceException;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class AdminLifecycleService {
    private static final String DEFAULT_VERSION_TAG = "v1";
    private final ConcurrentMap<String, MintRecord> lifecycleState;
    private final LifecycleSummaryPresenter summaryPresenter;
    private final LifecycleSummaryApiPresenter apiPresenter;

    public AdminLifecycleService(ConcurrentMap<String, MintRecord> lifecycleState, LifecycleSummaryPresenter summaryPresenter, LifecycleSummaryApiPresenter apiPresenter) {
        this.lifecycleState = Objects.requireNonNull(lifecycleState, "lifecycleState");
        this.summaryPresenter = Objects.requireNonNull(summaryPresenter, "summaryPresenter");
        this.apiPresenter = Objects.requireNonNull(apiPresenter, "apiPresenter");
    }

    public LifecycleActionResponse createMint(CreateMintRequest request) {
        Objects.requireNonNull(request, "request");
        AtomicReference summaryRef = new AtomicReference();
        this.lifecycleState.compute(request.mintId(), (id, current) -> {
            if (current != null) {
                summaryRef.set(this.present(LifecycleAction.CREATE, id, current.status.name(), current.status.name(), current.versionTag, false));
                return current;
            }
            String versionTag = AdminLifecycleService.extractVersionTag((Map)request.configuration(), (String)"v1");
            MintRecord created = new MintRecord(LifecycleStatus.PROVISIONED, versionTag, request.metadata(), AdminLifecycleService.normalizeConfiguration((Map)request.configuration()));
            summaryRef.set(this.present(LifecycleAction.CREATE, id, null, created.status.name(), created.versionTag, true));
            return created;
        });
        return this.apiPresenter.present((LifecycleSummary)summaryRef.get());
    }

    public LifecycleActionResponse updateMint(String mintId, UpdateMintRequest request) {
        Objects.requireNonNull(request, "request");
        AtomicReference summaryRef = new AtomicReference();
        this.lifecycleState.compute(mintId, (id, current) -> {
            if (current == null) {
                summaryRef.set(null);
                return null;
            }
            Map normalizedConfig = AdminLifecycleService.normalizeConfiguration((Map)request.configuration());
            String newVersionTag = AdminLifecycleService.extractVersionTag((Map)request.configuration(), (String)request.revisionId());
            boolean metadataChanged = !Objects.equals(current.metadata, request.metadata());
            boolean configChanged = !Objects.equals(current.configuration, normalizedConfig);
            boolean versionChanged = !Objects.equals(current.versionTag, newVersionTag);
            current.metadata = request.metadata();
            current.configuration = normalizedConfig;
            current.versionTag = newVersionTag;
            boolean changed = metadataChanged || configChanged || versionChanged;
            summaryRef.set(this.present(LifecycleAction.UPDATE, id, current.status.name(), current.status.name(), current.versionTag, changed));
            return current;
        });
        LifecycleSummary summary = (LifecycleSummary)summaryRef.get();
        if (summary == null) {
            throw new AdminServiceException(HttpStatus.NOT_FOUND, "mint_not_found", "Mint not found: " + mintId);
        }
        return this.apiPresenter.present(summary);
    }

    public LifecycleActionResponse pauseMint(String mintId, LifecycleChangeRequest request) {
        return this.apiPresenter.present(this.transition(mintId, request, LifecycleStatus.SUSPENDED, LifecycleAction.PAUSE));
    }

    public LifecycleActionResponse resumeMint(String mintId, LifecycleChangeRequest request) {
        return this.apiPresenter.present(this.transition(mintId, request, LifecycleStatus.ACTIVE, LifecycleAction.RESUME));
    }

    public LifecycleActionResponse retireMint(String mintId, LifecycleChangeRequest request) {
        return this.apiPresenter.present(this.transition(mintId, request, LifecycleStatus.DECOMMISSIONED, LifecycleAction.RETIRE));
    }

    private LifecycleSummary transition(String mintId, LifecycleChangeRequest request, LifecycleStatus target, LifecycleAction operation) {
        Objects.requireNonNull(request, "request");
        AtomicReference summaryRef = new AtomicReference();
        this.lifecycleState.compute(mintId, (id, current) -> {
            if (current == null) {
                summaryRef.set(null);
                return null;
            }
            LifecycleStatus previous = current.status;
            boolean changed = previous != target;
            current.status = target;
            current.versionTag = AdminLifecycleService.transitionVersionTag((LifecycleChangeRequest)request, (String)current.versionTag);
            summaryRef.set(this.present(operation, id, previous.name(), current.status.name(), current.versionTag, changed));
            return current;
        });
        LifecycleSummary summary = (LifecycleSummary)summaryRef.get();
        if (summary == null) {
            throw new AdminServiceException(HttpStatus.NOT_FOUND, "mint_not_found", "Mint not found: " + mintId);
        }
        return summary;
    }

    private LifecycleSummary present(LifecycleAction operation, String mintId, String previousState, String currentState, String versionTag, boolean changed) {
        return this.summaryPresenter.present(new LifecycleSummaryPresenter.LifecycleSummaryRequest(operation, mintId, previousState, currentState, versionTag, changed));
    }

    private static Map<String, Object> normalizeConfiguration(Map<String, Object> configuration) {
        if (configuration == null || configuration.isEmpty()) {
            return Map.of();
        }
        return Map.copyOf(configuration);
    }

    private static String extractVersionTag(Map<String, Object> configuration, String fallback) {
        return Optional.ofNullable(configuration).map(config -> {
            String alt;
            String str;
            Object primary = config.get("versionTag");
            if (primary instanceof String && !(str = (String)primary).isBlank()) {
                return str;
            }
            Object alternative = config.get("version_tag");
            if (alternative instanceof String && !(alt = (String)alternative).isBlank()) {
                return alt;
            }
            return null;
        }).filter(tag -> !tag.isBlank()).orElse(fallback);
    }

    private static String transitionVersionTag(LifecycleChangeRequest request, String currentVersionTag) {
        if (request.correlationId() != null && !request.correlationId().isBlank()) {
            return request.correlationId();
        }
        String contextId = CorrelationIdContext.currentId();
        if (contextId != null && !contextId.isBlank()) {
            return contextId;
        }
        if (request.reason() != null && !request.reason().isBlank()) {
            return request.reason().trim().toLowerCase(Locale.ROOT).replace(' ', '-');
        }
        return currentVersionTag != null && !currentVersionTag.isBlank() ? currentVersionTag : "v1";
    }
}

