/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.nostr.cashu.operation;

import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import nostr.event.entities.CashuProof;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.cashu.common.PaymentMethod;
import xyz.tcheeric.cashu.common.Secret;
import xyz.tcheeric.cashu.entities.rest.PostMeltQuoteRequest;
import xyz.tcheeric.cashu.entities.rest.PostMeltQuoteResponse;
import xyz.tcheeric.cashu.entities.rest.PostMeltRequest;
import xyz.tcheeric.cashu.entities.rest.PostMeltResponse;
import xyz.tcheeric.nostr.cashu.operation.BaseOperation;
import xyz.tcheeric.nostr.cashu.operation.SwapOperation;
import xyz.tcheeric.nostr.cashu.util.AsyncExecutor;
import xyz.tcheeric.nostr.cashu.util.DefaultAsyncExecutor;
import xyz.tcheeric.nostr.cashu.util.TokenUtil;
import xyz.tcheeric.nostr.cashu.util.WalletUtil;
import xyz.tcheeric.nostr.cashu.wallet.service.MeltingService;
import xyz.tcheeric.nostr.cashu.wallet.service.impl.DefaultMeltingService;

public class MeltOperation<T extends Secret>
extends BaseOperation {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MeltOperation.class);
    private AsyncExecutor executor = new DefaultAsyncExecutor();
    private MeltingService<T> meltingService;
    private volatile List<CashuProof> proofs;
    private volatile PostMeltResponse response;

    public MeltOperation(@NonNull PaymentMethod paymentMethod, @NonNull String mintUrl) {
        this(paymentMethod, mintUrl, new DefaultAsyncExecutor(), new DefaultMeltingService(paymentMethod, mintUrl));
        if (paymentMethod == null) {
            throw new NullPointerException("paymentMethod is marked non-null but is null");
        }
        if (mintUrl == null) {
            throw new NullPointerException("mintUrl is marked non-null but is null");
        }
    }

    public MeltOperation(@NonNull PaymentMethod paymentMethod, @NonNull String mintUrl, @NonNull AsyncExecutor executor) {
        this(paymentMethod, mintUrl, executor, new DefaultMeltingService(paymentMethod, mintUrl));
        if (paymentMethod == null) {
            throw new NullPointerException("paymentMethod is marked non-null but is null");
        }
        if (mintUrl == null) {
            throw new NullPointerException("mintUrl is marked non-null but is null");
        }
        if (executor == null) {
            throw new NullPointerException("executor is marked non-null but is null");
        }
    }

    public MeltOperation(@NonNull PaymentMethod paymentMethod, @NonNull String mintUrl, @NonNull AsyncExecutor executor, @NonNull MeltingService<T> meltingService) {
        super(paymentMethod, mintUrl, null);
        if (paymentMethod == null) {
            throw new NullPointerException("paymentMethod is marked non-null but is null");
        }
        if (mintUrl == null) {
            throw new NullPointerException("mintUrl is marked non-null but is null");
        }
        if (executor == null) {
            throw new NullPointerException("executor is marked non-null but is null");
        }
        if (meltingService == null) {
            throw new NullPointerException("meltingService is marked non-null but is null");
        }
        this.executor = executor;
        this.meltingService = meltingService;
    }

    public PostMeltQuoteResponse quote(@NonNull PostMeltQuoteRequest postMeltQuoteRequest) {
        if (postMeltQuoteRequest == null) {
            throw new NullPointerException("postMeltQuoteRequest is marked non-null but is null");
        }
        log.debug("quote called");
        log.debug("quote({})", (Object)postMeltQuoteRequest);
        PostMeltQuoteResponse postMeltQuoteResponse = this.executor.execute(() -> this.meltingService.quote(postMeltQuoteRequest)).join();
        if (postMeltQuoteResponse == null) {
            throw new IllegalStateException("Quote not received");
        }
        return postMeltQuoteResponse;
    }

    PostMeltResponse melt(@NonNull String quoteId, @NonNull PostMeltRequest<T> postMeltRequest) {
        if (quoteId == null) {
            throw new NullPointerException("quoteId is marked non-null but is null");
        }
        if (postMeltRequest == null) {
            throw new NullPointerException("postMeltRequest is marked non-null but is null");
        }
        log.debug("execute called");
        log.debug("execute({}, {})", (Object)quoteId, postMeltRequest);
        PostMeltQuoteResponse quoteState = this.executor.execute(() -> this.meltingService.getQuote(quoteId)).join();
        if (quoteState == null || !quoteState.isPaid()) {
            throw new IllegalStateException("Melt quote has not been paid");
        }
        PostMeltResponse postMeltResponse = this.executor.execute(() -> this.meltingService.melt(postMeltRequest)).join();
        if (postMeltResponse == null) {
            throw new IllegalStateException("Melting error occurred. PostMeltResponse not received");
        }
        return postMeltResponse;
    }

    PostMeltResponse melt(@NonNull PostMeltQuoteResponse quote, @NonNull PostMeltRequest<T> postMeltRequest) {
        if (quote == null) {
            throw new NullPointerException("quote is marked non-null but is null");
        }
        if (postMeltRequest == null) {
            throw new NullPointerException("postMeltRequest is marked non-null but is null");
        }
        return this.melt(quote.getQuoteId(), postMeltRequest);
    }

    public MeltOperation<T> melt(@NonNull PostMeltQuoteResponse quote, @NonNull SwapOperation<T> swapOperation, @NonNull WalletUtil<T> walletUtil) {
        if (quote == null) {
            throw new NullPointerException("quote is marked non-null but is null");
        }
        if (swapOperation == null) {
            throw new NullPointerException("swapOperation is marked non-null but is null");
        }
        if (walletUtil == null) {
            throw new NullPointerException("walletUtil is marked non-null but is null");
        }
        log.debug("melt called");
        log.info("melt({})", (Object)quote);
        if (!quote.isPaid()) {
            throw new IllegalStateException("Melt quote has not been paid");
        }
        int amount = quote.getAmount() + quote.getFeeReserve();
        this.proofs = walletUtil.extractProofsFromTokens(amount, swapOperation);
        PostMeltRequest request = new PostMeltRequest();
        request.setQuoteId(quote.getQuoteId());
        request.setInputs(TokenUtil.toCashuProofList(this.proofs));
        try {
            this.response = this.melt(quote, request);
            if (this.response.isPaid()) {
                walletUtil.commitPendingTokens(swapOperation.getUnit());
            } else {
                walletUtil.restorePendingTokens(swapOperation.getUnit());
            }
        }
        catch (RuntimeException e) {
            walletUtil.restorePendingTokens(swapOperation.getUnit());
            throw e;
        }
        return this;
    }

    public List<CashuProof> getProofs() {
        return this.proofs;
    }

    public PostMeltResponse getResponse() {
        return this.response;
    }

    @Generated
    public MeltOperation() {
    }
}

