/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.nostr.cashu.operation;

import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.bouncycastle.math.ec.ECPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.cashu.common.PaymentMethod;
import xyz.tcheeric.cashu.common.PublicKey;
import xyz.tcheeric.cashu.common.Secret;
import xyz.tcheeric.cashu.crypto.BDHKEUtils;
import xyz.tcheeric.cashu.entities.rest.PostCheckStateRequest;
import xyz.tcheeric.cashu.entities.rest.PostCheckStateResponse;
import xyz.tcheeric.nostr.cashu.operation.BaseOperation;
import xyz.tcheeric.nostr.cashu.util.AsyncExecutor;
import xyz.tcheeric.nostr.cashu.util.DefaultAsyncExecutor;
import xyz.tcheeric.nostr.cashu.wallet.service.TokenStateService;
import xyz.tcheeric.nostr.cashu.wallet.service.impl.DefaultTokenStateService;

public class TokenStateOperation
extends BaseOperation {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TokenStateOperation.class);
    private AsyncExecutor executor = new DefaultAsyncExecutor();
    private TokenStateService tokenStateService;

    public TokenStateOperation(@NonNull PaymentMethod paymentMethod, @NonNull String mintUrl) {
        this(paymentMethod, mintUrl, new DefaultAsyncExecutor(), new DefaultTokenStateService(mintUrl));
        if (paymentMethod == null) {
            throw new NullPointerException("paymentMethod is marked non-null but is null");
        }
        if (mintUrl == null) {
            throw new NullPointerException("mintUrl is marked non-null but is null");
        }
    }

    public TokenStateOperation(@NonNull PaymentMethod paymentMethod, @NonNull String mintUrl, @NonNull AsyncExecutor executor) {
        this(paymentMethod, mintUrl, executor, new DefaultTokenStateService(mintUrl));
        if (paymentMethod == null) {
            throw new NullPointerException("paymentMethod is marked non-null but is null");
        }
        if (mintUrl == null) {
            throw new NullPointerException("mintUrl is marked non-null but is null");
        }
        if (executor == null) {
            throw new NullPointerException("executor is marked non-null but is null");
        }
    }

    public TokenStateOperation(@NonNull PaymentMethod paymentMethod, @NonNull String mintUrl, @NonNull AsyncExecutor executor, @NonNull TokenStateService tokenStateService) {
        super(paymentMethod, mintUrl, null);
        if (paymentMethod == null) {
            throw new NullPointerException("paymentMethod is marked non-null but is null");
        }
        if (mintUrl == null) {
            throw new NullPointerException("mintUrl is marked non-null but is null");
        }
        if (executor == null) {
            throw new NullPointerException("executor is marked non-null but is null");
        }
        if (tokenStateService == null) {
            throw new NullPointerException("tokenStateService is marked non-null but is null");
        }
        this.executor = executor;
        this.tokenStateService = tokenStateService;
    }

    public PostCheckStateResponse check(@NonNull List<Secret> secrets) {
        if (secrets == null) {
            throw new NullPointerException("secrets is marked non-null but is null");
        }
        log.debug("checkState called");
        List hashToCurveSecrets = secrets.stream().map(s -> BDHKEUtils.hashToCurve((byte[])s.toBytes())).map(ecPoint -> PublicKey.fromPoint((ECPoint)ecPoint)).collect(Collectors.toList());
        PostCheckStateRequest postCheckStateRequest = new PostCheckStateRequest(hashToCurveSecrets);
        PostCheckStateResponse postCheckStateResponse = this.executor.execute(() -> this.tokenStateService.check(postCheckStateRequest)).join();
        if (postCheckStateResponse == null) {
            throw new IllegalStateException("Proofs' states not received");
        }
        return postCheckStateResponse;
    }
}

