/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.nostr.cashu.parser;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import lombok.Generated;
import lombok.NonNull;
import nostr.base.Marker;
import nostr.event.entities.Amount;
import nostr.event.entities.SpendingHistory;
import nostr.event.tag.EventTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpendingHistoryParser {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpendingHistoryParser.class);

    public SpendingHistory parse(@NonNull String content, @NonNull String unit) {
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        log.debug("parse called");
        try {
            JsonNode contentNode = new ObjectMapper().readTree(content);
            return SpendingHistory.builder().amount(new Amount(Integer.valueOf(StreamSupport.stream(contentNode.spliterator(), false).filter(node -> node.get(0).asText().equals("amount")).mapToInt(node -> node.get(1).asInt()).sum()), unit)).direction(this.getDirection(contentNode)).eventTags(StreamSupport.stream(contentNode.spliterator(), false).filter(node -> node.get(0).asText().equals("e")).map(tag -> {
                EventTag eventTag = new EventTag();
                eventTag.setIdEvent(tag.get(1).asText());
                eventTag.setRecommendedRelayUrl(tag.get(2).asText());
                eventTag.setMarker(Marker.valueOf((String)tag.get(3).asText().toUpperCase()));
                return eventTag;
            }).collect(Collectors.toList())).build();
        }
        catch (JsonProcessingException e) {
            log.error("Error parsing spending history content: {}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public SpendingHistory.Direction getDirection(@NonNull String content) {
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        log.debug("getDirection called");
        try {
            JsonNode node = new ObjectMapper().readTree(content);
            return this.getDirection(node);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private SpendingHistory.Direction getDirection(JsonNode contentNode) {
        return StreamSupport.stream(contentNode.spliterator(), false).filter(node -> node.get(0).asText().equals("direction")).map(node -> {
            String direction = node.get(1).asText().toUpperCase();
            if ("IN".equals(direction)) {
                return SpendingHistory.Direction.RECEIVED;
            }
            if ("OUT".equals(direction)) {
                return SpendingHistory.Direction.SENT;
            }
            throw new IllegalArgumentException("Invalid direction value: " + direction);
        }).findFirst().orElseThrow(() -> new IllegalArgumentException("Direction not found"));
    }
}

