/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.nostr.cashu.services.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.nostr.cashu.services.SplitService;
import xyz.tcheeric.nostr.cashu.util.MintUtil;

public class DefaultSplitService
implements SplitService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultSplitService.class);

    @Override
    public Map<Integer, Integer> withSmallestDenomination(@NonNull Integer amount, @NonNull MintUtil mintUtil) {
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        if (mintUtil == null) {
            throw new NullPointerException("mintUtil is marked non-null but is null");
        }
        log.debug("withSmallestDenomination called");
        HashMap<Integer, Integer> result = new HashMap<Integer, Integer>();
        List<Integer> denominations = mintUtil.getDenominations();
        Integer denomination = Collections.min(denominations);
        if (amount >= denomination) {
            int count = amount / denomination;
            result.put(denomination, count);
            amount = amount - denomination * count;
            if (amount > 0) {
                result.put(amount, 1);
            }
            return result;
        }
        throw new IllegalArgumentException("Amount is less than denomination");
    }

    @Override
    public Map<Integer, Integer> withDenomination(@NonNull Integer amount, @NonNull Integer denomination) {
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        if (denomination == null) {
            throw new NullPointerException("denomination is marked non-null but is null");
        }
        log.debug("withDenomination called");
        HashMap<Integer, Integer> result = new HashMap<Integer, Integer>();
        if (amount >= denomination) {
            int count = amount / denomination;
            result.put(denomination, count);
            amount = amount - denomination * count;
            if (amount > 0) {
                result.put(amount, 1);
            }
            return result;
        }
        throw new IllegalArgumentException("Amount is less than denomination");
    }

    @Override
    public Map<Integer, Integer> withAllDenominations(@NonNull Integer amount, @NonNull MintUtil mintUtil) {
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        if (mintUtil == null) {
            throw new NullPointerException("mintUtil is marked non-null but is null");
        }
        log.debug("withAllDenominations called");
        List<Integer> denominations = mintUtil.getDenominations();
        denominations.sort(Collections.reverseOrder());
        HashMap<Integer, Integer> result = new HashMap<Integer, Integer>();
        for (int denomination : denominations) {
            if (amount < denomination) continue;
            int count = amount / denomination;
            result.put(denomination, count);
            amount = amount - denomination * count;
        }
        if (amount > 0) {
            Map<Integer, Integer> smallestChange = this.withSmallestDenomination(amount, mintUtil);
            result.putAll(smallestChange);
        }
        return result;
    }
}

