/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.nostr.cashu.services.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import nostr.api.NIP01;
import nostr.api.NIP09;
import nostr.api.NIP44;
import nostr.api.NIP60;
import nostr.api.NIP61;
import nostr.api.NIP65;
import nostr.base.ElementAttribute;
import nostr.base.Kind;
import nostr.base.Marker;
import nostr.base.PublicKey;
import nostr.base.Relay;
import nostr.event.BaseMessage;
import nostr.event.Deleteable;
import nostr.event.entities.Amount;
import nostr.event.entities.CashuMint;
import nostr.event.entities.CashuToken;
import nostr.event.entities.CashuWallet;
import nostr.event.entities.NutZap;
import nostr.event.entities.NutZapInformation;
import nostr.event.entities.SpendingHistory;
import nostr.event.filter.AuthorFilter;
import nostr.event.filter.Filters;
import nostr.event.filter.KindFilter;
import nostr.event.impl.GenericEvent;
import nostr.event.json.codec.BaseMessageDecoder;
import nostr.event.message.EventMessage;
import nostr.event.message.OkMessage;
import nostr.event.tag.AddressTag;
import nostr.event.tag.EventTag;
import nostr.event.tag.GenericTag;
import nostr.event.tag.IdentifierTag;
import nostr.event.tag.ReferenceTag;
import nostr.id.Identity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.cashu.common.Proof;
import xyz.tcheeric.cashu.common.Secret;
import xyz.tcheeric.cashu.common.TokenV3;
import xyz.tcheeric.nostr.cashu.parser.SpendingHistoryParser;
import xyz.tcheeric.nostr.cashu.parser.TokenParser;
import xyz.tcheeric.nostr.cashu.util.AsyncExecutor;
import xyz.tcheeric.nostr.cashu.util.DefaultAsyncExecutor;
import xyz.tcheeric.nostr.cashu.util.TokenUtil;

public class NostrEventService<T extends Secret> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NostrEventService.class);
    private final CashuWallet wallet;
    private final Identity identity;
    private final TokenParser<T> tokenParser;
    private final SpendingHistoryParser spendingHistoryParser;
    private final AsyncExecutor executor;
    private final NIP60 nip60;
    private final NIP61 nip61;
    private final NIP01 nip01;
    private final NIP09 nip09;
    private final NIP65 nip65;

    public NostrEventService(@NonNull Identity identity) {
        this(null, identity);
        if (identity == null) {
            throw new NullPointerException("identity is marked non-null but is null");
        }
    }

    public NostrEventService(CashuWallet wallet, @NonNull Identity identity) {
        this(wallet, identity, new DefaultAsyncExecutor());
        if (identity == null) {
            throw new NullPointerException("identity is marked non-null but is null");
        }
    }

    public NostrEventService(CashuWallet wallet, @NonNull Identity identity, @NonNull AsyncExecutor executor) {
        if (identity == null) {
            throw new NullPointerException("identity is marked non-null but is null");
        }
        if (executor == null) {
            throw new NullPointerException("executor is marked non-null but is null");
        }
        log.debug("NostrEventService called");
        this.wallet = wallet;
        this.identity = identity;
        this.executor = executor;
        this.tokenParser = new TokenParser();
        this.spendingHistoryParser = new SpendingHistoryParser();
        this.nip60 = new NIP60(identity);
        this.nip61 = new NIP61(identity);
        this.nip01 = new NIP01(identity);
        this.nip09 = new NIP09(identity);
        this.nip65 = new NIP65(identity);
    }

    public GenericEvent publishTokenEvent(@NonNull CashuToken token, @NonNull Map<String, String> relays) {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        if (relays == null) {
            throw new NullPointerException("relays is marked non-null but is null");
        }
        log.debug("publishTokenEvent called");
        this.nip60.createTokenEvent(token, this.wallet).signAndSend(relays);
        return this.nip60.getEvent();
    }

    public List<GenericEvent> fetchTokenEvents(@NonNull List<PublicKey> authors, @NonNull Map<String, String> relays) {
        if (authors == null) {
            throw new NullPointerException("authors is marked non-null but is null");
        }
        if (relays == null) {
            throw new NullPointerException("relays is marked non-null but is null");
        }
        log.debug("fetchTokenEvents called");
        return this.fetchEventsInternal(List.of(Kind.WALLET_UNSPENT_PROOF), authors, relays);
    }

    public TokenV3<T> parseToken(@NonNull GenericEvent event, @NonNull String unit) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        log.debug("parseToken called");
        String content = this.decrypt(event.getContent(), this.identity.getPublicKey());
        return this.tokenParser.parse(content, unit);
    }

    public SpendingHistory parseSpendingHistory(@NonNull GenericEvent event, @NonNull String unit) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        log.debug("parseSpendingHistory called");
        String content = this.decrypt(event.getContent(), this.identity.getPublicKey());
        return this.spendingHistoryParser.parse(content, unit);
    }

    public void publishWalletEvent(@NonNull Map<String, String> relays) {
        if (relays == null) {
            throw new NullPointerException("relays is marked non-null but is null");
        }
        if (this.wallet == null) {
            throw new IllegalStateException("wallet is null");
        }
        this.nip60.createWalletEvent(this.wallet).signAndSend(relays);
    }

    public void publishSpendingHistoryEvent(@NonNull GenericEvent event, @NonNull String unit, SpendingHistory.Direction direction, @NonNull Map<String, String> relays) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        if (relays == null) {
            throw new NullPointerException("relays is marked non-null but is null");
        }
        TokenV3<T> token = this.parseToken(event, unit);
        int amount = token.getMintProofs().stream().map(mp -> mp.getProofs().stream().mapToInt(Proof::getAmount).sum()).reduce(0, Integer::sum);
        String relayUrl = relays.values().stream().findFirst().orElseGet(() -> {
            Set relaySet = this.wallet.getRelays(token.getUnit());
            if (relaySet == null || relaySet.isEmpty()) {
                throw new IllegalStateException("No relays available for unit: " + token.getUnit());
            }
            return ((Relay)relaySet.iterator().next()).getUri();
        });
        SpendingHistory spendingHistory = SpendingHistory.builder().amount(new Amount(Integer.valueOf(amount), token.getUnit())).direction(direction).eventTags(List.of(new EventTag(event.getId(), relayUrl, direction.equals((Object)SpendingHistory.Direction.RECEIVED) ? Marker.CREATED : Marker.DESTROYED))).build();
        BaseMessage message = this.nip60.createSpendingHistoryEvent(spendingHistory, this.wallet).signAndSend(relays);
        if (!(message instanceof OkMessage) || !((OkMessage)message).getFlag().booleanValue()) {
            throw new IllegalStateException("Spending history event failed: " + (message instanceof OkMessage ? ((OkMessage)message).getMessage() : ""));
        }
    }

    public void publishSpendingHistoryEvent(@NonNull GenericEvent event, @NonNull String unit, SpendingHistory.Direction direction) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        this.publishSpendingHistoryEvent(event, unit, direction, this.getRelays());
    }

    public List<GenericEvent> fetchSpendingHistoryEvents(@NonNull List<PublicKey> authors) {
        if (authors == null) {
            throw new NullPointerException("authors is marked non-null but is null");
        }
        return this.fetchEventsInternal(List.of(Kind.WALLET_TX_HISTORY), authors, this.getRelays());
    }

    public List<GenericEvent> fetchNutZapInformationalEvents(@NonNull PublicKey publicKey) {
        if (publicKey == null) {
            throw new NullPointerException("publicKey is marked non-null but is null");
        }
        return this.fetchEventsInternal(List.of(Kind.NUTZAP_INFORMATIONAL), List.of(publicKey), this.getRelays());
    }

    private List<GenericEvent> fetchEventsInternal(@NonNull List<Kind> kinds, @NonNull List<PublicKey> authors, @NonNull Map<String, String> relays) {
        if (kinds == null) {
            throw new NullPointerException("kinds is marked non-null but is null");
        }
        if (authors == null) {
            throw new NullPointerException("authors is marked non-null but is null");
        }
        if (relays == null) {
            throw new NullPointerException("relays is marked non-null but is null");
        }
        log.debug("fetchEventsInternal called");
        ArrayList filterables = new ArrayList();
        authors.forEach(author -> filterables.add(new AuthorFilter(author)));
        kinds.forEach(kind -> filterables.add(new KindFilter(kind)));
        Filters filters = new Filters(filterables);
        List<String> messages = this.getMessages(filters, relays);
        return messages.stream().map(message -> {
            try {
                return new BaseMessageDecoder().decode(message);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }).filter(msg -> msg instanceof EventMessage).map(msg -> (EventMessage)msg).map(EventMessage::getEvent).map(event -> (GenericEvent)event).filter(event -> authors.contains(event.getPubKey())).filter(event -> kinds.contains(Kind.valueOf((int)event.getKind()))).collect(Collectors.toList());
    }

    public void publishNutZapEvent(@NonNull NutZap nutZap, @NonNull String content) {
        if (nutZap == null) {
            throw new NullPointerException("nutZap is marked non-null but is null");
        }
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        List<GenericEvent> events = this.fetchNutZapInformationalEvents(nutZap.getRecipient());
        HashSet relays = new HashSet();
        events.forEach(e -> relays.addAll(this.extractNutZapInformation((GenericEvent)e).getRelays()));
        HashMap relayMap = new HashMap();
        relays.forEach(r -> relayMap.put(r.getHost(), r.getUri()));
        this.executor.execute(() -> {
            this.nip61.createNutzapEvent(nutZap, content).signAndSend(relayMap);
            return null;
        }).join();
    }

    public NutZapInformation extractNutZapInformation(@NonNull GenericEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        if (event.getKind().intValue() != Kind.NUTZAP_INFORMATIONAL.getValue()) {
            throw new IllegalStateException("Invalid event kind: " + event.getKind());
        }
        NutZapInformation info = new NutZapInformation();
        event.getTags().stream().filter(tag -> tag.getCode().equals("pubkey")).map(tag -> (GenericTag)tag).findFirst().ifPresent(tag -> info.setP2pkPubkey(((ElementAttribute)tag.getAttributes().get(0)).value().toString()));
        event.getTags().stream().filter(tag -> tag.getCode().equals("relay")).map(tag -> (GenericTag)tag).forEach(tag -> info.getRelays().add(new Relay(((ElementAttribute)tag.getAttributes().get(0)).value().toString())));
        event.getTags().stream().filter(tag -> tag.getCode().equals("mint")).map(tag -> (GenericTag)tag).forEach(tag -> info.getMints().add(new CashuMint(((ElementAttribute)tag.getAttributes().get(0)).value().toString(), List.of(((ElementAttribute)tag.getAttributes().get(1)).value().toString().split(",")))));
        return info;
    }

    public List<String> getMessages(@NonNull Filters filters, @NonNull Map<String, String> relays) {
        if (filters == null) {
            throw new NullPointerException("filters is marked non-null but is null");
        }
        if (relays == null) {
            throw new NullPointerException("relays is marked non-null but is null");
        }
        return this.executor.execute(() -> this.nip01.sendRequest(filters, UUID.randomUUID().toString(), relays)).join();
    }

    public Map<String, String> getRelays() {
        Map<String, String> metadata = this.getRelayListMetadata();
        if (metadata != null) {
            return metadata;
        }
        String bootstrapRelay = System.getProperty("NOSTR_RELAY_BOOTSTRAP");
        if (bootstrapRelay != null) {
            return Map.of("bootstrap", bootstrapRelay);
        }
        throw new IllegalStateException("No relays found");
    }

    private Map<String, String> getRelayListMetadata() {
        List<GenericEvent> events = this.fetchRelayListMetadataEvents();
        if (!events.isEmpty()) {
            return events.stream().map(event -> event.getTags().stream().filter(tag -> tag.getCode().equals("r")).map(tag -> (ReferenceTag)tag).filter(tag -> Marker.WRITE.equals((Object)tag.getMarker())).map(tag -> new Relay(tag.getUri().toString())).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toMap(Relay::getHost, Relay::getUri));
        }
        return null;
    }

    private List<GenericEvent> fetchRelayListMetadataEvents() {
        String bootstrapRelay = System.getProperty("NOSTR_RELAY_BOOTSTRAP");
        if (bootstrapRelay == null) {
            throw new IllegalStateException("System property 'NOSTR_RELAY_BOOTSTRAP' is not set");
        }
        Map<String, String> relays = Map.of("bootstrap", bootstrapRelay);
        return this.fetchEventsInternal(List.of(Kind.RELAY_LIST_METADATA), List.of(this.identity.getPublicKey()), relays);
    }

    public static <S extends Secret> Map<String, String> getRelays(@NonNull CashuWallet wallet, @NonNull Identity identity) {
        if (wallet == null) {
            throw new NullPointerException("wallet is marked non-null but is null");
        }
        if (identity == null) {
            throw new NullPointerException("identity is marked non-null but is null");
        }
        return new NostrEventService(wallet, identity).getRelays();
    }

    public GenericEvent publishTokenEvent(@NonNull CashuToken token) {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        this.nip60.createTokenEvent(token, this.wallet).signAndSend(this.getRelays());
        return this.nip60.getEvent();
    }

    public List<GenericEvent> fetchWalletEvents(@NonNull List<PublicKey> authors) {
        if (authors == null) {
            throw new NullPointerException("authors is marked non-null but is null");
        }
        log.debug("fetchWalletEvents called");
        return this.fetchEventsInternal(List.of(Kind.WALLET), authors, this.getRelays());
    }

    public List<GenericEvent> fetchEvents(@NonNull List<Kind> kinds, @NonNull List<PublicKey> authors) {
        if (kinds == null) {
            throw new NullPointerException("kinds is marked non-null but is null");
        }
        if (authors == null) {
            throw new NullPointerException("authors is marked non-null but is null");
        }
        log.debug("fetchEvents called");
        return this.fetchEventsInternal(kinds, authors, this.getRelays());
    }

    public List<GenericEvent> fetchSpendingHistoryEvents(@NonNull List<PublicKey> authors, SpendingHistory.Direction direction) {
        if (authors == null) {
            throw new NullPointerException("authors is marked non-null but is null");
        }
        log.debug("fetchSpendingHistoryEvents called");
        return this.fetchEventsInternal(List.of(Kind.WALLET_TX_HISTORY), authors, this.getRelays()).stream().filter(event -> {
            try {
                String content = this.getContent((GenericEvent)event);
                JsonNode node = new ObjectMapper().readTree(content);
                if (node.isArray()) {
                    for (JsonNode element : node) {
                        if (!element.isArray() || element.size() <= 1 || !"direction".equalsIgnoreCase(element.get(0).asText())) continue;
                        String dirValue = element.get(1).asText();
                        if (!direction.getValue().equalsIgnoreCase(dirValue)) continue;
                        return true;
                    }
                    return false;
                }
                JsonNode dirNode = node.get("direction");
                return dirNode != null && direction.getValue().equalsIgnoreCase(dirNode.asText());
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
    }

    public List<GenericEvent> fetchDeletionEvents(@NonNull List<PublicKey> authors) {
        if (authors == null) {
            throw new NullPointerException("authors is marked non-null but is null");
        }
        log.debug("fetchDeletionEvents called");
        return this.fetchEventsInternal(List.of(Kind.DELETION), authors, this.getRelays());
    }

    public String getContent(@NonNull GenericEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        log.debug("getContent called");
        return this.decrypt(event.getContent(), this.identity.getPublicKey());
    }

    public TokenV3<T> getToken(@NonNull GenericEvent event, @NonNull String unit) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        log.debug("getToken called");
        return this.parseToken(event, unit);
    }

    public SpendingHistory getSpendingHistory(@NonNull GenericEvent event, @NonNull String unit) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        log.debug("getSpendingHistory called");
        return this.parseSpendingHistory(event, unit);
    }

    public String extractWalletId(@NonNull GenericEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        log.debug("extractWalletId called");
        Optional<AddressTag> addressTagOpt = event.getTags().stream().filter(tag -> tag instanceof AddressTag).map(tag -> (AddressTag)tag).findFirst();
        if (addressTagOpt.isPresent()) {
            AddressTag addressTag = addressTagOpt.get();
            Integer kind = addressTag.getKind();
            if (kind.intValue() != Kind.WALLET.getValue()) {
                throw new IllegalStateException("Invalid kind: " + kind);
            }
            String pubKey = addressTag.getPublicKey().toString();
            if (!pubKey.equals(this.identity.getPublicKey().toString())) {
                throw new IllegalStateException("Public key mismatch");
            }
            IdentifierTag idTag = addressTag.getIdentifierTag();
            return idTag.getUuid();
        }
        throw new IllegalStateException("Wallet ID not found");
    }

    public String extractUnit(@NonNull GenericEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        log.debug("extractUnit called");
        return event.getTags().stream().filter(tag -> tag.getCode().equals("unit")).map(tag -> (GenericTag)tag).findFirst().map(tag -> ((ElementAttribute)tag.getAttributes().get(0)).value().toString()).orElse(null);
    }

    public GenericEvent findTokenEvent(@NonNull CashuToken token, @NonNull String unit) {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        log.debug("findTokenEvent called");
        List<GenericEvent> events = this.fetchEventsInternal(List.of(Kind.WALLET_UNSPENT_PROOF), List.of(this.identity.getPublicKey()), this.getRelays());
        for (GenericEvent event : events) {
            TokenV3<T> tokenV3 = this.parseToken(event, unit);
            List<CashuToken> tokens = TokenUtil.toCashuTokens(tokenV3);
            for (CashuToken t : tokens) {
                if (!t.equals((Object)token)) continue;
                return event;
            }
        }
        return null;
    }

    public GenericEvent publishDeletionEvent(@NonNull CashuToken token, @NonNull String unit) {
        OkMessage ok;
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        log.debug("publishDeletionEvent called");
        GenericEvent event = this.findTokenEvent(token, unit);
        if (event == null) {
            throw new IllegalStateException("Event not found for token deletion");
        }
        BaseMessage deleted = this.nip09.createDeletionEvent(new Deleteable[]{event}).signAndSend(this.getRelays());
        if (!(deleted instanceof OkMessage) || !(ok = (OkMessage)deleted).getFlag().booleanValue()) {
            String string;
            if (deleted instanceof OkMessage) {
                OkMessage okMessage = (OkMessage)deleted;
                string = okMessage.getMessage();
            } else {
                string = "";
            }
            throw new IllegalStateException("Deletion event failed: " + string);
        }
        return event;
    }

    private String decrypt(@NonNull String content, @NonNull PublicKey pubKey) {
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        if (pubKey == null) {
            throw new NullPointerException("pubKey is marked non-null but is null");
        }
        return NIP44.decrypt((Identity)this.identity, (String)content, (PublicKey)pubKey);
    }

    public GenericEvent createRelayListMetadataEvent(@NonNull Map<Relay, Marker> relays) {
        if (relays == null) {
            throw new NullPointerException("relays is marked non-null but is null");
        }
        this.nip65.createRelayListMetadataEvent(relays);
        return this.nip65.getEvent();
    }

    public void publishRelayListMetadataEvent(@NonNull Map<Relay, Marker> relays) {
        if (relays == null) {
            throw new NullPointerException("relays is marked non-null but is null");
        }
        this.nip65.createRelayListMetadataEvent(relays).signAndSend(this.getRelays());
    }

    public GenericEvent createRelayListMetadataEvent(@NonNull List<Relay> relays, @NonNull Marker marker) {
        if (relays == null) {
            throw new NullPointerException("relays is marked non-null but is null");
        }
        if (marker == null) {
            throw new NullPointerException("marker is marked non-null but is null");
        }
        this.nip65.createRelayListMetadataEvent(relays, marker);
        return this.nip65.getEvent();
    }

    public void publishRelayListMetadataEvent(@NonNull List<Relay> relays, @NonNull Marker marker) {
        if (relays == null) {
            throw new NullPointerException("relays is marked non-null but is null");
        }
        if (marker == null) {
            throw new NullPointerException("marker is marked non-null but is null");
        }
        this.nip65.createRelayListMetadataEvent(relays, marker).signAndSend(this.getRelays());
    }

    public GenericEvent createNutzapInformationalEvent(@NonNull NutZapInformation information) {
        if (information == null) {
            throw new NullPointerException("information is marked non-null but is null");
        }
        this.nip61.createNutzapInformationalEvent(information);
        return this.nip61.getEvent();
    }

    public void publishNutzapInformationalEvent(@NonNull NutZapInformation information) {
        if (information == null) {
            throw new NullPointerException("information is marked non-null but is null");
        }
        this.nip61.createNutzapInformationalEvent(information).signAndSend(this.getRelays());
    }

    @Generated
    public CashuWallet getWallet() {
        return this.wallet;
    }

    @Generated
    public Identity getIdentity() {
        return this.identity;
    }

    @Generated
    public TokenParser<T> getTokenParser() {
        return this.tokenParser;
    }

    @Generated
    public SpendingHistoryParser getSpendingHistoryParser() {
        return this.spendingHistoryParser;
    }

    @Generated
    public AsyncExecutor getExecutor() {
        return this.executor;
    }

    @Generated
    public NIP60 getNip60() {
        return this.nip60;
    }

    @Generated
    public NIP61 getNip61() {
        return this.nip61;
    }

    @Generated
    public NIP01 getNip01() {
        return this.nip01;
    }

    @Generated
    public NIP09 getNip09() {
        return this.nip09;
    }

    @Generated
    public NIP65 getNip65() {
        return this.nip65;
    }
}

