/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.nostr.cashu.services.impl;

import java.util.Map;
import lombok.Generated;
import lombok.NonNull;
import nostr.event.entities.CashuWallet;
import nostr.id.Identity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.cashu.common.Secret;
import xyz.tcheeric.nostr.cashu.services.impl.NostrCashuService;
import xyz.tcheeric.nostr.cashu.services.impl.NostrEventService;
import xyz.tcheeric.nostr.cashu.util.MintUtil;

public class WalletService<T extends Secret>
extends NostrCashuService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WalletService.class);

    public WalletService(@NonNull CashuWallet wallet, @NonNull String mintUrl, @NonNull String unit, @NonNull Identity identity) {
        super(wallet, mintUrl, unit, identity);
        if (wallet == null) {
            throw new NullPointerException("wallet is marked non-null but is null");
        }
        if (mintUrl == null) {
            throw new NullPointerException("mintUrl is marked non-null but is null");
        }
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        if (identity == null) {
            throw new NullPointerException("identity is marked non-null but is null");
        }
    }

    protected WalletService(@NonNull CashuWallet wallet, @NonNull MintUtil mintUtil, @NonNull Identity identity) {
        super(wallet, mintUtil, identity);
        if (wallet == null) {
            throw new NullPointerException("wallet is marked non-null but is null");
        }
        if (mintUtil == null) {
            throw new NullPointerException("mintUtil is marked non-null but is null");
        }
        if (identity == null) {
            throw new NullPointerException("identity is marked non-null but is null");
        }
    }

    public void publishWalletEvent(@NonNull Identity identity) {
        if (identity == null) {
            throw new NullPointerException("identity is marked non-null but is null");
        }
        log.debug("publishWalletEvent called");
        this.getNostrEventService().publishWalletEvent(NostrEventService.getRelays(this.getWallet(), identity));
    }

    public void publishWalletEvent(Map<String, String> relays) {
        log.debug("publishWalletEvent called");
        this.getNostrEventService().publishWalletEvent(relays);
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WalletService)) {
            return false;
        }
        WalletService other = (WalletService)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof WalletService;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "WalletService()";
    }
}

