/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.nostr.cashu.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.nostr.cashu.util.AsyncExecutor;

public class DefaultAsyncExecutor
implements AsyncExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultAsyncExecutor.class);
    private static final long DEFAULT_TIMEOUT_SECONDS = 15L;
    private static final String CONFIG_FILE = "executor.properties";
    private static final Map<String, String> PROPERTIES;
    private final Executor executor;
    private final long timeoutSeconds;

    private static long getTimeout() {
        String value = PROPERTIES.get("timeout.seconds");
        if (value != null) {
            try {
                long parsed = Long.parseLong(value);
                if (parsed > 0L) {
                    return parsed;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 15L;
    }

    public DefaultAsyncExecutor() {
        this(Executors.newCachedThreadPool(), DefaultAsyncExecutor.getTimeout());
    }

    public DefaultAsyncExecutor(Executor executor, long timeoutSeconds) {
        log.debug("DefaultAsyncExecutor called");
        if (timeoutSeconds < 0L) {
            throw new IllegalArgumentException("timeoutSeconds must be non-negative");
        }
        this.executor = executor;
        this.timeoutSeconds = timeoutSeconds;
    }

    @Override
    public <T> CompletableFuture<T> execute(Supplier<T> task) {
        log.debug("execute called");
        CompletableFuture<T> future = CompletableFuture.supplyAsync(task, this.executor);
        if (this.timeoutSeconds > 0L) {
            future = future.orTimeout(this.timeoutSeconds, TimeUnit.SECONDS);
        }
        return future;
    }

    static {
        Properties props = new Properties();
        try (InputStream in2 = DefaultAsyncExecutor.class.getClassLoader().getResourceAsStream(CONFIG_FILE);){
            if (in2 != null) {
                props.load(in2);
            }
        }
        catch (IOException in2) {
            // empty catch block
        }
        HashMap<String, String> temp = new HashMap<String, String>();
        for (String name : props.stringPropertyNames()) {
            temp.put(name, props.getProperty(name));
        }
        PROPERTIES = Collections.unmodifiableMap(temp);
    }
}

