/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.nostr.cashu.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.cashu.common.P2PKSecret;
import xyz.tcheeric.cashu.common.PublicKey;
import xyz.tcheeric.cashu.common.Secret;
import xyz.tcheeric.cashu.common.Witness;
import xyz.tcheeric.cashu.entities.rest.GetKeySetsResponse;
import xyz.tcheeric.cashu.wallet.client.impl.RequestActiveKeysets;
import xyz.tcheeric.cashu.wallet.client.impl.RequestKeySetPublicKey;
import xyz.tcheeric.nostr.cashu.util.WalletUtil;

public class MintUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MintUtil.class);
    private final String unit;
    private final String mintUrl;
    private final String keysetId;
    private final List<Integer> denominations;

    public MintUtil(@NonNull String unit) {
        this(unit, null);
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
    }

    public MintUtil(@NonNull String unit, String mintUrl) {
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        log.debug("MintUtil called");
        this.unit = unit;
        this.mintUrl = mintUrl;
        Map<String, List<Integer>> denominationsMap = this.getDenominations(unit);
        this.keysetId = denominationsMap.keySet().iterator().next();
        this.denominations = denominationsMap.get(this.keysetId);
    }

    public RequestKeySetPublicKey getKeySetPublicKey(String keySetId) {
        log.debug("getKeySetPublicKey called");
        if (this.mintUrl == null) {
            throw new IllegalArgumentException("Mint URL is required");
        }
        if (keySetId != null) {
            return new RequestKeySetPublicKey(this.mintUrl, keySetId);
        }
        return new RequestKeySetPublicKey(this.mintUrl);
    }

    public RequestActiveKeysets getActiveKeySets() {
        log.debug("getActiveKeySets called");
        if (this.mintUrl == null) {
            throw new IllegalArgumentException("Mint URL is required");
        }
        return new RequestActiveKeysets(this.mintUrl);
    }

    private Map<String, List<Integer>> getDenominations(@NonNull String unit) {
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        HashMap<String, List<Integer>> result = new HashMap<String, List<Integer>>();
        ArrayList denominations = new ArrayList();
        CompletionStage future = CompletableFuture.supplyAsync(() -> (GetKeySetsResponse)this.getKeySetPublicKey(null).execute()).thenAccept(keySetResponse -> {
            List keysets = keySetResponse.getKeySets();
            keysets.stream().filter(keyset -> keyset.getUnit().equals(unit)).forEach(keyset -> {
                result.put(keyset.getId(), denominations);
                keyset.getKeys().getValues().forEach((bigInteger, publicKey) -> denominations.add(bigInteger.intValue()));
            });
        });
        ((CompletableFuture)future).join();
        return result;
    }

    public static Witness signProofInputs(@NonNull Secret secret, byte[] privateKey) {
        if (secret == null) {
            throw new NullPointerException("secret is marked non-null but is null");
        }
        log.debug("signProofInputs called");
        return WalletUtil.signProofInputs(secret, PublicKey.fromBytes((byte[])secret.getData()), privateKey);
    }

    public static P2PKSecret.SignatureFlag getSignatureFlag(@NonNull Secret secret) {
        if (secret == null) {
            throw new NullPointerException("secret is marked non-null but is null");
        }
        log.debug("getSignatureFlag called");
        return WalletUtil.getSignatureFlag(secret);
    }

    @Generated
    public MintUtil(String unit, String mintUrl, String keysetId, List<Integer> denominations) {
        this.unit = unit;
        this.mintUrl = mintUrl;
        this.keysetId = keysetId;
        this.denominations = denominations;
    }

    @Generated
    public String getUnit() {
        return this.unit;
    }

    @Generated
    public String getMintUrl() {
        return this.mintUrl;
    }

    @Generated
    public String getKeysetId() {
        return this.keysetId;
    }

    @Generated
    public List<Integer> getDenominations() {
        return this.denominations;
    }
}

