/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.nostr.cashu.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import nostr.base.ElementAttribute;
import nostr.base.Kind;
import nostr.base.Relay;
import nostr.event.entities.CashuMint;
import nostr.event.entities.CashuProof;
import nostr.event.entities.CashuToken;
import nostr.event.entities.CashuWallet;
import nostr.event.entities.SpendingHistory;
import nostr.event.impl.GenericEvent;
import nostr.event.tag.GenericTag;
import nostr.event.tag.IdentifierTag;
import nostr.id.Identity;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.cashu.common.BlindedMessage;
import xyz.tcheeric.cashu.common.KeySet;
import xyz.tcheeric.cashu.common.KeysetId;
import xyz.tcheeric.cashu.common.P2PKSecret;
import xyz.tcheeric.cashu.common.Proof;
import xyz.tcheeric.cashu.common.PublicKey;
import xyz.tcheeric.cashu.common.Secret;
import xyz.tcheeric.cashu.common.TokenV3;
import xyz.tcheeric.cashu.common.WellKnownSecret;
import xyz.tcheeric.cashu.common.Witness;
import xyz.tcheeric.cashu.common.util.SecretFactory;
import xyz.tcheeric.cashu.crypto.BDHKEUtils;
import xyz.tcheeric.cashu.crypto.Schnorr;
import xyz.tcheeric.cashu.crypto.util.Utils;
import xyz.tcheeric.cashu.entities.rest.GetKeySetsResponse;
import xyz.tcheeric.cashu.entities.rest.PostMintRequest;
import xyz.tcheeric.cashu.entities.rest.PostSwapRequest;
import xyz.tcheeric.nostr.cashu.operation.SwapOperation;
import xyz.tcheeric.nostr.cashu.services.SplitService;
import xyz.tcheeric.nostr.cashu.services.impl.DefaultSplitService;
import xyz.tcheeric.nostr.cashu.services.impl.NostrEventService;
import xyz.tcheeric.nostr.cashu.util.MintUtil;
import xyz.tcheeric.nostr.cashu.util.TokenUtil;

public class WalletUtil<T extends Secret> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WalletUtil.class);
    private final CashuWallet wallet;
    private final MintUtil mintUtil;
    private final Identity identity;
    private final SplitService splitService;
    private final Map<String, List<CashuToken>> pendingTokens = new ConcurrentHashMap<String, List<CashuToken>>();
    private final Map<String, List<CashuToken>> pendingChangeTokens = new ConcurrentHashMap<String, List<CashuToken>>();

    public WalletUtil(@NonNull CashuWallet wallet, @NonNull String unit, @NonNull String mintUrl, @NonNull Identity identity, @NonNull SplitService splitService) {
        this(wallet, new MintUtil(unit, mintUrl), identity, splitService);
        if (wallet == null) {
            throw new NullPointerException("wallet is marked non-null but is null");
        }
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        if (mintUrl == null) {
            throw new NullPointerException("mintUrl is marked non-null but is null");
        }
        if (identity == null) {
            throw new NullPointerException("identity is marked non-null but is null");
        }
        if (splitService == null) {
            throw new NullPointerException("splitService is marked non-null but is null");
        }
    }

    public WalletUtil(@NonNull CashuWallet wallet, @NonNull Identity identity, @NonNull SplitService splitService) {
        this(wallet, null, identity, splitService);
        if (wallet == null) {
            throw new NullPointerException("wallet is marked non-null but is null");
        }
        if (identity == null) {
            throw new NullPointerException("identity is marked non-null but is null");
        }
        if (splitService == null) {
            throw new NullPointerException("splitService is marked non-null but is null");
        }
    }

    public static <T extends Secret> BlindedMessage createBlindMessageEntity(@NonNull Proof<T> proof) {
        if (proof == null) {
            throw new NullPointerException("proof is marked non-null but is null");
        }
        log.debug("createBlindMessageEntity called");
        return new BlindedMessage(proof.getAmount(), KeysetId.fromString((String)proof.getKeySetId()), WalletUtil.createBlindMessage(proof.getSecret().toBytes()), proof.getWitness());
    }

    public static <T extends Secret> List<BlindedMessage> createBlindMessageEntities(@NonNull List<Proof<T>> proofs) {
        if (proofs == null) {
            throw new NullPointerException("proofs is marked non-null but is null");
        }
        log.debug("createBlindMessageEntities called");
        ArrayList<BlindedMessage> result = new ArrayList<BlindedMessage>();
        for (Proof<T> proof : proofs) {
            result.add(WalletUtil.createBlindMessageEntity(proof));
        }
        return result;
    }

    public static <T extends Secret> List<BlindedMessage> createBlindMessageEntities(@NonNull Proof<T> proof, @NonNull Map<Integer, Integer> change) {
        Integer count;
        if (proof == null) {
            throw new NullPointerException("proof is marked non-null but is null");
        }
        if (change == null) {
            throw new NullPointerException("change is marked non-null but is null");
        }
        log.debug("createBlindMessageEntities called");
        int total = 0;
        ArrayList<BlindedMessage> result = new ArrayList<BlindedMessage>();
        Set<Integer> denominations = change.keySet();
        for (int d : denominations) {
            count = change.get(d);
            total += d * count;
        }
        if (total != proof.getAmount()) {
            throw new IllegalArgumentException("Total amount does not match proof amount");
        }
        for (Integer d : denominations) {
            count = change.get(d);
            result.addAll(WalletUtil.createBlindMessageEntities(proof, d, count));
        }
        return result;
    }

    public static <T extends Secret> void createWalletEvent(@NonNull NostrEventService<T> nostrEventService) {
        if (nostrEventService == null) {
            throw new NullPointerException("nostrEventService is marked non-null but is null");
        }
        log.debug("createWalletEvent called");
        nostrEventService.publishWalletEvent(NostrEventService.getRelays(nostrEventService.getWallet(), nostrEventService.getIdentity()));
    }

    private static <T extends Secret> List<BlindedMessage> createBlindMessageEntities(@NonNull Proof<T> proof, @NonNull Integer denomination, @NonNull Integer count) {
        if (proof == null) {
            throw new NullPointerException("proof is marked non-null but is null");
        }
        if (denomination == null) {
            throw new NullPointerException("denomination is marked non-null but is null");
        }
        if (count == null) {
            throw new NullPointerException("count is marked non-null but is null");
        }
        if (proof.getAmount() % denomination != 0) {
            throw new IllegalArgumentException("Proof amount is not divisible by the denomination");
        }
        ArrayList<BlindedMessage> result = new ArrayList<BlindedMessage>();
        for (int i = 0; i < count; ++i) {
            result.add(new BlindedMessage(denomination.intValue(), KeysetId.fromString((String)proof.getKeySetId()), WalletUtil.createBlindMessage(proof.getSecret().toBytes()), proof.getWitness()));
        }
        return result;
    }

    public static PublicKey createBlindMessage(byte[] secret) {
        log.debug("createBlindMessage called");
        return PublicKey.fromBytes((byte[])BDHKEUtils.blindMessage((byte[])secret)[0]);
    }

    public static PublicKey createBlindMessage(byte[] secret, byte[] r) {
        log.debug("createBlindMessage called");
        return PublicKey.fromBytes((byte[])BDHKEUtils.blindMessage((byte[])secret, (byte[])r));
    }

    public static <T extends Secret> byte[] getBlindingFactor(@NonNull T secret) {
        if (secret == null) {
            throw new NullPointerException("secret is marked non-null but is null");
        }
        log.debug("getBlindingFactor called");
        return BDHKEUtils.blindMessage((byte[])secret.toBytes())[1];
    }

    public static List<CashuProof> findProofsSubsetForTotalAmount(List<CashuProof> allProofs, int totalAmount) {
        log.debug("findProofsSubsetForTotalAmount called");
        HashMap dp = new HashMap();
        dp.put(0, new ArrayList());
        for (CashuProof proof : allProofs) {
            HashMap next = new HashMap(dp);
            for (Map.Entry entry : dp.entrySet()) {
                int newSum = (Integer)entry.getKey() + proof.getAmount();
                if (newSum > totalAmount || next.containsKey(newSum)) continue;
                ArrayList<CashuProof> newList = new ArrayList<CashuProof>((Collection)entry.getValue());
                newList.add(proof);
                next.put(newSum, newList);
            }
            dp = next;
        }
        return dp.getOrDefault(totalAmount, null);
    }

    public CashuProof findProofToSwap(@NonNull Integer amount, @NonNull List<CashuToken> tokens) {
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        if (tokens == null) {
            throw new NullPointerException("tokens is marked non-null but is null");
        }
        log.debug("findProofToSwap called");
        List allProofs = tokens.stream().flatMap(token -> token.getProofs().stream()).toList();
        ArrayList tmpAllProofs = new ArrayList(allProofs);
        tmpAllProofs.sort((proof1, proof2) -> proof2.getAmount().compareTo(proof1.getAmount()));
        Map<Integer, Integer> split = this.splitService.withSmallestDenomination(amount, this.mintUtil);
        Integer totalAmount = allProofs.stream().map(p -> p.getAmount()).reduce(0, Integer::sum);
        AtomicBoolean missingProofFlag = new AtomicBoolean(false);
        if (totalAmount >= amount) {
            split.keySet().stream().sorted().forEach(denominationAmount -> {
                CashuProof proofEntity = allProofs.stream().filter(p -> p.getAmount().equals(denominationAmount)).findFirst().orElse(null);
                if (proofEntity != null) {
                    tmpAllProofs.remove(proofEntity);
                } else {
                    missingProofFlag.set(true);
                }
            });
            return missingProofFlag.get() ? (CashuProof)allProofs.stream().filter(proof -> proof.getAmount() > amount).min(Comparator.comparingInt(proof -> proof.getAmount() - amount)).orElse(null) : null;
        }
        throw new IllegalStateException("Denomination not found");
    }

    public List<CashuToken> getTokensFromWallet(@NonNull Integer amount) {
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        log.debug("getTokensFromWallet called");
        String keySetId = this.getKeysetId();
        List<CashuToken> tokens = this.wallet.getTokens().stream().filter(token -> token.getProofs().stream().anyMatch(proof -> keySetId == null || proof.getId().equals(keySetId))).sorted(Comparator.comparingInt(CashuToken::calculateAmount).reversed()).toList();
        ArrayList<CashuToken> result = new ArrayList<CashuToken>();
        int cumulativeAmount = 0;
        for (CashuToken token2 : tokens) {
            result.add(token2);
            if ((cumulativeAmount += token2.calculateAmount().intValue()) < amount) continue;
            return result;
        }
        return result.isEmpty() ? Collections.emptyList() : result;
    }

    public List<CashuProof> extractProofsFromWallet(@NonNull Integer amount) {
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        log.debug("extractProofsFromWallet called");
        List<CashuToken> tokens = this.getTokensFromWallet(amount);
        if (tokens.isEmpty()) {
            throw new IllegalStateException("Not enough tokens to melt");
        }
        return this.extractProofsFromTokens(tokens, amount);
    }

    public List<CashuProof> extractProofsFromTokens(@NonNull List<CashuToken> tokenList, @NonNull Integer amount) {
        if (tokenList == null) {
            throw new NullPointerException("tokenList is marked non-null but is null");
        }
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        log.debug("extractProofsFromTokens called");
        List<CashuProof> allProofs = tokenList.stream().flatMap(token -> token.getProofs().stream()).collect(Collectors.toList());
        return WalletUtil.findProofsSubsetForTotalAmount(allProofs, amount);
    }

    public List<CashuProof> extractProofsFromTokens(@NonNull Integer amount, @NonNull SwapOperation<T> swapOperation) {
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        if (swapOperation == null) {
            throw new NullPointerException("swapOperation is marked non-null but is null");
        }
        log.debug("extractProofsFromTokens called");
        List<CashuToken> tokensToSpend = this.getTokensFromWallet(amount);
        if (tokensToSpend.isEmpty()) {
            throw new IllegalStateException("Not enough tokens to spend");
        }
        List<CashuProof> spentProofList = this.extractProofsFromTokens(tokensToSpend, amount);
        if (spentProofList == null) {
            TokenUtil<T> tokenUtil = new TokenUtil<T>(this.wallet, this.mintUtil, this.identity, this.splitService, this);
            tokenUtil.splitProof(amount, swapOperation);
            tokensToSpend = this.getTokensFromWallet(amount);
            spentProofList = this.extractProofsFromTokens(tokensToSpend, amount);
            if (spentProofList == null) {
                throw new IllegalStateException("Not enough tokens to spend");
            }
        }
        List<CashuProof> unspentProofs = WalletUtil.getUnspentProofs(tokensToSpend, spentProofList);
        this.rollOverTheUnspentProofs(unspentProofs, tokensToSpend, swapOperation);
        return spentProofList;
    }

    void rollOverTheUnspentProofs(@NonNull List<CashuProof> unspentProofs, @NonNull List<CashuToken> nostrTokenList, @NonNull SwapOperation<T> swapOperation) {
        if (unspentProofs == null) {
            throw new NullPointerException("unspentProofs is marked non-null but is null");
        }
        if (nostrTokenList == null) {
            throw new NullPointerException("nostrTokenList is marked non-null but is null");
        }
        if (swapOperation == null) {
            throw new NullPointerException("swapOperation is marked non-null but is null");
        }
        unspentProofs.forEach(proof -> {
            if (nostrTokenList.stream().flatMap(token -> token.getProofs().stream()).noneMatch(p -> p.equals(proof))) {
                throw new IllegalStateException("Unspent proof not part of the tokens to melt");
            }
        });
        PostSwapRequest postSwapRequest = new PostSwapRequest();
        List<Proof<T>> unspentCashuProofs = unspentProofs.stream().map(proof -> TokenUtil.toCashuProof(proof)).collect(Collectors.toList());
        postSwapRequest.setInputs(unspentCashuProofs);
        postSwapRequest.setBlindedMessages(WalletUtil.createBlindMessageEntities(unspentCashuProofs));
        TokenV3<T> unspentSwappedTokenV3 = swapOperation.swap(postSwapRequest).getToken();
        String unspentSwappedTokenV3Unit = unspentSwappedTokenV3.getUnit();
        List<CashuToken> changeTokens = TokenUtil.toCashuTokens(unspentSwappedTokenV3);
        this.addTokens(changeTokens, unspentSwappedTokenV3Unit);
        this.trackChangeTokens(changeTokens, unspentSwappedTokenV3Unit);
        this.markTokensPending(nostrTokenList, swapOperation.getUnit());
    }

    private void markTokensPending(@NonNull List<CashuToken> tokens, @NonNull String unit) {
        if (tokens == null) {
            throw new NullPointerException("tokens is marked non-null but is null");
        }
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        this.pendingTokens.computeIfAbsent(unit, k -> new CopyOnWriteArrayList()).addAll(tokens);
        tokens.forEach(arg_0 -> ((CashuWallet)this.wallet).removeToken(arg_0));
    }

    private void trackChangeTokens(@NonNull List<CashuToken> tokens, @NonNull String unit) {
        if (tokens == null) {
            throw new NullPointerException("tokens is marked non-null but is null");
        }
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        this.pendingChangeTokens.computeIfAbsent(unit, k -> new CopyOnWriteArrayList()).addAll(tokens);
    }

    public synchronized void commitPendingTokens(@NonNull String unit) {
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        List<CashuToken> toDelete = this.pendingTokens.remove(unit);
        if (toDelete != null) {
            this.deleteTokens(toDelete, unit);
        }
        this.pendingChangeTokens.remove(unit);
    }

    public synchronized void restorePendingTokens(@NonNull String unit) {
        List<CashuToken> change;
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        List<CashuToken> toRestore = this.pendingTokens.remove(unit);
        if (toRestore != null) {
            toRestore.forEach(arg_0 -> ((CashuWallet)this.wallet).addToken(arg_0));
        }
        if ((change = this.pendingChangeTokens.remove(unit)) != null) {
            change.forEach(arg_0 -> ((CashuWallet)this.wallet).removeToken(arg_0));
        }
    }

    private static List<CashuProof> getUnspentProofs(List<CashuToken> nostrTokenList, List<CashuProof> spentProofs) {
        ArrayList<CashuProof> unspentProofs = new ArrayList<CashuProof>(nostrTokenList.stream().flatMap(token -> token.getProofs().stream()).collect(Collectors.toList()));
        unspentProofs.removeAll(spentProofs);
        return unspentProofs;
    }

    public static PublicKey getPublicKey(@NonNull String keysetId, @NonNull String unit, @NonNull Integer amount, @NonNull String mintUrl) {
        if (keysetId == null) {
            throw new NullPointerException("keysetId is marked non-null but is null");
        }
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        if (mintUrl == null) {
            throw new NullPointerException("mintUrl is marked non-null but is null");
        }
        log.debug("getPublicKey called");
        MintUtil mintUtil = new MintUtil(unit, mintUrl);
        List keySetList = ((GetKeySetsResponse)mintUtil.getKeySetPublicKey(null).execute()).getKeySets();
        for (KeySet ks : keySetList) {
            if (!ks.getId().equals(keysetId)) continue;
            return ks.getKeys().get(amount.intValue());
        }
        throw new IllegalStateException("Keyset not found");
    }

    public static String getKeysetId(@NonNull MintUtil mintUtil) {
        if (mintUtil == null) {
            throw new NullPointerException("mintUtil is marked non-null but is null");
        }
        log.debug("getKeysetId called");
        return mintUtil.getKeysetId();
    }

    public String getKeysetId() {
        log.debug("getKeysetId called");
        return this.mintUtil.getKeysetId();
    }

    public PostMintRequest<T> createPostMintRequest(@NonNull String quote, @NonNull Integer amount, byte[] p2pkPublicKey) {
        if (quote == null) {
            throw new NullPointerException("quote is marked non-null but is null");
        }
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        log.debug("createPostMintRequest called");
        String keysetId = this.getKeysetId();
        Map<Integer, Integer> change = this.splitService.withAllDenominations(amount, this.mintUtil);
        return WalletUtil.createPostMintRequest(quote, change, keysetId, p2pkPublicKey);
    }

    public static <T extends Secret> PostMintRequest<T> createPostMintRequest(@NonNull String quote, @NonNull Integer amount, @NonNull MintUtil mintUtil, byte[] p2pkPublicKey) {
        if (quote == null) {
            throw new NullPointerException("quote is marked non-null but is null");
        }
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        if (mintUtil == null) {
            throw new NullPointerException("mintUtil is marked non-null but is null");
        }
        log.debug("createPostMintRequest called");
        String keysetId = WalletUtil.getKeysetId(mintUtil);
        Map<Integer, Integer> change = new DefaultSplitService().withAllDenominations(amount, mintUtil);
        return WalletUtil.createPostMintRequest(quote, change, keysetId, p2pkPublicKey);
    }

    public <T extends Secret> PostMintRequest<T> createPostMintRequest(@NonNull String quote, @NonNull Integer amount, @NonNull String unit, @NonNull String mintUrl, byte[] p2pkPublicKey) {
        if (quote == null) {
            throw new NullPointerException("quote is marked non-null but is null");
        }
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        if (mintUrl == null) {
            throw new NullPointerException("mintUrl is marked non-null but is null");
        }
        log.debug("createPostMintRequest called");
        MintUtil mintUtil = new MintUtil(unit, mintUrl);
        String keysetId = WalletUtil.getKeysetId(mintUtil);
        Map<Integer, Integer> change = new DefaultSplitService().withAllDenominations(amount, mintUtil);
        return WalletUtil.createPostMintRequest(quote, change, keysetId, p2pkPublicKey);
    }

    public PostMintRequest<T> createPostMintRequest(@NonNull String quote, @NonNull BlindedMessage blindedMessage, byte[] p2pkPublicKey) {
        if (quote == null) {
            throw new NullPointerException("quote is marked non-null but is null");
        }
        if (blindedMessage == null) {
            throw new NullPointerException("blindedMessage is marked non-null but is null");
        }
        log.debug("createPostMintRequest called");
        return this.createPostMintRequest(quote, blindedMessage.getAmount(), p2pkPublicKey);
    }

    public void deleteToken(@NonNull CashuToken token, @NonNull String unit) {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        log.debug("deleteToken called");
        log.info(">>> Deleting token from wallet: {} sat(s) from {}", (Object)token.calculateAmount(), (Object)this.wallet.getBalance());
        NostrEventService nostrEventService = new NostrEventService(this.wallet, this.identity);
        try {
            GenericEvent event = nostrEventService.publishDeletionEvent(token, unit);
            if (event != null) {
                nostrEventService.publishSpendingHistoryEvent(event, unit, SpendingHistory.Direction.SENT);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to delete token: " + e.getMessage(), e);
        }
    }

    public void removeProofFromWallet(@NonNull CashuProof proof, @NonNull String unit) {
        if (proof == null) {
            throw new NullPointerException("proof is marked non-null but is null");
        }
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        log.debug("removeProofFromWallet called");
        CashuToken token = this.wallet.getTokens().stream().filter(t -> t.getProofs().contains(proof)).findFirst().orElseThrow(() -> new IllegalStateException("Proof not found in wallet"));
        this.wallet.removeToken(token);
        this.deleteToken(token, unit);
        token.getProofs().remove(proof);
        if (!token.getProofs().isEmpty()) {
            this.addToken(token, unit);
        }
    }

    public void addTokens(@NonNull List<CashuToken> token, @NonNull String unit) {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        log.debug("addTokens called");
        token.forEach(t -> this.addToken((CashuToken)t, unit));
    }

    public void addTokens(@NonNull List<CashuToken> token, @NonNull String unit, Map<String, String> relays) {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        log.debug("addTokens called");
        token.forEach(t -> this.addToken((CashuToken)t, unit, relays));
    }

    public void deleteTokens(@NonNull List<CashuToken> token, @NonNull String unit) {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        log.debug("deleteTokens called");
        token.forEach(t -> {
            try {
                this.deleteToken((CashuToken)t, unit);
            }
            catch (Exception e) {
                log.warn("Failed to delete token: {}", (Object)e.getMessage());
            }
        });
    }

    public void addToken(@NonNull CashuToken token, @NonNull String unit) {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        this.addToken(token, unit, null);
    }

    public void addToken(@NonNull CashuToken token, @NonNull String unit, Map<String, String> relays) {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        log.debug("addToken called");
        log.info(">>> Adding token to wallet: {} sat(s) to {}", (Object)token.calculateAmount(), (Object)this.wallet.getBalance());
        if (token.calculateAmount() == 0) {
            return;
        }
        this.wallet.addToken(token);
        NostrEventService nostrEventService = new NostrEventService(this.wallet, this.identity);
        Map<String, String> relayMap = relays;
        if (relayMap == null || relayMap.isEmpty()) {
            Set configured = this.wallet.getRelays(unit);
            relayMap = configured != null && !configured.isEmpty() ? configured.stream().collect(Collectors.toMap(Relay::getHost, Relay::getUri)) : NostrEventService.getRelays(this.wallet, this.identity);
        }
        GenericEvent event = nostrEventService.publishTokenEvent(token, relayMap);
        nostrEventService.publishSpendingHistoryEvent(event, unit, SpendingHistory.Direction.RECEIVED, relayMap);
    }

    public static <T extends Secret> CashuWallet extractWallet(@NonNull GenericEvent event, @NonNull Identity identity) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        if (identity == null) {
            throw new NullPointerException("identity is marked non-null but is null");
        }
        log.debug("extractWallet called");
        if (Kind.WALLET.getValue() != event.getKind().intValue()) {
            throw new IllegalArgumentException("Event is not a wallet event");
        }
        CashuWallet wallet = new CashuWallet();
        NostrEventService service = new NostrEventService(wallet, identity);
        String content = service.getContent(event);
        WalletUtil.processWalletContent(wallet, content, false);
        WalletUtil.processWalletTags(wallet, event);
        return wallet;
    }

    private static void processWalletContent(CashuWallet wallet, String content, boolean updateWalletBalance) {
        if (wallet == null) {
            throw new IllegalStateException("wallet is null");
        }
        try {
            JsonNode contentNode = new ObjectMapper().readTree(content);
            if (contentNode.isArray()) {
                block10: for (JsonNode item : contentNode) {
                    if (!item.isArray() || item.size() < 2) continue;
                    String type = item.get(0).asText();
                    String value = item.get(1).asText();
                    switch (type) {
                        case "balance": {
                            WalletUtil.processBalance(wallet, value, updateWalletBalance);
                            continue block10;
                        }
                        case "privkey": {
                            WalletUtil.processPrivKey(wallet, value);
                            continue block10;
                        }
                    }
                    log.debug("Ignoring unknown wallet attribute '{}'", (Object)type);
                }
            } else {
                log.warn("Event content is not an array.");
            }
        }
        catch (JsonProcessingException e) {
            log.error("Error parsing wallet content: {}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    private static void processWalletTags(CashuWallet wallet, GenericEvent event) {
        if (wallet == null) {
            throw new IllegalStateException("wallet is null");
        }
        String unit = WalletUtil.getUnit(event);
        WalletUtil.processDescriptionTag(wallet, event);
        WalletUtil.processRelayTags(wallet, event, unit);
        WalletUtil.processMintTags(wallet, event);
        WalletUtil.processIdentifierTag(event, "d", arg_0 -> ((CashuWallet)wallet).setId(arg_0));
        WalletUtil.processGenericTag(event, "name", arg_0 -> ((CashuWallet)wallet).setName(arg_0));
    }

    private static void processGenericTag(GenericEvent event, String tagCode, Consumer<String> setter) {
        event.getTags().stream().filter(tag -> tag.getCode().equals(tagCode)).map(tag -> (GenericTag)tag).findFirst().ifPresent(genericTag -> setter.accept(((ElementAttribute)genericTag.getAttributes().get(0)).value().toString()));
    }

    private static void processIdentifierTag(GenericEvent event, String tagCode, Consumer<String> setter) {
        event.getTags().stream().filter(tag -> tag.getCode().equals(tagCode)).map(tag -> (IdentifierTag)tag).findFirst().ifPresent(idTag -> setter.accept(idTag.getUuid()));
    }

    private static void processBalance(CashuWallet wallet, String value, boolean updateWalletBalance) {
        if (updateWalletBalance) {
            wallet.setBalance(Integer.valueOf(Integer.parseInt(value)));
        }
    }

    private static void processPrivKey(CashuWallet wallet, String value) {
        wallet.setPrivateKey(value);
    }

    private static void processDescriptionTag(CashuWallet wallet, GenericEvent event) {
        event.getTags().stream().filter(tag -> tag.getCode().equals("description")).map(tag -> (GenericTag)tag).findFirst().ifPresent(genericTag -> wallet.setDescription(((ElementAttribute)genericTag.getAttributes().get(0)).value().toString()));
    }

    private static void processRelayTags(CashuWallet wallet, GenericEvent event, String unit) {
        event.getTags().stream().filter(tag -> tag.getCode().equals("relay")).map(tag -> (GenericTag)tag).forEach(genericTag -> wallet.addRelay(unit, new Relay(((ElementAttribute)genericTag.getAttributes().get(0)).value().toString())));
    }

    private static void processMintTags(CashuWallet wallet, GenericEvent event) {
        event.getTags().stream().filter(tag -> tag.getCode().equals("mint")).map(tag -> (GenericTag)tag).forEach(genericTag -> wallet.getMints().add(new CashuMint(((ElementAttribute)genericTag.getAttributes().get(0)).value().toString())));
    }

    private static String getUnit(GenericEvent genericEvent) {
        return genericEvent.getTags().stream().filter(tag -> tag.getCode().equals("unit")).map(tag -> (GenericTag)tag).findFirst().map(tag -> ((ElementAttribute)tag.getAttributes().get(0)).value().toString()).orElseThrow(() -> new IllegalStateException("Unit tag missing in event " + String.valueOf(genericEvent)));
    }

    private static <T extends Secret> PostMintRequest<T> createPostMintRequest(@NonNull String quote, @NonNull Map<Integer, Integer> split, @NonNull String keysetId, byte[] p2pkPublicKey) {
        if (quote == null) {
            throw new NullPointerException("quote is marked non-null but is null");
        }
        if (split == null) {
            throw new NullPointerException("split is marked non-null but is null");
        }
        if (keysetId == null) {
            throw new NullPointerException("keysetId is marked non-null but is null");
        }
        PostMintRequest postMintRequest = new PostMintRequest();
        int counter = 0;
        for (Map.Entry<Integer, Integer> entry : split.entrySet()) {
            int splitAmount = entry.getKey();
            int splitCount = entry.getValue();
            for (int i = 0; i < splitCount; ++i) {
                T secret = WalletUtil.createSecret(p2pkPublicKey);
                byte[][] blindedMessage = BDHKEUtils.blindMessage((byte[])secret.toBytes());
                byte[] r = blindedMessage[1];
                PublicKey B_ = PublicKey.fromBytes((byte[])blindedMessage[0]);
                BlindedMessage bmsg = new BlindedMessage(splitAmount, KeysetId.fromString((String)keysetId), B_, null);
                postMintRequest.addSecret(secret, counter);
                postMintRequest.addBlindingFactor(r, counter);
                postMintRequest.addBlindMessage(bmsg, counter);
                ++counter;
            }
        }
        postMintRequest.setQuoteId(quote);
        return postMintRequest;
    }

    private static <T extends Secret> T createSecret(byte[] p2pkPublicKey) {
        SecretFactory secretFactory = new SecretFactory(p2pkPublicKey);
        return (T)secretFactory.create();
    }

    static Witness signProofInputs(@NonNull Secret secret, @NonNull PublicKey blindedMessage, byte[] privateKey) {
        if (secret == null) {
            throw new NullPointerException("secret is marked non-null but is null");
        }
        if (blindedMessage == null) {
            throw new NullPointerException("blindedMessage is marked non-null but is null");
        }
        if (secret instanceof WellKnownSecret) {
            byte[] data = blindedMessage.toBytes();
            byte[] signature = Schnorr.sign((byte[])Utils.sha256((byte[])data), (byte[])privateKey);
            Witness witness = new Witness();
            witness.addSignature(Hex.toHexString((byte[])signature));
            return witness;
        }
        return null;
    }

    static P2PKSecret.SignatureFlag getSignatureFlag(@NonNull Secret secret) {
        List values;
        WellKnownSecret wellKnownSecret;
        WellKnownSecret.Tag tag;
        if (secret == null) {
            throw new NullPointerException("secret is marked non-null but is null");
        }
        if (secret instanceof WellKnownSecret && (tag = (WellKnownSecret.Tag)(wellKnownSecret = (WellKnownSecret)secret).getTags().stream().filter(t -> t.getKey().equals(P2PKSecret.P2PKTag.sigflag.name())).findFirst().orElse(null)) != null && tag.getValues() != null && !tag.getValues().isEmpty() && (values = tag.getValues()).size() == 1) {
            String value = values.get(0).toString();
            if (value.equals(P2PKSecret.SignatureFlag.SIG_INPUTS.name())) {
                return P2PKSecret.SignatureFlag.SIG_INPUTS;
            }
            if (value.equals(P2PKSecret.SignatureFlag.SIG_ALL.name())) {
                return P2PKSecret.SignatureFlag.SIG_ALL;
            }
        }
        return null;
    }

    @Generated
    public CashuWallet getWallet() {
        return this.wallet;
    }

    @Generated
    public MintUtil getMintUtil() {
        return this.mintUtil;
    }

    @Generated
    public Identity getIdentity() {
        return this.identity;
    }

    @Generated
    public SplitService getSplitService() {
        return this.splitService;
    }

    @Generated
    public Map<String, List<CashuToken>> getPendingTokens() {
        return this.pendingTokens;
    }

    @Generated
    public Map<String, List<CashuToken>> getPendingChangeTokens() {
        return this.pendingChangeTokens;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WalletUtil)) {
            return false;
        }
        WalletUtil other = (WalletUtil)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CashuWallet this$wallet = this.getWallet();
        CashuWallet other$wallet = other.getWallet();
        if (this$wallet == null ? other$wallet != null : !this$wallet.equals(other$wallet)) {
            return false;
        }
        MintUtil this$mintUtil = this.getMintUtil();
        MintUtil other$mintUtil = other.getMintUtil();
        if (this$mintUtil == null ? other$mintUtil != null : !this$mintUtil.equals(other$mintUtil)) {
            return false;
        }
        Identity this$identity = this.getIdentity();
        Identity other$identity = other.getIdentity();
        if (this$identity == null ? other$identity != null : !this$identity.equals(other$identity)) {
            return false;
        }
        SplitService this$splitService = this.getSplitService();
        SplitService other$splitService = other.getSplitService();
        if (this$splitService == null ? other$splitService != null : !this$splitService.equals(other$splitService)) {
            return false;
        }
        Map<String, List<CashuToken>> this$pendingTokens = this.getPendingTokens();
        Map<String, List<CashuToken>> other$pendingTokens = other.getPendingTokens();
        if (this$pendingTokens == null ? other$pendingTokens != null : !((Object)this$pendingTokens).equals(other$pendingTokens)) {
            return false;
        }
        Map<String, List<CashuToken>> this$pendingChangeTokens = this.getPendingChangeTokens();
        Map<String, List<CashuToken>> other$pendingChangeTokens = other.getPendingChangeTokens();
        return !(this$pendingChangeTokens == null ? other$pendingChangeTokens != null : !((Object)this$pendingChangeTokens).equals(other$pendingChangeTokens));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof WalletUtil;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CashuWallet $wallet = this.getWallet();
        result = result * 59 + ($wallet == null ? 43 : $wallet.hashCode());
        MintUtil $mintUtil = this.getMintUtil();
        result = result * 59 + ($mintUtil == null ? 43 : $mintUtil.hashCode());
        Identity $identity = this.getIdentity();
        result = result * 59 + ($identity == null ? 43 : $identity.hashCode());
        SplitService $splitService = this.getSplitService();
        result = result * 59 + ($splitService == null ? 43 : $splitService.hashCode());
        Map<String, List<CashuToken>> $pendingTokens = this.getPendingTokens();
        result = result * 59 + ($pendingTokens == null ? 43 : ((Object)$pendingTokens).hashCode());
        Map<String, List<CashuToken>> $pendingChangeTokens = this.getPendingChangeTokens();
        result = result * 59 + ($pendingChangeTokens == null ? 43 : ((Object)$pendingChangeTokens).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "WalletUtil(wallet=" + String.valueOf(this.getWallet()) + ", mintUtil=" + String.valueOf(this.getMintUtil()) + ", identity=" + String.valueOf(this.getIdentity()) + ", splitService=" + String.valueOf(this.getSplitService()) + ", pendingTokens=" + String.valueOf(this.getPendingTokens()) + ", pendingChangeTokens=" + String.valueOf(this.getPendingChangeTokens()) + ")";
    }

    @Generated
    public WalletUtil(CashuWallet wallet, MintUtil mintUtil, Identity identity, SplitService splitService) {
        this.wallet = wallet;
        this.mintUtil = mintUtil;
        this.identity = identity;
        this.splitService = splitService;
    }
}

