/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.nostr.cashu.wallet.service.impl;

import lombok.NonNull;
import xyz.tcheeric.cashu.common.PaymentMethod;
import xyz.tcheeric.cashu.common.Secret;
import xyz.tcheeric.cashu.entities.rest.PostMintQuoteRequest;
import xyz.tcheeric.cashu.entities.rest.PostMintQuoteResponse;
import xyz.tcheeric.cashu.entities.rest.PostMintRequest;
import xyz.tcheeric.cashu.entities.rest.PostMintResponse;
import xyz.tcheeric.cashu.wallet.client.impl.RequestCheckMintQuoteState;
import xyz.tcheeric.cashu.wallet.client.impl.RequestMintQuote;
import xyz.tcheeric.cashu.wallet.client.impl.RequestMintToken;
import xyz.tcheeric.nostr.cashu.wallet.service.MintException;
import xyz.tcheeric.nostr.cashu.wallet.service.MintingService;

public class DefaultMintingService<T extends Secret>
implements MintingService<T> {
    private final PaymentMethod paymentMethod;
    private final String mintUrl;

    public DefaultMintingService(@NonNull PaymentMethod paymentMethod, @NonNull String mintUrl) {
        if (paymentMethod == null) {
            throw new NullPointerException("paymentMethod is marked non-null but is null");
        }
        if (mintUrl == null) {
            throw new NullPointerException("mintUrl is marked non-null but is null");
        }
        this.paymentMethod = paymentMethod;
        this.mintUrl = mintUrl;
    }

    @Override
    public PostMintQuoteResponse quote(PostMintQuoteRequest request) {
        RequestMintQuote requestMintQuote = new RequestMintQuote(this.mintUrl, this.paymentMethod, request);
        try {
            return (PostMintQuoteResponse)requestMintQuote.execute();
        }
        catch (MintException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MintException(this.mintUrl, this.paymentMethod, "Failed to request mint quote", e);
        }
    }

    @Override
    public PostMintQuoteResponse checkQuote(String quoteId) {
        RequestCheckMintQuoteState requestCheckMintQuoteState = new RequestCheckMintQuoteState(this.mintUrl, quoteId, this.paymentMethod.name());
        return (PostMintQuoteResponse)requestCheckMintQuoteState.execute();
    }

    @Override
    public PostMintResponse mint(PostMintRequest<T> request) {
        RequestMintToken requestMintToken = new RequestMintToken(this.mintUrl, this.paymentMethod, request);
        try {
            return (PostMintResponse)requestMintToken.execute();
        }
        catch (MintException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MintException(this.mintUrl, this.paymentMethod, "Failed to request mint token", e);
        }
    }
}

