/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.nostr.cashu.config;

import lombok.Generated;
import lombok.NonNull;
import xyz.tcheeric.nostr.cashu.util.RetryPolicy;

public final class ExecutorOptions {
    private final long timeoutSeconds;
    private final RetryPolicy retryPolicy;

    private ExecutorOptions(Builder builder) {
        this.timeoutSeconds = builder.timeoutSeconds;
        this.retryPolicy = builder.retryPolicy;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ExecutorOptions defaults() {
        return ExecutorOptions.builder().build();
    }

    @Generated
    public long getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    @Generated
    public RetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    public static final class Builder {
        private long timeoutSeconds = 15L;
        private RetryPolicy retryPolicy = RetryPolicy.noRetries();

        public Builder timeoutSeconds(long timeoutSeconds) {
            if (timeoutSeconds < 0L) {
                throw new IllegalArgumentException("timeoutSeconds must be non-negative");
            }
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        public Builder retryPolicy(@NonNull RetryPolicy retryPolicy) {
            if (retryPolicy == null) {
                throw new NullPointerException("retryPolicy is marked non-null but is null");
            }
            this.retryPolicy = retryPolicy;
            return this;
        }

        public ExecutorOptions build() {
            return new ExecutorOptions(this);
        }
    }
}

