/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.nostr.cashu.config;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;
import xyz.tcheeric.nostr.cashu.config.ExecutorOptions;
import xyz.tcheeric.nostr.cashu.config.RelayConfig;
import xyz.tcheeric.nostr.cashu.config.RelayOptions;
import xyz.tcheeric.nostr.cashu.relay.RelayMetrics;
import xyz.tcheeric.nostr.cashu.util.AsyncExecutor;
import xyz.tcheeric.nostr.cashu.util.DefaultAsyncExecutor;

public final class NostrCashuOptions {
    private final Map<String, RelayOptions> relays;
    private final Map<String, String> authSecrets;
    private final ExecutorOptions executorOptions;
    private final AsyncExecutor executor;

    private NostrCashuOptions(Builder builder) {
        this.relays = Collections.unmodifiableMap(new LinkedHashMap<String, RelayOptions>(builder.relays));
        this.authSecrets = Collections.unmodifiableMap(new LinkedHashMap<String, String>(builder.authSecrets));
        this.executorOptions = builder.executorOptions != null ? builder.executorOptions : ExecutorOptions.defaults();
        this.executor = builder.executor != null ? builder.executor : new DefaultAsyncExecutor(this.executorOptions);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static NostrCashuOptions defaults() {
        return NostrCashuOptions.builder().build();
    }

    public Optional<RelayOptions> relay(@NonNull String alias) {
        if (alias == null) {
            throw new NullPointerException("alias is marked non-null but is null");
        }
        return Optional.ofNullable(this.relays.get(alias));
    }

    public Map<String, String> relayUris() {
        LinkedHashMap result = new LinkedHashMap();
        this.relays.forEach((alias, config) -> result.put(alias, config.getUri()));
        return Collections.unmodifiableMap(result);
    }

    public Map<String, String> relaySecrets() {
        LinkedHashMap result = new LinkedHashMap();
        this.relays.forEach((alias, config) -> config.writeSecret().ifPresent(secret -> result.put(alias, secret)));
        this.authSecrets.forEach(result::putIfAbsent);
        return Collections.unmodifiableMap(result);
    }

    public Map<String, RelayOptions> getRelayOptions() {
        return this.relays;
    }

    public Map<String, RelayMetrics> relayMetrics() {
        LinkedHashMap metrics = new LinkedHashMap();
        this.relays.forEach((alias, options) -> metrics.put(alias, options.getMetrics()));
        return Collections.unmodifiableMap(metrics);
    }

    @Generated
    public Map<String, RelayOptions> getRelays() {
        return this.relays;
    }

    @Generated
    public Map<String, String> getAuthSecrets() {
        return this.authSecrets;
    }

    @Generated
    public ExecutorOptions getExecutorOptions() {
        return this.executorOptions;
    }

    @Generated
    public AsyncExecutor getExecutor() {
        return this.executor;
    }

    public static final class Builder {
        private final Map<String, RelayOptions> relays = new LinkedHashMap<String, RelayOptions>();
        private final Map<String, String> authSecrets = new LinkedHashMap<String, String>();
        private ExecutorOptions executorOptions;
        private AsyncExecutor executor;

        public Builder relay(@NonNull String alias, @NonNull RelayOptions options) {
            if (alias == null) {
                throw new NullPointerException("alias is marked non-null but is null");
            }
            if (options == null) {
                throw new NullPointerException("options is marked non-null but is null");
            }
            this.relays.merge(alias, options, (existing, override) -> existing.merge((RelayOptions)override));
            return this;
        }

        public Builder relay(@NonNull String alias, @NonNull RelayConfig config) {
            if (alias == null) {
                throw new NullPointerException("alias is marked non-null but is null");
            }
            if (config == null) {
                throw new NullPointerException("config is marked non-null but is null");
            }
            return this.relay(alias, RelayOptions.fromConfig(config));
        }

        public Builder relays(@NonNull Map<String, RelayOptions> entries) {
            if (entries == null) {
                throw new NullPointerException("entries is marked non-null but is null");
            }
            entries.forEach(this::relay);
            return this;
        }

        public Builder relaysFromConfig(@NonNull Map<String, RelayConfig> entries) {
            if (entries == null) {
                throw new NullPointerException("entries is marked non-null but is null");
            }
            entries.forEach((alias, config) -> this.relay((String)alias, RelayOptions.fromConfig(config)));
            return this;
        }

        public Builder authSecret(@NonNull String alias, @NonNull String secret) {
            if (alias == null) {
                throw new NullPointerException("alias is marked non-null but is null");
            }
            if (secret == null) {
                throw new NullPointerException("secret is marked non-null but is null");
            }
            this.authSecrets.put(alias, secret);
            return this;
        }

        public Builder authSecrets(@NonNull Map<String, String> secrets) {
            if (secrets == null) {
                throw new NullPointerException("secrets is marked non-null but is null");
            }
            this.authSecrets.putAll(secrets);
            return this;
        }

        public Builder executorOptions(@NonNull ExecutorOptions options) {
            if (options == null) {
                throw new NullPointerException("options is marked non-null but is null");
            }
            this.executorOptions = options;
            return this;
        }

        public Builder executor(@NonNull AsyncExecutor executor) {
            if (executor == null) {
                throw new NullPointerException("executor is marked non-null but is null");
            }
            this.executor = executor;
            return this;
        }

        public NostrCashuOptions build() {
            this.relays.entrySet().removeIf(entry -> Objects.isNull(entry.getValue()));
            return new NostrCashuOptions(this);
        }
    }
}

