/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.nostr.cashu.config;

import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;

public final class RelayConfig {
    @NonNull
    private final String uri;
    private final String writeAuthSecret;
    private final String readAuthSecret;

    public static RelayConfig of(@NonNull String uri) {
        if (uri == null) {
            throw new NullPointerException("uri is marked non-null but is null");
        }
        return RelayConfig.builder().uri(uri).build();
    }

    public Optional<String> writeSecret() {
        return Optional.ofNullable(this.writeAuthSecret).filter(value -> !value.isBlank());
    }

    public Optional<String> readSecret() {
        return Optional.ofNullable(this.readAuthSecret).filter(value -> !value.isBlank());
    }

    public RelayConfig merge(RelayConfig override) {
        if (override == null) {
            return this;
        }
        if (Objects.equals(this, override)) {
            return this;
        }
        return RelayConfig.builder().uri(override.uri != null ? override.uri : this.uri).writeAuthSecret(override.writeAuthSecret != null ? override.writeAuthSecret : this.writeAuthSecret).readAuthSecret(override.readAuthSecret != null ? override.readAuthSecret : this.readAuthSecret).build();
    }

    @Generated
    RelayConfig(@NonNull String uri, String writeAuthSecret, String readAuthSecret) {
        if (uri == null) {
            throw new NullPointerException("uri is marked non-null but is null");
        }
        this.uri = uri;
        this.writeAuthSecret = writeAuthSecret;
        this.readAuthSecret = readAuthSecret;
    }

    @Generated
    public static RelayConfigBuilder builder() {
        return new RelayConfigBuilder();
    }

    @NonNull
    @Generated
    public String getUri() {
        return this.uri;
    }

    @Generated
    public String getWriteAuthSecret() {
        return this.writeAuthSecret;
    }

    @Generated
    public String getReadAuthSecret() {
        return this.readAuthSecret;
    }

    @Generated
    public String toString() {
        return "RelayConfig(uri=" + this.getUri() + ", writeAuthSecret=" + this.getWriteAuthSecret() + ", readAuthSecret=" + this.getReadAuthSecret() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RelayConfig)) {
            return false;
        }
        RelayConfig other = (RelayConfig)o;
        String this$uri = this.getUri();
        String other$uri = other.getUri();
        if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
            return false;
        }
        String this$writeAuthSecret = this.getWriteAuthSecret();
        String other$writeAuthSecret = other.getWriteAuthSecret();
        if (this$writeAuthSecret == null ? other$writeAuthSecret != null : !this$writeAuthSecret.equals(other$writeAuthSecret)) {
            return false;
        }
        String this$readAuthSecret = this.getReadAuthSecret();
        String other$readAuthSecret = other.getReadAuthSecret();
        return !(this$readAuthSecret == null ? other$readAuthSecret != null : !this$readAuthSecret.equals(other$readAuthSecret));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $uri = this.getUri();
        result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
        String $writeAuthSecret = this.getWriteAuthSecret();
        result = result * 59 + ($writeAuthSecret == null ? 43 : $writeAuthSecret.hashCode());
        String $readAuthSecret = this.getReadAuthSecret();
        result = result * 59 + ($readAuthSecret == null ? 43 : $readAuthSecret.hashCode());
        return result;
    }

    @Generated
    public static class RelayConfigBuilder {
        @Generated
        private String uri;
        @Generated
        private String writeAuthSecret;
        @Generated
        private String readAuthSecret;

        @Generated
        RelayConfigBuilder() {
        }

        @Generated
        public RelayConfigBuilder uri(@NonNull String uri) {
            if (uri == null) {
                throw new NullPointerException("uri is marked non-null but is null");
            }
            this.uri = uri;
            return this;
        }

        @Generated
        public RelayConfigBuilder writeAuthSecret(String writeAuthSecret) {
            this.writeAuthSecret = writeAuthSecret;
            return this;
        }

        @Generated
        public RelayConfigBuilder readAuthSecret(String readAuthSecret) {
            this.readAuthSecret = readAuthSecret;
            return this;
        }

        @Generated
        public RelayConfig build() {
            return new RelayConfig(this.uri, this.writeAuthSecret, this.readAuthSecret);
        }

        @Generated
        public String toString() {
            return "RelayConfig.RelayConfigBuilder(uri=" + this.uri + ", writeAuthSecret=" + this.writeAuthSecret + ", readAuthSecret=" + this.readAuthSecret + ")";
        }
    }
}

