/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.nostr.cashu.config;

import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;
import xyz.tcheeric.nostr.cashu.config.RelayConfig;
import xyz.tcheeric.nostr.cashu.relay.RelayBackoff;
import xyz.tcheeric.nostr.cashu.relay.RelayMetrics;
import xyz.tcheeric.nostr.cashu.util.AsyncExecutor;

public final class RelayOptions {
    private static final Duration DEFAULT_HANDSHAKE_TIMEOUT = Duration.ofSeconds(3L);
    private static final Duration DEFAULT_DEGRADED_GRACE = Duration.ofSeconds(10L);
    private static final Duration DEFAULT_UNAVAILABLE_GRACE = Duration.ofSeconds(2L);
    @NonNull
    private final String uri;
    private final String writeAuthSecret;
    private final String readAuthSecret;
    private final AsyncExecutor executor;
    @NonNull
    private final RelayBackoff backoff;
    @NonNull
    private final Duration handshakeTimeout;
    @NonNull
    private final Duration degradedGracePeriod;
    @NonNull
    private final Duration unavailableGracePeriod;
    @NonNull
    private final RelayMetrics metrics;

    private RelayOptions(@NonNull String uri, String writeAuthSecret, String readAuthSecret, AsyncExecutor executor, RelayBackoff backoff, Duration handshakeTimeout, Duration degradedGracePeriod, Duration unavailableGracePeriod, RelayMetrics metrics) {
        this.uri = Objects.requireNonNull(uri, "uri");
        this.writeAuthSecret = writeAuthSecret;
        this.readAuthSecret = readAuthSecret;
        this.executor = executor;
        this.backoff = backoff != null ? backoff : RelayBackoff.defaults();
        this.handshakeTimeout = handshakeTimeout != null ? handshakeTimeout : DEFAULT_HANDSHAKE_TIMEOUT;
        this.degradedGracePeriod = degradedGracePeriod != null ? degradedGracePeriod : DEFAULT_DEGRADED_GRACE;
        this.unavailableGracePeriod = unavailableGracePeriod != null ? unavailableGracePeriod : DEFAULT_UNAVAILABLE_GRACE;
        this.metrics = metrics != null ? metrics : new RelayMetrics();
    }

    public Optional<String> writeSecret() {
        return Optional.ofNullable(this.writeAuthSecret).filter(value -> !value.isBlank());
    }

    public Optional<String> readSecret() {
        return Optional.ofNullable(this.readAuthSecret).filter(value -> !value.isBlank());
    }

    public RelayOptions merge(RelayOptions override) {
        if (override == null) {
            return this;
        }
        if (Objects.equals(this, override)) {
            return this;
        }
        return RelayOptions.builder().uri(override.uri != null ? override.uri : this.uri).writeAuthSecret(override.writeAuthSecret != null ? override.writeAuthSecret : this.writeAuthSecret).readAuthSecret(override.readAuthSecret != null ? override.readAuthSecret : this.readAuthSecret).executor(override.executor != null ? override.executor : this.executor).backoff(override.backoff != null ? override.backoff : this.backoff).handshakeTimeout(override.handshakeTimeout != null ? override.handshakeTimeout : this.handshakeTimeout).degradedGracePeriod(override.degradedGracePeriod != null ? override.degradedGracePeriod : this.degradedGracePeriod).unavailableGracePeriod(override.unavailableGracePeriod != null ? override.unavailableGracePeriod : this.unavailableGracePeriod).metrics(override.metrics != null ? override.metrics : this.metrics).build();
    }

    public static RelayOptions fromConfig(RelayConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("config must not be null");
        }
        return RelayOptions.builder().uri(config.getUri()).writeAuthSecret(config.getWriteAuthSecret()).readAuthSecret(config.getReadAuthSecret()).build();
    }

    @Generated
    public static RelayOptionsBuilder builder() {
        return new RelayOptionsBuilder();
    }

    @Generated
    public RelayOptionsBuilder toBuilder() {
        return new RelayOptionsBuilder().uri(this.uri).writeAuthSecret(this.writeAuthSecret).readAuthSecret(this.readAuthSecret).executor(this.executor).backoff(this.backoff).handshakeTimeout(this.handshakeTimeout).degradedGracePeriod(this.degradedGracePeriod).unavailableGracePeriod(this.unavailableGracePeriod).metrics(this.metrics);
    }

    @NonNull
    @Generated
    public String getUri() {
        return this.uri;
    }

    @Generated
    public String getWriteAuthSecret() {
        return this.writeAuthSecret;
    }

    @Generated
    public String getReadAuthSecret() {
        return this.readAuthSecret;
    }

    @Generated
    public AsyncExecutor getExecutor() {
        return this.executor;
    }

    @NonNull
    @Generated
    public RelayBackoff getBackoff() {
        return this.backoff;
    }

    @NonNull
    @Generated
    public Duration getHandshakeTimeout() {
        return this.handshakeTimeout;
    }

    @NonNull
    @Generated
    public Duration getDegradedGracePeriod() {
        return this.degradedGracePeriod;
    }

    @NonNull
    @Generated
    public Duration getUnavailableGracePeriod() {
        return this.unavailableGracePeriod;
    }

    @NonNull
    @Generated
    public RelayMetrics getMetrics() {
        return this.metrics;
    }

    @Generated
    public String toString() {
        return "RelayOptions(uri=" + this.getUri() + ", writeAuthSecret=" + this.getWriteAuthSecret() + ", readAuthSecret=" + this.getReadAuthSecret() + ", executor=" + String.valueOf(this.getExecutor()) + ", backoff=" + String.valueOf(this.getBackoff()) + ", handshakeTimeout=" + String.valueOf(this.getHandshakeTimeout()) + ", degradedGracePeriod=" + String.valueOf(this.getDegradedGracePeriod()) + ", unavailableGracePeriod=" + String.valueOf(this.getUnavailableGracePeriod()) + ", metrics=" + String.valueOf(this.getMetrics()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RelayOptions)) {
            return false;
        }
        RelayOptions other = (RelayOptions)o;
        String this$uri = this.getUri();
        String other$uri = other.getUri();
        if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
            return false;
        }
        String this$writeAuthSecret = this.getWriteAuthSecret();
        String other$writeAuthSecret = other.getWriteAuthSecret();
        if (this$writeAuthSecret == null ? other$writeAuthSecret != null : !this$writeAuthSecret.equals(other$writeAuthSecret)) {
            return false;
        }
        String this$readAuthSecret = this.getReadAuthSecret();
        String other$readAuthSecret = other.getReadAuthSecret();
        if (this$readAuthSecret == null ? other$readAuthSecret != null : !this$readAuthSecret.equals(other$readAuthSecret)) {
            return false;
        }
        AsyncExecutor this$executor = this.getExecutor();
        AsyncExecutor other$executor = other.getExecutor();
        if (this$executor == null ? other$executor != null : !this$executor.equals(other$executor)) {
            return false;
        }
        RelayBackoff this$backoff = this.getBackoff();
        RelayBackoff other$backoff = other.getBackoff();
        if (this$backoff == null ? other$backoff != null : !this$backoff.equals(other$backoff)) {
            return false;
        }
        Duration this$handshakeTimeout = this.getHandshakeTimeout();
        Duration other$handshakeTimeout = other.getHandshakeTimeout();
        if (this$handshakeTimeout == null ? other$handshakeTimeout != null : !((Object)this$handshakeTimeout).equals(other$handshakeTimeout)) {
            return false;
        }
        Duration this$degradedGracePeriod = this.getDegradedGracePeriod();
        Duration other$degradedGracePeriod = other.getDegradedGracePeriod();
        if (this$degradedGracePeriod == null ? other$degradedGracePeriod != null : !((Object)this$degradedGracePeriod).equals(other$degradedGracePeriod)) {
            return false;
        }
        Duration this$unavailableGracePeriod = this.getUnavailableGracePeriod();
        Duration other$unavailableGracePeriod = other.getUnavailableGracePeriod();
        if (this$unavailableGracePeriod == null ? other$unavailableGracePeriod != null : !((Object)this$unavailableGracePeriod).equals(other$unavailableGracePeriod)) {
            return false;
        }
        RelayMetrics this$metrics = this.getMetrics();
        RelayMetrics other$metrics = other.getMetrics();
        return !(this$metrics == null ? other$metrics != null : !this$metrics.equals(other$metrics));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $uri = this.getUri();
        result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
        String $writeAuthSecret = this.getWriteAuthSecret();
        result = result * 59 + ($writeAuthSecret == null ? 43 : $writeAuthSecret.hashCode());
        String $readAuthSecret = this.getReadAuthSecret();
        result = result * 59 + ($readAuthSecret == null ? 43 : $readAuthSecret.hashCode());
        AsyncExecutor $executor = this.getExecutor();
        result = result * 59 + ($executor == null ? 43 : $executor.hashCode());
        RelayBackoff $backoff = this.getBackoff();
        result = result * 59 + ($backoff == null ? 43 : $backoff.hashCode());
        Duration $handshakeTimeout = this.getHandshakeTimeout();
        result = result * 59 + ($handshakeTimeout == null ? 43 : ((Object)$handshakeTimeout).hashCode());
        Duration $degradedGracePeriod = this.getDegradedGracePeriod();
        result = result * 59 + ($degradedGracePeriod == null ? 43 : ((Object)$degradedGracePeriod).hashCode());
        Duration $unavailableGracePeriod = this.getUnavailableGracePeriod();
        result = result * 59 + ($unavailableGracePeriod == null ? 43 : ((Object)$unavailableGracePeriod).hashCode());
        RelayMetrics $metrics = this.getMetrics();
        result = result * 59 + ($metrics == null ? 43 : $metrics.hashCode());
        return result;
    }

    @Generated
    public static class RelayOptionsBuilder {
        @Generated
        private String uri;
        @Generated
        private String writeAuthSecret;
        @Generated
        private String readAuthSecret;
        @Generated
        private AsyncExecutor executor;
        @Generated
        private RelayBackoff backoff;
        @Generated
        private Duration handshakeTimeout;
        @Generated
        private Duration degradedGracePeriod;
        @Generated
        private Duration unavailableGracePeriod;
        @Generated
        private RelayMetrics metrics;

        @Generated
        RelayOptionsBuilder() {
        }

        @Generated
        public RelayOptionsBuilder uri(@NonNull String uri) {
            if (uri == null) {
                throw new NullPointerException("uri is marked non-null but is null");
            }
            this.uri = uri;
            return this;
        }

        @Generated
        public RelayOptionsBuilder writeAuthSecret(String writeAuthSecret) {
            this.writeAuthSecret = writeAuthSecret;
            return this;
        }

        @Generated
        public RelayOptionsBuilder readAuthSecret(String readAuthSecret) {
            this.readAuthSecret = readAuthSecret;
            return this;
        }

        @Generated
        public RelayOptionsBuilder executor(AsyncExecutor executor) {
            this.executor = executor;
            return this;
        }

        @Generated
        public RelayOptionsBuilder backoff(RelayBackoff backoff) {
            this.backoff = backoff;
            return this;
        }

        @Generated
        public RelayOptionsBuilder handshakeTimeout(Duration handshakeTimeout) {
            this.handshakeTimeout = handshakeTimeout;
            return this;
        }

        @Generated
        public RelayOptionsBuilder degradedGracePeriod(Duration degradedGracePeriod) {
            this.degradedGracePeriod = degradedGracePeriod;
            return this;
        }

        @Generated
        public RelayOptionsBuilder unavailableGracePeriod(Duration unavailableGracePeriod) {
            this.unavailableGracePeriod = unavailableGracePeriod;
            return this;
        }

        @Generated
        public RelayOptionsBuilder metrics(RelayMetrics metrics) {
            this.metrics = metrics;
            return this;
        }

        @Generated
        public RelayOptions build() {
            return new RelayOptions(this.uri, this.writeAuthSecret, this.readAuthSecret, this.executor, this.backoff, this.handshakeTimeout, this.degradedGracePeriod, this.unavailableGracePeriod, this.metrics);
        }

        @Generated
        public String toString() {
            return "RelayOptions.RelayOptionsBuilder(uri=" + this.uri + ", writeAuthSecret=" + this.writeAuthSecret + ", readAuthSecret=" + this.readAuthSecret + ", executor=" + String.valueOf(this.executor) + ", backoff=" + String.valueOf(this.backoff) + ", handshakeTimeout=" + String.valueOf(this.handshakeTimeout) + ", degradedGracePeriod=" + String.valueOf(this.degradedGracePeriod) + ", unavailableGracePeriod=" + String.valueOf(this.unavailableGracePeriod) + ", metrics=" + String.valueOf(this.metrics) + ")";
        }
    }
}

