/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.nostr.cashu.operation;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletionException;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.cashu.common.BlindSignature;
import xyz.tcheeric.cashu.common.KeysetId;
import xyz.tcheeric.cashu.common.P2PKSecret;
import xyz.tcheeric.cashu.common.PaymentMethod;
import xyz.tcheeric.cashu.common.PrivateKey;
import xyz.tcheeric.cashu.common.Proof;
import xyz.tcheeric.cashu.common.PublicKey;
import xyz.tcheeric.cashu.common.Secret;
import xyz.tcheeric.cashu.common.TokenV3;
import xyz.tcheeric.cashu.common.WellKnownSecret;
import xyz.tcheeric.cashu.common.Witness;
import xyz.tcheeric.cashu.crypto.util.Utils;
import xyz.tcheeric.cashu.entities.rest.PostMintQuoteRequest;
import xyz.tcheeric.cashu.entities.rest.PostMintQuoteResponse;
import xyz.tcheeric.cashu.entities.rest.PostMintRequest;
import xyz.tcheeric.cashu.entities.rest.PostMintResponse;
import xyz.tcheeric.cashu.wallet.proto.tasks.UnblindSignatureTask;
import xyz.tcheeric.nostr.cashu.operation.BaseOperation;
import xyz.tcheeric.nostr.cashu.util.AsyncExecutor;
import xyz.tcheeric.nostr.cashu.util.DefaultAsyncExecutor;
import xyz.tcheeric.nostr.cashu.util.MintUtil;
import xyz.tcheeric.nostr.cashu.util.TokenUtil;
import xyz.tcheeric.nostr.cashu.util.WalletUtil;
import xyz.tcheeric.nostr.cashu.wallet.service.MintingService;
import xyz.tcheeric.nostr.cashu.wallet.service.impl.DefaultMintingService;

public class MintOperation<T extends Secret>
extends BaseOperation {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MintOperation.class);
    private AsyncExecutor executor = new DefaultAsyncExecutor();
    private MintingService<T> mintingService;
    private List<Proof<T>> proofs;
    private TokenV3<T> token;

    public MintOperation(@NonNull PaymentMethod paymentMethod, @NonNull String mintUrl, @NonNull String unit) {
        this(paymentMethod, mintUrl, unit, new DefaultAsyncExecutor(), new DefaultMintingService(paymentMethod, mintUrl));
        if (paymentMethod == null) {
            throw new NullPointerException("paymentMethod is marked non-null but is null");
        }
        if (mintUrl == null) {
            throw new NullPointerException("mintUrl is marked non-null but is null");
        }
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
    }

    public MintOperation(@NonNull PaymentMethod paymentMethod, @NonNull String mintUrl, @NonNull String unit, @NonNull AsyncExecutor executor) {
        this(paymentMethod, mintUrl, unit, executor, new DefaultMintingService(paymentMethod, mintUrl));
        if (paymentMethod == null) {
            throw new NullPointerException("paymentMethod is marked non-null but is null");
        }
        if (mintUrl == null) {
            throw new NullPointerException("mintUrl is marked non-null but is null");
        }
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        if (executor == null) {
            throw new NullPointerException("executor is marked non-null but is null");
        }
    }

    public MintOperation(@NonNull PaymentMethod paymentMethod, @NonNull String mintUrl, @NonNull String unit, @NonNull AsyncExecutor executor, @NonNull MintingService<T> mintingService) {
        super(paymentMethod, mintUrl, unit);
        if (paymentMethod == null) {
            throw new NullPointerException("paymentMethod is marked non-null but is null");
        }
        if (mintUrl == null) {
            throw new NullPointerException("mintUrl is marked non-null but is null");
        }
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        if (executor == null) {
            throw new NullPointerException("executor is marked non-null but is null");
        }
        if (mintingService == null) {
            throw new NullPointerException("mintingService is marked non-null but is null");
        }
        this.executor = executor;
        this.mintingService = mintingService;
    }

    public PostMintQuoteResponse quote(@NonNull PostMintQuoteRequest postMintQuoteRequest) {
        PostMintQuoteResponse response;
        if (postMintQuoteRequest == null) {
            throw new NullPointerException("postMintQuoteRequest is marked non-null but is null");
        }
        log.debug("quote called");
        log.debug("quote({})", (Object)postMintQuoteRequest);
        try {
            response = this.executor.execute(() -> this.mintingService.quote(postMintQuoteRequest)).join();
        }
        catch (CompletionException e) {
            log.error("Failed to execute mint quote", e.getCause());
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (cause != null) {
                throw new IllegalStateException("Failed to execute mint quote", cause);
            }
            throw new IllegalStateException("Failed to execute mint quote", e);
        }
        if (response == null) {
            throw new IllegalStateException("Quote not received");
        }
        return response;
    }

    MintOperation<T> mint(@NonNull PostMintRequest<T> postMintRequest) {
        PostMintResponse mintResponse;
        if (postMintRequest == null) {
            throw new NullPointerException("postMintRequest is marked non-null but is null");
        }
        log.debug("execute called");
        log.info("execute({})", postMintRequest);
        try {
            mintResponse = this.executor.execute(() -> this.mintingService.mint(postMintRequest)).join();
        }
        catch (CompletionException e) {
            log.error("Failed to mint tokens", e.getCause());
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new RuntimeException("Failed to mint tokens", cause);
        }
        if (mintResponse == null) {
            throw new IllegalStateException("Mint response not received");
        }
        log.info("mint mintResponse: {}", (Object)mintResponse);
        List<Proof<T>> result = this.getProofs(postMintRequest, mintResponse);
        this.proofs = result;
        return this;
    }

    private List<Proof<T>> getProofs(PostMintRequest<T> postMintRequest, PostMintResponse mintResponse) {
        List signatures = mintResponse.getBlindSignatures();
        if (signatures.size() != postMintRequest.getSecrets().size()) {
            throw new IllegalStateException("Secrets size does not match signatures size");
        }
        if (signatures.size() != postMintRequest.getBlindingFactors().size()) {
            throw new IllegalStateException("Blinding factors size does not match signatures size");
        }
        ArrayList<Proof<T>> result = new ArrayList<Proof<T>>();
        for (int i = 0; i < signatures.size(); ++i) {
            Proof proof;
            BlindSignature C_ = (BlindSignature)signatures.get(i);
            Secret secret = postMintRequest.getSecret(i);
            BigInteger r = Utils.bigIntFromBytes((byte[])postMintRequest.getBlindingFactor(i));
            KeysetId keySetId = C_.getKeySetId();
            int amount = C_.getAmount();
            PublicKey K = WalletUtil.getPublicKey(keySetId.toString(), this.getUnit(), amount, this.getMintUrl());
            UnblindSignatureTask unblindSignatureTask = new UnblindSignatureTask(C_, r, K, secret);
            try {
                proof = this.executor.execute(() -> ((UnblindSignatureTask)unblindSignatureTask).execute()).join();
            }
            catch (CompletionException e) {
                log.error("Failed to unblind signature", e.getCause());
                throw new IllegalStateException("Failed to unblind signature", e);
            }
            result.add(proof);
        }
        return result;
    }

    public MintOperation<T> mint(int amount, @NonNull PostMintQuoteResponse quote, @NonNull WalletUtil<T> walletUtil, byte[] p2pkhPublicKey, PrivateKey privateKey) {
        if (quote == null) {
            throw new NullPointerException("quote is marked non-null but is null");
        }
        if (walletUtil == null) {
            throw new NullPointerException("walletUtil is marked non-null but is null");
        }
        log.debug("mint called");
        PostMintQuoteResponse postMintQuoteResponse = this.executor.execute(() -> this.mintingService.checkQuote(quote.getQuoteId())).join();
        if (postMintQuoteResponse.isPaid()) {
            throw new IllegalStateException("Quote has not been paid");
        }
        PostMintRequest<T> postMintRequest = walletUtil.createPostMintRequest(quote.getQuoteId(), amount, p2pkhPublicKey);
        this.mint(postMintRequest);
        List<Proof<T>> mintedProofs = this.getProofs();
        if (mintedProofs == null || mintedProofs.isEmpty()) {
            throw new IllegalStateException("No proofs minted");
        }
        int totalMinted = mintedProofs.stream().mapToInt(Proof::getAmount).sum();
        if (totalMinted != amount) {
            throw new IllegalStateException("Minted amount does not match requested amount");
        }
        MintOperation.processMintedProofs(p2pkhPublicKey, privateKey, mintedProofs);
        TokenV3<T> token = TokenUtil.createTokenV3(mintedProofs, this.getUnit(), this.getMintUrl());
        walletUtil.addTokens(TokenUtil.toCashuTokens(token), token.getUnit());
        this.proofs = mintedProofs;
        this.token = token;
        return this;
    }

    private static <T extends Secret> void processMintedProofs(byte[] p2pkhPublicKey, PrivateKey privateKey, List<Proof<T>> mintedProofs) {
        mintedProofs.forEach(proof -> {
            Secret secret = proof.getSecret();
            P2PKSecret.SignatureFlag signatureFlag = MintUtil.getSignatureFlag(secret);
            if (signatureFlag != null) {
                if (privateKey == null) {
                    throw new IllegalArgumentException("Private key is required");
                }
                Witness witness = MintUtil.signProofInputs(secret, privateKey.toBytes());
                proof.setWitness(witness);
            }
            if (secret instanceof WellKnownSecret) {
                if (p2pkhPublicKey == null) {
                    throw new IllegalArgumentException("P2PKH public key is required");
                }
                proof.setSecretData(p2pkhPublicKey);
            }
        });
    }

    public List<Proof<T>> getProofs() {
        return this.proofs == null ? null : Collections.unmodifiableList(this.proofs);
    }

    public TokenV3<T> getToken() {
        return this.token;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MintOperation)) {
            return false;
        }
        MintOperation other = (MintOperation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AsyncExecutor this$executor = this.getExecutor();
        AsyncExecutor other$executor = other.getExecutor();
        if (this$executor == null ? other$executor != null : !this$executor.equals(other$executor)) {
            return false;
        }
        MintingService<T> this$mintingService = this.getMintingService();
        MintingService<T> other$mintingService = other.getMintingService();
        if (this$mintingService == null ? other$mintingService != null : !this$mintingService.equals(other$mintingService)) {
            return false;
        }
        List<Proof<T>> this$proofs = this.getProofs();
        List<Proof<T>> other$proofs = other.getProofs();
        if (this$proofs == null ? other$proofs != null : !((Object)this$proofs).equals(other$proofs)) {
            return false;
        }
        TokenV3<T> this$token = this.getToken();
        TokenV3<T> other$token = other.getToken();
        return !(this$token == null ? other$token != null : !this$token.equals(other$token));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MintOperation;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        AsyncExecutor $executor = this.getExecutor();
        result = result * 59 + ($executor == null ? 43 : $executor.hashCode());
        MintingService<T> $mintingService = this.getMintingService();
        result = result * 59 + ($mintingService == null ? 43 : $mintingService.hashCode());
        List<Proof<T>> $proofs = this.getProofs();
        result = result * 59 + ($proofs == null ? 43 : ((Object)$proofs).hashCode());
        TokenV3<T> $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        return result;
    }

    @Generated
    public AsyncExecutor getExecutor() {
        return this.executor;
    }

    @Generated
    public MintingService<T> getMintingService() {
        return this.mintingService;
    }

    @Generated
    public void setExecutor(AsyncExecutor executor) {
        this.executor = executor;
    }

    @Generated
    public void setMintingService(MintingService<T> mintingService) {
        this.mintingService = mintingService;
    }

    @Generated
    public void setProofs(List<Proof<T>> proofs) {
        this.proofs = proofs;
    }

    @Generated
    public void setToken(TokenV3<T> token) {
        this.token = token;
    }

    @Override
    @Generated
    public String toString() {
        return "MintOperation(executor=" + String.valueOf(this.getExecutor()) + ", mintingService=" + String.valueOf(this.getMintingService()) + ", proofs=" + String.valueOf(this.getProofs()) + ", token=" + String.valueOf(this.getToken()) + ")";
    }

    @Generated
    public MintOperation() {
    }
}

