/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.nostr.cashu.operation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import nostr.event.entities.CashuWallet;
import nostr.id.Identity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.cashu.common.BlindSignature;
import xyz.tcheeric.cashu.common.PaymentMethod;
import xyz.tcheeric.cashu.common.PrivateKey;
import xyz.tcheeric.cashu.common.Proof;
import xyz.tcheeric.cashu.common.Secret;
import xyz.tcheeric.cashu.common.TokenV3;
import xyz.tcheeric.cashu.entities.rest.PostMintQuoteRequest;
import xyz.tcheeric.cashu.entities.rest.PostMintQuoteResponse;
import xyz.tcheeric.cashu.entities.rest.PostSwapRequest;
import xyz.tcheeric.cashu.entities.rest.PostSwapResponse;
import xyz.tcheeric.nostr.cashu.operation.BaseOperation;
import xyz.tcheeric.nostr.cashu.operation.MintOperation;
import xyz.tcheeric.nostr.cashu.operation.SendOperation;
import xyz.tcheeric.nostr.cashu.services.impl.DefaultSplitService;
import xyz.tcheeric.nostr.cashu.util.AsyncExecutor;
import xyz.tcheeric.nostr.cashu.util.DefaultAsyncExecutor;
import xyz.tcheeric.nostr.cashu.util.WalletUtil;
import xyz.tcheeric.nostr.cashu.wallet.service.MintingService;
import xyz.tcheeric.nostr.cashu.wallet.service.SwappingService;

public class SwapOperation<T extends Secret>
extends BaseOperation
implements SendOperation {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SwapOperation.class);
    private byte[] p2pkPublicKey;
    private PrivateKey privateKey;
    private AsyncExecutor executor;
    private MintOperation<T> mintOperation;
    private SwappingService<T> swappingService;
    private List<Proof<T>> proofs = Collections.synchronizedList(new ArrayList());
    private volatile TokenV3<T> token;

    public SwapOperation(@NonNull PaymentMethod paymentMethod, @NonNull String unit, @NonNull MintingService<T> mintingService, @NonNull SwappingService<T> swappingService) {
        this(paymentMethod, null, unit, null, null, new DefaultAsyncExecutor(), mintingService, swappingService);
        if (paymentMethod == null) {
            throw new NullPointerException("paymentMethod is marked non-null but is null");
        }
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        if (mintingService == null) {
            throw new NullPointerException("mintingService is marked non-null but is null");
        }
        if (swappingService == null) {
            throw new NullPointerException("swappingService is marked non-null but is null");
        }
    }

    public SwapOperation(@NonNull PaymentMethod paymentMethod, @NonNull String unit, byte[] p2pkPublicKey, PrivateKey privateKey, @NonNull MintingService<T> mintingService, @NonNull SwappingService<T> swappingService) {
        this(paymentMethod, null, unit, p2pkPublicKey, privateKey, new DefaultAsyncExecutor(), mintingService, swappingService);
        if (paymentMethod == null) {
            throw new NullPointerException("paymentMethod is marked non-null but is null");
        }
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        if (mintingService == null) {
            throw new NullPointerException("mintingService is marked non-null but is null");
        }
        if (swappingService == null) {
            throw new NullPointerException("swappingService is marked non-null but is null");
        }
    }

    public SwapOperation(@NonNull PaymentMethod paymentMethod, @NonNull String mintUrl, @NonNull String unit, @NonNull MintingService<T> mintingService, @NonNull SwappingService<T> swappingService) {
        this(paymentMethod, mintUrl, unit, null, null, new DefaultAsyncExecutor(), mintingService, swappingService);
        if (paymentMethod == null) {
            throw new NullPointerException("paymentMethod is marked non-null but is null");
        }
        if (mintUrl == null) {
            throw new NullPointerException("mintUrl is marked non-null but is null");
        }
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        if (mintingService == null) {
            throw new NullPointerException("mintingService is marked non-null but is null");
        }
        if (swappingService == null) {
            throw new NullPointerException("swappingService is marked non-null but is null");
        }
    }

    public SwapOperation(@NonNull PaymentMethod paymentMethod, @NonNull String mintUrl, @NonNull String unit, byte[] p2pkPublicKey, PrivateKey privateKey, @NonNull MintingService<T> mintingService, @NonNull SwappingService<T> swappingService) {
        this(paymentMethod, mintUrl, unit, p2pkPublicKey, privateKey, new DefaultAsyncExecutor(), mintingService, swappingService);
        if (paymentMethod == null) {
            throw new NullPointerException("paymentMethod is marked non-null but is null");
        }
        if (mintUrl == null) {
            throw new NullPointerException("mintUrl is marked non-null but is null");
        }
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        if (mintingService == null) {
            throw new NullPointerException("mintingService is marked non-null but is null");
        }
        if (swappingService == null) {
            throw new NullPointerException("swappingService is marked non-null but is null");
        }
    }

    public SwapOperation(@NonNull PaymentMethod paymentMethod, String mintUrl, @NonNull String unit, byte[] p2pkPublicKey, PrivateKey privateKey, @NonNull AsyncExecutor executor, @NonNull MintingService<T> mintingService, @NonNull SwappingService<T> swappingService) {
        super(paymentMethod, mintUrl, unit);
        if (paymentMethod == null) {
            throw new NullPointerException("paymentMethod is marked non-null but is null");
        }
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        if (executor == null) {
            throw new NullPointerException("executor is marked non-null but is null");
        }
        if (mintingService == null) {
            throw new NullPointerException("mintingService is marked non-null but is null");
        }
        if (swappingService == null) {
            throw new NullPointerException("swappingService is marked non-null but is null");
        }
        this.p2pkPublicKey = p2pkPublicKey;
        this.privateKey = privateKey;
        this.executor = executor;
        this.mintOperation = new MintOperation<T>(paymentMethod, mintUrl, unit, executor, mintingService);
        this.swappingService = swappingService;
    }

    public SwapOperation<T> swap(@NonNull PostSwapRequest<T> postSwapRequest) {
        if (postSwapRequest == null) {
            throw new NullPointerException("postSwapRequest is marked non-null but is null");
        }
        log.debug("execute called");
        PostSwapResponse postSwapResponse = this._swap(postSwapRequest);
        int amount = postSwapResponse.getBlindSignatures().stream().mapToInt(BlindSignature::getAmount).sum();
        PostMintQuoteRequest quoteRequest = new PostMintQuoteRequest();
        quoteRequest.setAmount(amount);
        quoteRequest.setUnit(this.getUnit());
        PostMintQuoteResponse postMintQuoteResponse = this.mintOperation.quote(quoteRequest);
        WalletUtil walletUtil = new WalletUtil(new CashuWallet(), this.getUnit(), this.getMintUrl(), Identity.generateRandomIdentity(), new DefaultSplitService());
        this.mintOperation.mint(amount, postMintQuoteResponse, walletUtil, this.p2pkPublicKey, this.privateKey);
        this.proofs = this.mintOperation.getProofs();
        this.token = this.mintOperation.getToken();
        return this;
    }

    public List<Proof<T>> getProofs() {
        return this.proofs != null ? this.proofs : Collections.emptyList();
    }

    public TokenV3<T> getToken() {
        if (this.token == null) {
            throw new IllegalStateException("Token is not available. Call swap() before calling getToken().");
        }
        return this.token;
    }

    private PostSwapResponse _swap(@NonNull PostSwapRequest<T> postSwapRequest) {
        if (postSwapRequest == null) {
            throw new NullPointerException("postSwapRequest is marked non-null but is null");
        }
        log.debug("swap called");
        log.info("swap({})", postSwapRequest);
        PostSwapResponse postSwapResponse = this.executor.execute(() -> this.swappingService.swap(postSwapRequest)).join();
        if (postSwapResponse == null) {
            throw new IllegalStateException("Post swap response not received");
        }
        log.info("swap response: {}", (Object)postSwapResponse);
        return postSwapResponse;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SwapOperation)) {
            return false;
        }
        SwapOperation other = (SwapOperation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (!Arrays.equals(this.getP2pkPublicKey(), other.getP2pkPublicKey())) {
            return false;
        }
        PrivateKey this$privateKey = this.getPrivateKey();
        PrivateKey other$privateKey = other.getPrivateKey();
        if (this$privateKey == null ? other$privateKey != null : !this$privateKey.equals(other$privateKey)) {
            return false;
        }
        AsyncExecutor this$executor = this.getExecutor();
        AsyncExecutor other$executor = other.getExecutor();
        if (this$executor == null ? other$executor != null : !this$executor.equals(other$executor)) {
            return false;
        }
        MintOperation<T> this$mintOperation = this.getMintOperation();
        MintOperation<T> other$mintOperation = other.getMintOperation();
        if (this$mintOperation == null ? other$mintOperation != null : !((Object)this$mintOperation).equals(other$mintOperation)) {
            return false;
        }
        SwappingService<T> this$swappingService = this.getSwappingService();
        SwappingService<T> other$swappingService = other.getSwappingService();
        if (this$swappingService == null ? other$swappingService != null : !this$swappingService.equals(other$swappingService)) {
            return false;
        }
        List<Proof<T>> this$proofs = this.getProofs();
        List<Proof<T>> other$proofs = other.getProofs();
        if (this$proofs == null ? other$proofs != null : !((Object)this$proofs).equals(other$proofs)) {
            return false;
        }
        TokenV3<T> this$token = this.getToken();
        TokenV3<T> other$token = other.getToken();
        return !(this$token == null ? other$token != null : !this$token.equals(other$token));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SwapOperation;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + Arrays.hashCode(this.getP2pkPublicKey());
        PrivateKey $privateKey = this.getPrivateKey();
        result = result * 59 + ($privateKey == null ? 43 : $privateKey.hashCode());
        AsyncExecutor $executor = this.getExecutor();
        result = result * 59 + ($executor == null ? 43 : $executor.hashCode());
        MintOperation<T> $mintOperation = this.getMintOperation();
        result = result * 59 + ($mintOperation == null ? 43 : ((Object)$mintOperation).hashCode());
        SwappingService<T> $swappingService = this.getSwappingService();
        result = result * 59 + ($swappingService == null ? 43 : $swappingService.hashCode());
        List<Proof<T>> $proofs = this.getProofs();
        result = result * 59 + ($proofs == null ? 43 : ((Object)$proofs).hashCode());
        TokenV3<T> $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        return result;
    }

    @Override
    @Generated
    public byte[] getP2pkPublicKey() {
        return this.p2pkPublicKey;
    }

    @Generated
    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    @Generated
    public AsyncExecutor getExecutor() {
        return this.executor;
    }

    @Generated
    public MintOperation<T> getMintOperation() {
        return this.mintOperation;
    }

    @Generated
    public SwappingService<T> getSwappingService() {
        return this.swappingService;
    }

    @Override
    @Generated
    public void setP2pkPublicKey(byte[] p2pkPublicKey) {
        this.p2pkPublicKey = p2pkPublicKey;
    }

    @Generated
    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    @Generated
    public void setExecutor(AsyncExecutor executor) {
        this.executor = executor;
    }

    @Generated
    public void setMintOperation(MintOperation<T> mintOperation) {
        this.mintOperation = mintOperation;
    }

    @Generated
    public void setSwappingService(SwappingService<T> swappingService) {
        this.swappingService = swappingService;
    }

    @Generated
    public void setProofs(List<Proof<T>> proofs) {
        this.proofs = proofs;
    }

    @Generated
    public void setToken(TokenV3<T> token) {
        this.token = token;
    }

    @Override
    @Generated
    public String toString() {
        return "SwapOperation(p2pkPublicKey=" + Arrays.toString(this.getP2pkPublicKey()) + ", privateKey=" + String.valueOf(this.getPrivateKey()) + ", executor=" + String.valueOf(this.getExecutor()) + ", mintOperation=" + String.valueOf(this.getMintOperation()) + ", swappingService=" + String.valueOf(this.getSwappingService()) + ", proofs=" + String.valueOf(this.getProofs()) + ", token=" + String.valueOf(this.getToken()) + ")";
    }
}

