/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.nostr.cashu.parser;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.cashu.common.Proof;
import xyz.tcheeric.cashu.common.Secret;
import xyz.tcheeric.cashu.common.Signature;
import xyz.tcheeric.cashu.common.TokenV3;
import xyz.tcheeric.cashu.common.Witness;
import xyz.tcheeric.cashu.common.util.SecretUtil;

public class TokenParser<T extends Secret> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TokenParser.class);

    public TokenV3<T> parse(@NonNull String content, @NonNull String unit) {
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        log.debug("parse called");
        try {
            JsonNode contentNode = new ObjectMapper().readTree(content);
            TokenV3 token = new TokenV3();
            token.setUnit(unit);
            TokenV3.MintProof mintProof = new TokenV3.MintProof();
            mintProof.setMint(contentNode.get("mint").asText());
            mintProof.setProofs(StreamSupport.stream(contentNode.get("proofs").spliterator(), false).map(p -> {
                Proof proof = new Proof();
                proof.setAmount(p.get("amount").asInt());
                proof.setSecret(SecretUtil.toSecret((Object)p.get("secret").asText()));
                proof.setKeySetId(p.get("id").asText());
                proof.setWitness(p.get("witness") != null ? new Witness(List.of(p.get("witness").asText().split(","))) : null);
                proof.setUnblindedSignature(Signature.fromString((String)p.get("C").asText()));
                return proof;
            }).collect(Collectors.toSet()));
            token.setMintProofs(Set.of(mintProof));
            return token;
        }
        catch (JsonProcessingException e) {
            log.error("Error parsing token content: {}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }
}

