/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.nostr.cashu.relay;

import java.time.Duration;
import java.util.Objects;
import java.util.Random;

public final class RelayBackoff {
    private static final double DEFAULT_JITTER_RATIO = 0.2;
    private final Duration initialDelay;
    private final Duration maxDelay;
    private final double multiplier;
    private final double jitterRatio;

    private RelayBackoff(Builder builder) {
        this.initialDelay = Objects.requireNonNull(builder.initialDelay, "initialDelay");
        this.maxDelay = Objects.requireNonNull(builder.maxDelay, "maxDelay");
        if (builder.multiplier < 1.0) {
            throw new IllegalArgumentException("multiplier must be >= 1");
        }
        if (builder.jitterRatio < 0.0 || builder.jitterRatio > 1.0) {
            throw new IllegalArgumentException("jitterRatio must be between 0 and 1");
        }
        this.multiplier = builder.multiplier;
        this.jitterRatio = builder.jitterRatio;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static RelayBackoff defaults() {
        return RelayBackoff.builder().initialDelay(Duration.ofSeconds(1L)).multiplier(2.0).maxDelay(Duration.ofSeconds(30L)).jitterRatio(0.2).build();
    }

    public Duration getInitialDelay() {
        return this.initialDelay;
    }

    public Duration getMaxDelay() {
        return this.maxDelay;
    }

    public double getMultiplier() {
        return this.multiplier;
    }

    public double getJitterRatio() {
        return this.jitterRatio;
    }

    public long delayMillis(int attempt, Random random) {
        if (attempt < 1) {
            throw new IllegalArgumentException("attempt must be >= 1");
        }
        Objects.requireNonNull(random, "random");
        double base = (double)this.initialDelay.toMillis() * Math.pow(this.multiplier, Math.max(0, attempt - 1));
        double capped = Math.min(base, (double)this.maxDelay.toMillis());
        if (capped <= 0.0) {
            return 0L;
        }
        double jitter = capped * this.jitterRatio;
        double min = Math.max(0.0, capped - jitter);
        double max = capped + jitter;
        double sampled = min + (max - min) * random.nextDouble();
        return Math.max(0L, Math.round(sampled));
    }

    public Builder toBuilder() {
        return RelayBackoff.builder().initialDelay(this.initialDelay).maxDelay(this.maxDelay).multiplier(this.multiplier).jitterRatio(this.jitterRatio);
    }

    public static final class Builder {
        private Duration initialDelay;
        private Duration maxDelay;
        private double multiplier = 2.0;
        private double jitterRatio = 0.2;

        private Builder() {
        }

        public Builder initialDelay(Duration initialDelay) {
            this.initialDelay = initialDelay;
            return this;
        }

        public Builder maxDelay(Duration maxDelay) {
            this.maxDelay = maxDelay;
            return this;
        }

        public Builder multiplier(double multiplier) {
            this.multiplier = multiplier;
            return this;
        }

        public Builder jitterRatio(double jitterRatio) {
            this.jitterRatio = jitterRatio;
            return this;
        }

        public RelayBackoff build() {
            if (this.initialDelay == null) {
                this.initialDelay = Duration.ofSeconds(1L);
            }
            if (this.maxDelay == null) {
                this.maxDelay = Duration.ofSeconds(30L);
            }
            return new RelayBackoff(this);
        }
    }
}

