/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.nostr.cashu.relay;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import xyz.tcheeric.nostr.cashu.config.RelayOptions;
import xyz.tcheeric.nostr.cashu.relay.RelayHealthState;
import xyz.tcheeric.nostr.cashu.relay.RelayMetrics;

public final class RelayHealthTracker {
    private final RelayOptions options;
    private final RelayMetrics metrics;
    private final Clock clock;
    private Instant lastSuccess;

    public RelayHealthTracker(RelayOptions options, RelayMetrics metrics, Clock clock) {
        this.options = Objects.requireNonNull(options, "options");
        this.metrics = Objects.requireNonNull(metrics, "metrics");
        this.clock = Objects.requireNonNullElse(clock, Clock.systemUTC());
    }

    public RelayHealthTracker(RelayOptions options, RelayMetrics metrics) {
        this(options, metrics, Clock.systemUTC());
    }

    public synchronized void recordHandshake(Duration latency, boolean success) {
        Objects.requireNonNull(latency, "latency");
        this.metrics.recordHandshake(latency, success);
        if (success) {
            this.lastSuccess = this.clock.instant();
            this.applySuccessLatency(latency);
        } else {
            this.applyFailureState();
        }
    }

    public synchronized void recordAck(Duration latency, boolean success) {
        Objects.requireNonNull(latency, "latency");
        this.metrics.recordAck(latency, success);
        if (success) {
            this.lastSuccess = this.clock.instant();
            this.metrics.updateState(RelayHealthState.HEALTHY);
        } else {
            this.applyFailureState();
        }
    }

    public synchronized RelayHealthState currentState() {
        return this.metrics.getState();
    }

    private void applySuccessLatency(Duration latency) {
        Duration handshakeTarget = this.options.getHandshakeTimeout();
        Duration degradedThreshold = this.options.getDegradedGracePeriod();
        if (latency.compareTo(handshakeTarget) <= 0) {
            this.metrics.updateState(RelayHealthState.HEALTHY);
        } else if (latency.compareTo(degradedThreshold) <= 0) {
            this.metrics.updateState(RelayHealthState.DEGRADED);
        } else {
            this.metrics.updateState(RelayHealthState.UNAVAILABLE);
        }
    }

    private void applyFailureState() {
        Duration unavailableGrace;
        Duration degradedThreshold;
        Instant now = this.clock.instant();
        Duration sinceSuccess = this.lastSuccess == null ? Duration.ofDays(365L) : Duration.between(this.lastSuccess, now);
        if (sinceSuccess.compareTo((degradedThreshold = this.options.getDegradedGracePeriod()).plus(unavailableGrace = this.options.getUnavailableGracePeriod())) >= 0) {
            this.metrics.updateState(RelayHealthState.UNAVAILABLE);
        } else if (sinceSuccess.compareTo(degradedThreshold) >= 0) {
            this.metrics.updateState(RelayHealthState.DEGRADED);
        }
    }
}

