/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.nostr.cashu.relay;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import xyz.tcheeric.nostr.cashu.relay.RelayHealthState;
import xyz.tcheeric.nostr.cashu.relay.RelayMetricsSnapshot;

public final class RelayMetrics {
    private final AtomicLong handshakeAttempts = new AtomicLong();
    private final AtomicLong handshakeFailures = new AtomicLong();
    private final AtomicLong ackSuccesses = new AtomicLong();
    private final AtomicLong ackFailures = new AtomicLong();
    private final AtomicReference<Duration> lastHandshakeLatency = new AtomicReference<Duration>(Duration.ZERO);
    private final AtomicReference<Duration> lastAckLatency = new AtomicReference<Duration>(Duration.ZERO);
    private final AtomicReference<Instant> lastSuccess = new AtomicReference();
    private final AtomicReference<Instant> lastFailure = new AtomicReference();
    private final AtomicReference<RelayHealthState> state = new AtomicReference<RelayHealthState>(RelayHealthState.UNAVAILABLE);
    private final Clock clock;

    public RelayMetrics() {
        this(Clock.systemUTC());
    }

    public RelayMetrics(Clock clock) {
        this.clock = Objects.requireNonNull(clock, "clock");
    }

    public void recordHandshake(Duration latency, boolean success) {
        Objects.requireNonNull(latency, "latency");
        this.handshakeAttempts.incrementAndGet();
        this.lastHandshakeLatency.set(latency);
        Instant now = this.clock.instant();
        if (success) {
            this.lastSuccess.set(now);
        } else {
            this.handshakeFailures.incrementAndGet();
            this.lastFailure.set(now);
        }
    }

    public void recordAck(Duration latency, boolean success) {
        Objects.requireNonNull(latency, "latency");
        this.lastAckLatency.set(latency);
        Instant now = this.clock.instant();
        if (success) {
            this.ackSuccesses.incrementAndGet();
            this.lastSuccess.set(now);
        } else {
            this.ackFailures.incrementAndGet();
            this.lastFailure.set(now);
        }
    }

    public void updateState(RelayHealthState newState) {
        Objects.requireNonNull(newState, "newState");
        this.state.set(newState);
    }

    public RelayHealthState getState() {
        return this.state.get();
    }

    public RelayMetricsSnapshot snapshot() {
        return new RelayMetricsSnapshot(this.handshakeAttempts.get(), this.handshakeFailures.get(), this.handshakeAttempts.get() - this.handshakeFailures.get(), this.ackSuccesses.get(), this.ackFailures.get(), this.lastHandshakeLatency.get(), this.lastAckLatency.get(), this.lastSuccess.get(), this.lastFailure.get(), this.state.get());
    }
}

