/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.nostr.cashu.services.impl;

import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import nostr.event.entities.CashuWallet;
import nostr.id.Identity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.cashu.common.Secret;
import xyz.tcheeric.nostr.cashu.config.NostrCashuOptions;
import xyz.tcheeric.nostr.cashu.services.SplitService;
import xyz.tcheeric.nostr.cashu.services.impl.DefaultSplitService;
import xyz.tcheeric.nostr.cashu.services.impl.NostrEventService;
import xyz.tcheeric.nostr.cashu.services.stream.NostrStreamingClient;
import xyz.tcheeric.nostr.cashu.util.MintUtil;
import xyz.tcheeric.nostr.cashu.util.TokenUtil;
import xyz.tcheeric.nostr.cashu.util.WalletUtil;

public abstract class NostrCashuService<T extends Secret> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NostrCashuService.class);
    private final CashuWallet wallet;
    private final String mintUrl;
    private final Identity identity;
    private final SplitService splitService;
    private final NostrCashuOptions options;
    private WalletUtil<T> walletUtil;
    private TokenUtil<T> tokenUtil;
    private MintUtil mintUtil;
    private NostrEventService<T> nostrEventService;

    public NostrCashuService(@NonNull CashuWallet wallet, @NonNull Identity identity) {
        this(wallet, identity, null, null, null);
        if (wallet == null) {
            throw new NullPointerException("wallet is marked non-null but is null");
        }
        if (identity == null) {
            throw new NullPointerException("identity is marked non-null but is null");
        }
    }

    public NostrCashuService(@NonNull CashuWallet wallet, @NonNull Identity identity, NostrCashuOptions options) {
        this(wallet, identity, null, null, options);
        if (wallet == null) {
            throw new NullPointerException("wallet is marked non-null but is null");
        }
        if (identity == null) {
            throw new NullPointerException("identity is marked non-null but is null");
        }
    }

    public NostrCashuService(@NonNull CashuWallet wallet, @NonNull String mintUrl, @NonNull String unit, @NonNull Identity identity) {
        this(wallet, identity, new MintUtil(unit, mintUrl), null, null);
        if (wallet == null) {
            throw new NullPointerException("wallet is marked non-null but is null");
        }
        if (mintUrl == null) {
            throw new NullPointerException("mintUrl is marked non-null but is null");
        }
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        if (identity == null) {
            throw new NullPointerException("identity is marked non-null but is null");
        }
    }

    public NostrCashuService(@NonNull CashuWallet wallet, @NonNull String mintUrl, @NonNull String unit, @NonNull Identity identity, NostrCashuOptions options) {
        this(wallet, identity, new MintUtil(unit, mintUrl), null, options);
        if (wallet == null) {
            throw new NullPointerException("wallet is marked non-null but is null");
        }
        if (mintUrl == null) {
            throw new NullPointerException("mintUrl is marked non-null but is null");
        }
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        if (identity == null) {
            throw new NullPointerException("identity is marked non-null but is null");
        }
    }

    protected NostrCashuService(@NonNull CashuWallet wallet, @NonNull MintUtil mintUtil, @NonNull Identity identity) {
        this(wallet, identity, mintUtil, null, null);
        if (wallet == null) {
            throw new NullPointerException("wallet is marked non-null but is null");
        }
        if (mintUtil == null) {
            throw new NullPointerException("mintUtil is marked non-null but is null");
        }
        if (identity == null) {
            throw new NullPointerException("identity is marked non-null but is null");
        }
    }

    protected NostrCashuService(@NonNull CashuWallet wallet, @NonNull MintUtil mintUtil, @NonNull Identity identity, NostrCashuOptions options) {
        this(wallet, identity, mintUtil, null, options);
        if (wallet == null) {
            throw new NullPointerException("wallet is marked non-null but is null");
        }
        if (mintUtil == null) {
            throw new NullPointerException("mintUtil is marked non-null but is null");
        }
        if (identity == null) {
            throw new NullPointerException("identity is marked non-null but is null");
        }
    }

    protected NostrCashuService(@NonNull CashuWallet wallet, @NonNull Identity identity, MintUtil mintUtil, SplitService splitService, NostrCashuOptions options) {
        this(wallet, identity, mintUtil, splitService, options, null);
        if (wallet == null) {
            throw new NullPointerException("wallet is marked non-null but is null");
        }
        if (identity == null) {
            throw new NullPointerException("identity is marked non-null but is null");
        }
    }

    protected NostrCashuService(@NonNull CashuWallet wallet, @NonNull Identity identity, MintUtil mintUtil, SplitService splitService, NostrCashuOptions options, NostrStreamingClient streamingClient) {
        if (wallet == null) {
            throw new NullPointerException("wallet is marked non-null but is null");
        }
        if (identity == null) {
            throw new NullPointerException("identity is marked non-null but is null");
        }
        log.debug("NostrCashuService called");
        this.wallet = Objects.requireNonNull(wallet, "wallet");
        this.identity = Objects.requireNonNull(identity, "identity");
        this.mintUtil = mintUtil;
        this.mintUrl = mintUtil != null ? mintUtil.getMintUrl() : null;
        this.splitService = splitService != null ? splitService : new DefaultSplitService();
        this.options = options != null ? options : NostrCashuOptions.defaults();
        this.walletUtil = new WalletUtil(wallet, mintUtil, identity, this.splitService, this.options);
        this.tokenUtil = new TokenUtil<T>(wallet, mintUtil, identity, this.splitService, this.walletUtil);
        this.nostrEventService = streamingClient != null ? new NostrEventService(wallet, identity, null, this.options, streamingClient) : new NostrEventService(wallet, identity, this.options);
    }

    @Generated
    public CashuWallet getWallet() {
        return this.wallet;
    }

    @Generated
    public String getMintUrl() {
        return this.mintUrl;
    }

    @Generated
    public Identity getIdentity() {
        return this.identity;
    }

    @Generated
    public SplitService getSplitService() {
        return this.splitService;
    }

    @Generated
    public NostrCashuOptions getOptions() {
        return this.options;
    }

    @Generated
    public WalletUtil<T> getWalletUtil() {
        return this.walletUtil;
    }

    @Generated
    public TokenUtil<T> getTokenUtil() {
        return this.tokenUtil;
    }

    @Generated
    public MintUtil getMintUtil() {
        return this.mintUtil;
    }

    @Generated
    public NostrEventService<T> getNostrEventService() {
        return this.nostrEventService;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NostrCashuService)) {
            return false;
        }
        NostrCashuService other = (NostrCashuService)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CashuWallet this$wallet = this.getWallet();
        CashuWallet other$wallet = other.getWallet();
        if (this$wallet == null ? other$wallet != null : !this$wallet.equals(other$wallet)) {
            return false;
        }
        String this$mintUrl = this.getMintUrl();
        String other$mintUrl = other.getMintUrl();
        if (this$mintUrl == null ? other$mintUrl != null : !this$mintUrl.equals(other$mintUrl)) {
            return false;
        }
        Identity this$identity = this.getIdentity();
        Identity other$identity = other.getIdentity();
        if (this$identity == null ? other$identity != null : !this$identity.equals(other$identity)) {
            return false;
        }
        SplitService this$splitService = this.getSplitService();
        SplitService other$splitService = other.getSplitService();
        if (this$splitService == null ? other$splitService != null : !this$splitService.equals(other$splitService)) {
            return false;
        }
        NostrCashuOptions this$options = this.getOptions();
        NostrCashuOptions other$options = other.getOptions();
        if (this$options == null ? other$options != null : !this$options.equals(other$options)) {
            return false;
        }
        WalletUtil<T> this$walletUtil = this.getWalletUtil();
        WalletUtil<T> other$walletUtil = other.getWalletUtil();
        if (this$walletUtil == null ? other$walletUtil != null : !((Object)this$walletUtil).equals(other$walletUtil)) {
            return false;
        }
        TokenUtil<T> this$tokenUtil = this.getTokenUtil();
        TokenUtil<T> other$tokenUtil = other.getTokenUtil();
        if (this$tokenUtil == null ? other$tokenUtil != null : !this$tokenUtil.equals(other$tokenUtil)) {
            return false;
        }
        MintUtil this$mintUtil = this.getMintUtil();
        MintUtil other$mintUtil = other.getMintUtil();
        if (this$mintUtil == null ? other$mintUtil != null : !this$mintUtil.equals(other$mintUtil)) {
            return false;
        }
        NostrEventService<T> this$nostrEventService = this.getNostrEventService();
        NostrEventService<T> other$nostrEventService = other.getNostrEventService();
        return !(this$nostrEventService == null ? other$nostrEventService != null : !this$nostrEventService.equals(other$nostrEventService));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof NostrCashuService;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CashuWallet $wallet = this.getWallet();
        result = result * 59 + ($wallet == null ? 43 : $wallet.hashCode());
        String $mintUrl = this.getMintUrl();
        result = result * 59 + ($mintUrl == null ? 43 : $mintUrl.hashCode());
        Identity $identity = this.getIdentity();
        result = result * 59 + ($identity == null ? 43 : $identity.hashCode());
        SplitService $splitService = this.getSplitService();
        result = result * 59 + ($splitService == null ? 43 : $splitService.hashCode());
        NostrCashuOptions $options = this.getOptions();
        result = result * 59 + ($options == null ? 43 : $options.hashCode());
        WalletUtil<T> $walletUtil = this.getWalletUtil();
        result = result * 59 + ($walletUtil == null ? 43 : ((Object)$walletUtil).hashCode());
        TokenUtil<T> $tokenUtil = this.getTokenUtil();
        result = result * 59 + ($tokenUtil == null ? 43 : $tokenUtil.hashCode());
        MintUtil $mintUtil = this.getMintUtil();
        result = result * 59 + ($mintUtil == null ? 43 : $mintUtil.hashCode());
        NostrEventService<T> $nostrEventService = this.getNostrEventService();
        result = result * 59 + ($nostrEventService == null ? 43 : $nostrEventService.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "NostrCashuService(wallet=" + String.valueOf(this.getWallet()) + ", mintUrl=" + this.getMintUrl() + ", identity=" + String.valueOf(this.getIdentity()) + ", splitService=" + String.valueOf(this.getSplitService()) + ", options=" + String.valueOf(this.getOptions()) + ", walletUtil=" + String.valueOf(this.getWalletUtil()) + ", tokenUtil=" + String.valueOf(this.getTokenUtil()) + ", mintUtil=" + String.valueOf(this.getMintUtil()) + ", nostrEventService=" + String.valueOf(this.getNostrEventService()) + ")";
    }

    @Generated
    public void setMintUtil(MintUtil mintUtil) {
        this.mintUtil = mintUtil;
    }
}

