/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.nostr.cashu.services.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import nostr.api.NIP01;
import nostr.api.NIP09;
import nostr.api.NIP44;
import nostr.api.NIP60;
import nostr.api.NIP61;
import nostr.api.NIP65;
import nostr.base.ElementAttribute;
import nostr.base.Kind;
import nostr.base.Marker;
import nostr.base.PublicKey;
import nostr.base.Relay;
import nostr.event.BaseMessage;
import nostr.event.Deleteable;
import nostr.event.entities.Amount;
import nostr.event.entities.CashuMint;
import nostr.event.entities.CashuToken;
import nostr.event.entities.CashuWallet;
import nostr.event.entities.NutZap;
import nostr.event.entities.NutZapInformation;
import nostr.event.entities.SpendingHistory;
import nostr.event.filter.AuthorFilter;
import nostr.event.filter.Filters;
import nostr.event.filter.KindFilter;
import nostr.event.impl.GenericEvent;
import nostr.event.json.codec.BaseMessageDecoder;
import nostr.event.message.EventMessage;
import nostr.event.message.OkMessage;
import nostr.event.tag.AddressTag;
import nostr.event.tag.EventTag;
import nostr.event.tag.GenericTag;
import nostr.event.tag.IdentifierTag;
import nostr.event.tag.ReferenceTag;
import nostr.id.Identity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.cashu.common.Proof;
import xyz.tcheeric.cashu.common.Secret;
import xyz.tcheeric.cashu.common.TokenV3;
import xyz.tcheeric.nostr.cashu.config.NostrCashuOptions;
import xyz.tcheeric.nostr.cashu.config.RelayOptions;
import xyz.tcheeric.nostr.cashu.parser.SpendingHistoryParser;
import xyz.tcheeric.nostr.cashu.parser.TokenParser;
import xyz.tcheeric.nostr.cashu.relay.RelayHealthTracker;
import xyz.tcheeric.nostr.cashu.services.stream.NostrStreamingClient;
import xyz.tcheeric.nostr.cashu.services.stream.NostrSubscription;
import xyz.tcheeric.nostr.cashu.services.stream.SpringNostrStreamingClient;
import xyz.tcheeric.nostr.cashu.util.AsyncExecutor;
import xyz.tcheeric.nostr.cashu.util.RetryPolicy;
import xyz.tcheeric.nostr.cashu.util.TokenUtil;

public class NostrEventService<T extends Secret>
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NostrEventService.class);
    private final CashuWallet wallet;
    private final Identity identity;
    private final TokenParser<T> tokenParser;
    private final SpendingHistoryParser spendingHistoryParser;
    private final AsyncExecutor executor;
    private final RetryPolicy networkRetryPolicy;
    private final NIP60 nip60;
    private final NIP61 nip61;
    private final NIP01 nip01;
    private final NIP09 nip09;
    private final NIP65 nip65;
    private final NostrCashuOptions options;
    private final Map<String, RelayHealthTracker> relayHealthTrackers;
    private final Map<String, RelayHealthTracker> relayHealthTrackersByUri;
    private final NostrStreamingClient streamingClient;
    private final boolean ownsStreamingClient;

    public NostrEventService(@NonNull Identity identity) {
        this(null, identity, null, NostrCashuOptions.defaults());
        if (identity == null) {
            throw new NullPointerException("identity is marked non-null but is null");
        }
    }

    public NostrEventService(CashuWallet wallet, @NonNull Identity identity) {
        this(wallet, identity, null, NostrCashuOptions.defaults());
        if (identity == null) {
            throw new NullPointerException("identity is marked non-null but is null");
        }
    }

    public NostrEventService(CashuWallet wallet, @NonNull Identity identity, @NonNull AsyncExecutor executor) {
        this(wallet, identity, executor, NostrCashuOptions.defaults());
        if (identity == null) {
            throw new NullPointerException("identity is marked non-null but is null");
        }
        if (executor == null) {
            throw new NullPointerException("executor is marked non-null but is null");
        }
    }

    public NostrEventService(CashuWallet wallet, @NonNull Identity identity, NostrCashuOptions options) {
        this(wallet, identity, null, options);
        if (identity == null) {
            throw new NullPointerException("identity is marked non-null but is null");
        }
    }

    public NostrEventService(CashuWallet wallet, @NonNull Identity identity, AsyncExecutor executor, @NonNull NostrCashuOptions options) {
        this(wallet, identity, executor, options, null);
        if (identity == null) {
            throw new NullPointerException("identity is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
    }

    public NostrEventService(CashuWallet wallet, @NonNull Identity identity, AsyncExecutor executor, @NonNull NostrCashuOptions options, NostrStreamingClient streamingClient) {
        if (identity == null) {
            throw new NullPointerException("identity is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        log.debug("NostrEventService called");
        this.wallet = wallet;
        this.identity = identity;
        this.options = options != null ? options : NostrCashuOptions.defaults();
        this.executor = executor != null ? executor : this.options.getExecutor();
        this.networkRetryPolicy = this.options.getExecutorOptions().getRetryPolicy();
        this.tokenParser = new TokenParser();
        this.spendingHistoryParser = new SpendingHistoryParser();
        this.nip60 = new NIP60(identity);
        this.nip61 = new NIP61(identity);
        this.nip01 = new NIP01(identity);
        this.nip09 = new NIP09(identity);
        this.nip65 = new NIP65(identity);
        this.relayHealthTrackers = new LinkedHashMap<String, RelayHealthTracker>();
        this.relayHealthTrackersByUri = new LinkedHashMap<String, RelayHealthTracker>();
        this.streamingClient = streamingClient != null ? streamingClient : this.createStreamingClient(identity, this.options);
        this.ownsStreamingClient = streamingClient == null;
        this.streamingClient.updateRelays(this.options.relayUris());
        this.options.getRelayOptions().forEach((alias, relayOptions) -> {
            RelayHealthTracker tracker = new RelayHealthTracker((RelayOptions)relayOptions, relayOptions.getMetrics());
            this.relayHealthTrackers.put((String)alias, tracker);
            this.relayHealthTrackersByUri.put(relayOptions.getUri(), tracker);
        });
    }

    protected NostrStreamingClient createStreamingClient(@NonNull Identity identity, @NonNull NostrCashuOptions options) {
        if (identity == null) {
            throw new NullPointerException("identity is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        Map<String, String> relays = options != null ? options.relayUris() : Collections.emptyMap();
        return this.createStreamingClient(identity, relays);
    }

    protected NostrStreamingClient createStreamingClient(@NonNull Identity identity, Map<String, String> relays) {
        if (identity == null) {
            throw new NullPointerException("identity is marked non-null but is null");
        }
        if (relays == null || relays.isEmpty()) {
            return new SpringNostrStreamingClient(identity);
        }
        return new SpringNostrStreamingClient(identity, relays);
    }

    public GenericEvent publishTokenEvent(@NonNull CashuToken token, @NonNull Map<String, String> relays) {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        if (relays == null) {
            throw new NullPointerException("relays is marked non-null but is null");
        }
        log.debug("publishTokenEvent called");
        this.executor.execute(() -> this.executeWithRelayMetrics(relays, () -> {
            this.nip60.createTokenEvent(token, this.wallet).signAndSend(relays);
            return null;
        }), this.networkRetryPolicy).join();
        return this.nip60.getEvent();
    }

    public List<GenericEvent> fetchTokenEvents(@NonNull List<PublicKey> authors, @NonNull Map<String, String> relays) {
        if (authors == null) {
            throw new NullPointerException("authors is marked non-null but is null");
        }
        if (relays == null) {
            throw new NullPointerException("relays is marked non-null but is null");
        }
        log.debug("fetchTokenEvents called");
        return this.fetchEventsInternal(List.of(Kind.WALLET_UNSPENT_PROOF), authors, relays);
    }

    public TokenV3<T> parseToken(@NonNull GenericEvent event, @NonNull String unit) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        log.debug("parseToken called");
        String content = this.decrypt(event.getContent(), this.identity.getPublicKey());
        return this.tokenParser.parse(content, unit);
    }

    public SpendingHistory parseSpendingHistory(@NonNull GenericEvent event, @NonNull String unit) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        log.debug("parseSpendingHistory called");
        String content = this.decrypt(event.getContent(), this.identity.getPublicKey());
        return this.spendingHistoryParser.parse(content, unit);
    }

    public void publishWalletEvent(@NonNull Map<String, String> relays) {
        if (relays == null) {
            throw new NullPointerException("relays is marked non-null but is null");
        }
        if (this.wallet == null) {
            throw new IllegalStateException("wallet is null");
        }
        this.executor.execute(() -> this.executeWithRelayMetrics(relays, () -> {
            this.nip60.createWalletEvent(this.wallet).signAndSend(relays);
            return null;
        }), this.networkRetryPolicy).join();
    }

    public void publishSpendingHistoryEvent(@NonNull GenericEvent event, @NonNull String unit, SpendingHistory.Direction direction, @NonNull Map<String, String> relays) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        if (relays == null) {
            throw new NullPointerException("relays is marked non-null but is null");
        }
        TokenV3<T> token = this.parseToken(event, unit);
        int amount = token.getMintProofs().stream().map(mp -> mp.getProofs().stream().mapToInt(Proof::getAmount).sum()).reduce(0, Integer::sum);
        String relayUrl = relays.values().stream().findFirst().orElseGet(() -> {
            Set relaySet = this.wallet.getRelays(token.getUnit());
            if (relaySet == null || relaySet.isEmpty()) {
                throw new IllegalStateException("No relays available for unit: " + token.getUnit());
            }
            return ((Relay)relaySet.iterator().next()).getUri();
        });
        SpendingHistory spendingHistory = SpendingHistory.builder().amount(new Amount(Integer.valueOf(amount), token.getUnit())).direction(direction).eventTags(List.of(new EventTag(event.getId(), relayUrl, direction.equals((Object)SpendingHistory.Direction.RECEIVED) ? Marker.CREATED : Marker.DESTROYED))).build();
        Instant start = Instant.now();
        BaseMessage message = this.executor.execute(() -> this.executeWithRelayMetrics(relays, () -> this.nip60.createSpendingHistoryEvent(spendingHistory, this.wallet).signAndSend(relays)), this.networkRetryPolicy).join();
        Duration ackLatency = Duration.between(start, Instant.now());
        boolean ackSuccess = message instanceof OkMessage && ((OkMessage)message).getFlag() != false;
        this.recordAck(relays, ackLatency, ackSuccess);
        if (!(message instanceof OkMessage) || !((OkMessage)message).getFlag().booleanValue()) {
            throw new IllegalStateException("Spending history event failed: " + (message instanceof OkMessage ? ((OkMessage)message).getMessage() : ""));
        }
    }

    public void publishSpendingHistoryEvent(@NonNull GenericEvent event, @NonNull String unit, SpendingHistory.Direction direction) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        this.publishSpendingHistoryEvent(event, unit, direction, this.getRelays());
    }

    public List<GenericEvent> fetchSpendingHistoryEvents(@NonNull List<PublicKey> authors) {
        if (authors == null) {
            throw new NullPointerException("authors is marked non-null but is null");
        }
        return this.fetchEventsInternal(List.of(Kind.WALLET_TX_HISTORY), authors, this.getRelays());
    }

    public List<GenericEvent> fetchNutZapInformationalEvents(@NonNull PublicKey publicKey) {
        if (publicKey == null) {
            throw new NullPointerException("publicKey is marked non-null but is null");
        }
        return this.fetchEventsInternal(List.of(Kind.NUTZAP_INFORMATIONAL), List.of(publicKey), this.getRelays());
    }

    private List<GenericEvent> fetchEventsInternal(@NonNull List<Kind> kinds, @NonNull List<PublicKey> authors, @NonNull Map<String, String> relays) {
        if (kinds == null) {
            throw new NullPointerException("kinds is marked non-null but is null");
        }
        if (authors == null) {
            throw new NullPointerException("authors is marked non-null but is null");
        }
        if (relays == null) {
            throw new NullPointerException("relays is marked non-null but is null");
        }
        log.debug("fetchEventsInternal called");
        ArrayList filterables = new ArrayList();
        authors.forEach(author -> filterables.add(new AuthorFilter(author)));
        kinds.forEach(kind -> filterables.add(new KindFilter(kind)));
        Filters filters = new Filters(filterables);
        List<String> messages = this.getMessages(filters, relays);
        return messages.stream().map(message -> new BaseMessageDecoder().decode(message)).filter(msg -> msg instanceof EventMessage).map(msg -> (EventMessage)msg).map(EventMessage::getEvent).map(event -> (GenericEvent)event).filter(event -> authors.contains(event.getPubKey())).filter(event -> kinds.contains(Kind.valueOf((int)event.getKind()))).collect(Collectors.toList());
    }

    public void publishNutZapEvent(@NonNull NutZap nutZap, @NonNull String content) {
        if (nutZap == null) {
            throw new NullPointerException("nutZap is marked non-null but is null");
        }
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        List<GenericEvent> events = this.fetchNutZapInformationalEvents(nutZap.getRecipient());
        HashSet relays = new HashSet();
        events.forEach(e -> relays.addAll(this.extractNutZapInformation((GenericEvent)e).getRelays()));
        HashMap relayMap = new HashMap();
        relays.forEach(r -> relayMap.put(r.getHost(), r.getUri()));
        this.executor.execute(() -> this.executeWithRelayMetrics(relayMap, () -> {
            this.nip61.createNutzapEvent(nutZap, content).signAndSend(relayMap);
            return null;
        }), this.networkRetryPolicy).join();
    }

    public NutZapInformation extractNutZapInformation(@NonNull GenericEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        if (event.getKind().intValue() != Kind.NUTZAP_INFORMATIONAL.getValue()) {
            throw new IllegalStateException("Invalid event kind: " + event.getKind());
        }
        NutZapInformation info = new NutZapInformation();
        event.getTags().stream().filter(tag -> tag.getCode().equals("pubkey")).map(tag -> (GenericTag)tag).findFirst().ifPresent(tag -> info.setP2pkPubkey(((ElementAttribute)tag.getAttributes().get(0)).value().toString()));
        event.getTags().stream().filter(tag -> tag.getCode().equals("relay")).map(tag -> (GenericTag)tag).forEach(tag -> info.getRelays().add(new Relay(((ElementAttribute)tag.getAttributes().get(0)).value().toString())));
        event.getTags().stream().filter(tag -> tag.getCode().equals("mint")).map(tag -> (GenericTag)tag).forEach(tag -> info.getMints().add(new CashuMint(((ElementAttribute)tag.getAttributes().get(0)).value().toString(), List.of(((ElementAttribute)tag.getAttributes().get(1)).value().toString().split(",")))));
        return info;
    }

    public List<String> getMessages(@NonNull Filters filters, @NonNull Map<String, String> relays) {
        if (filters == null) {
            throw new NullPointerException("filters is marked non-null but is null");
        }
        if (relays == null) {
            throw new NullPointerException("relays is marked non-null but is null");
        }
        Map<String, String> relayMap = this.resolveRelays(relays);
        return this.executor.execute(() -> this.nip01.sendRequest(filters, UUID.randomUUID().toString(), relayMap), this.networkRetryPolicy).join();
    }

    public NostrSubscription subscribe(@NonNull Filters filters, @NonNull Consumer<GenericEvent> eventConsumer) {
        if (filters == null) {
            throw new NullPointerException("filters is marked non-null but is null");
        }
        if (eventConsumer == null) {
            throw new NullPointerException("eventConsumer is marked non-null but is null");
        }
        return this.subscribe(filters, null, eventConsumer, null);
    }

    public NostrSubscription subscribe(@NonNull Filters filters, @NonNull Consumer<GenericEvent> eventConsumer, Consumer<Throwable> errorHandler) {
        if (filters == null) {
            throw new NullPointerException("filters is marked non-null but is null");
        }
        if (eventConsumer == null) {
            throw new NullPointerException("eventConsumer is marked non-null but is null");
        }
        return this.subscribe(filters, null, eventConsumer, errorHandler);
    }

    public NostrSubscription subscribe(@NonNull Filters filters, Map<String, String> relays, @NonNull Consumer<GenericEvent> eventConsumer, Consumer<Throwable> errorHandler) {
        Objects.requireNonNull(filters, "filters");
        Objects.requireNonNull(eventConsumer, "eventConsumer");
        Map<String, String> resolvedRelays = this.resolveRelays(relays);
        Supplier<Map<String, String>> relaySupplier = () -> new LinkedHashMap(resolvedRelays);
        Consumer<Throwable> downstreamError = errorHandler != null ? errorHandler : throwable -> log.warn("streaming subscription error", throwable);
        boolean overrideRelays = relays != null && !relays.isEmpty();
        NostrStreamingClient subscriptionClient = overrideRelays ? this.createStreamingClient(this.identity, resolvedRelays) : this.streamingClient;
        NostrSubscription subscription = new NostrSubscription(filters, subscriptionClient, this.executor, this.networkRetryPolicy, eventConsumer, downstreamError, relaySupplier);
        log.debug("subscription started id={} filters={} configured_relays={}", new Object[]{subscription.getId(), filters, resolvedRelays.keySet()});
        return subscription;
    }

    private Map<String, String> resolveRelays(Map<String, String> relays) {
        if (relays == null || relays.isEmpty()) {
            return new LinkedHashMap<String, String>(this.getRelays());
        }
        return new LinkedHashMap<String, String>(relays);
    }

    private Map<String, String> resolveBootstrapRelays() {
        LinkedHashMap<String, String> configured = new LinkedHashMap<String, String>(this.options.relayUris());
        if (!configured.isEmpty()) {
            return configured;
        }
        throw new IllegalStateException("No relay bootstrap configuration available");
    }

    public Map<String, String> getRelays() {
        LinkedHashMap<String, String> configured = new LinkedHashMap<String, String>(this.options.relayUris());
        if (!configured.isEmpty()) {
            return configured;
        }
        Map<String, String> metadata = this.getRelayListMetadata();
        if (metadata != null && !metadata.isEmpty()) {
            return metadata;
        }
        throw new IllegalStateException("No relays found; configure relays via NostrCashuOptions or publish metadata");
    }

    public Map<String, RelayOptions> getRelayOptions() {
        return this.options.getRelayOptions();
    }

    @Deprecated
    public Map<String, RelayOptions> getRelayConfigs() {
        return this.getRelayOptions();
    }

    private Map<String, String> getRelayListMetadata() {
        List<GenericEvent> events = this.fetchRelayListMetadataEvents();
        if (!events.isEmpty()) {
            return events.stream().map(event -> event.getTags().stream().filter(tag -> tag.getCode().equals("r")).map(tag -> (ReferenceTag)tag).filter(tag -> Marker.WRITE.equals((Object)tag.getMarker())).map(tag -> new Relay(tag.getUri().toString())).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toMap(Relay::getHost, Relay::getUri, (existing, replacement) -> existing, LinkedHashMap::new));
        }
        return null;
    }

    private List<GenericEvent> fetchRelayListMetadataEvents() {
        Map<String, String> relays = this.resolveBootstrapRelays();
        return this.fetchEventsInternal(List.of(Kind.RELAY_LIST_METADATA), List.of(this.identity.getPublicKey()), relays);
    }

    public static <S extends Secret> Map<String, String> getRelays(@NonNull CashuWallet wallet, @NonNull Identity identity) {
        if (wallet == null) {
            throw new NullPointerException("wallet is marked non-null but is null");
        }
        if (identity == null) {
            throw new NullPointerException("identity is marked non-null but is null");
        }
        return new NostrEventService(wallet, identity).getRelays();
    }

    public static <S extends Secret> Map<String, String> getRelays(@NonNull CashuWallet wallet, @NonNull Identity identity, @NonNull NostrCashuOptions options) {
        if (wallet == null) {
            throw new NullPointerException("wallet is marked non-null but is null");
        }
        if (identity == null) {
            throw new NullPointerException("identity is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        return new NostrEventService(wallet, identity, options).getRelays();
    }

    public GenericEvent publishTokenEvent(@NonNull CashuToken token) {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        Map<String, String> relays = this.getRelays();
        this.executeWithRelayMetrics(relays, () -> {
            this.nip60.createTokenEvent(token, this.wallet).signAndSend(relays);
            return null;
        });
        return this.nip60.getEvent();
    }

    public List<GenericEvent> fetchWalletEvents(@NonNull List<PublicKey> authors) {
        if (authors == null) {
            throw new NullPointerException("authors is marked non-null but is null");
        }
        log.debug("fetchWalletEvents called");
        return this.fetchEventsInternal(List.of(Kind.WALLET), authors, this.getRelays());
    }

    public List<GenericEvent> fetchEvents(@NonNull List<Kind> kinds, @NonNull List<PublicKey> authors) {
        if (kinds == null) {
            throw new NullPointerException("kinds is marked non-null but is null");
        }
        if (authors == null) {
            throw new NullPointerException("authors is marked non-null but is null");
        }
        log.debug("fetchEvents called");
        return this.fetchEventsInternal(kinds, authors, this.getRelays());
    }

    public List<GenericEvent> fetchSpendingHistoryEvents(@NonNull List<PublicKey> authors, SpendingHistory.Direction direction) {
        if (authors == null) {
            throw new NullPointerException("authors is marked non-null but is null");
        }
        log.debug("fetchSpendingHistoryEvents called");
        return this.fetchEventsInternal(List.of(Kind.WALLET_TX_HISTORY), authors, this.getRelays()).stream().filter(event -> {
            try {
                String content = this.getContent((GenericEvent)event);
                JsonNode node = new ObjectMapper().readTree(content);
                if (node.isArray()) {
                    for (JsonNode element : node) {
                        if (!element.isArray() || element.size() <= 1 || !"direction".equalsIgnoreCase(element.get(0).asText())) continue;
                        String dirValue = element.get(1).asText();
                        if (!direction.getValue().equalsIgnoreCase(dirValue)) continue;
                        return true;
                    }
                    return false;
                }
                JsonNode dirNode = node.get("direction");
                return dirNode != null && direction.getValue().equalsIgnoreCase(dirNode.asText());
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
    }

    public List<GenericEvent> fetchDeletionEvents(@NonNull List<PublicKey> authors) {
        if (authors == null) {
            throw new NullPointerException("authors is marked non-null but is null");
        }
        log.debug("fetchDeletionEvents called");
        return this.fetchEventsInternal(List.of(Kind.DELETION), authors, this.getRelays());
    }

    public String getContent(@NonNull GenericEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        log.debug("getContent called");
        return this.decrypt(event.getContent(), this.identity.getPublicKey());
    }

    public TokenV3<T> getToken(@NonNull GenericEvent event, @NonNull String unit) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        log.debug("getToken called");
        return this.parseToken(event, unit);
    }

    public SpendingHistory getSpendingHistory(@NonNull GenericEvent event, @NonNull String unit) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        log.debug("getSpendingHistory called");
        return this.parseSpendingHistory(event, unit);
    }

    public String extractWalletId(@NonNull GenericEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        log.debug("extractWalletId called");
        Optional<AddressTag> addressTagOpt = event.getTags().stream().filter(tag -> tag instanceof AddressTag).map(tag -> (AddressTag)tag).findFirst();
        if (addressTagOpt.isPresent()) {
            AddressTag addressTag = addressTagOpt.get();
            Integer kind = addressTag.getKind();
            if (kind.intValue() != Kind.WALLET.getValue()) {
                throw new IllegalStateException("Invalid kind: " + kind);
            }
            String pubKey = addressTag.getPublicKey().toString();
            if (!pubKey.equals(this.identity.getPublicKey().toString())) {
                throw new IllegalStateException("Public key mismatch");
            }
            IdentifierTag idTag = addressTag.getIdentifierTag();
            return idTag.getUuid();
        }
        throw new IllegalStateException("Wallet ID not found");
    }

    public String extractUnit(@NonNull GenericEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        log.debug("extractUnit called");
        return event.getTags().stream().filter(tag -> tag.getCode().equals("unit")).map(tag -> (GenericTag)tag).findFirst().map(tag -> ((ElementAttribute)tag.getAttributes().get(0)).value().toString()).orElse(null);
    }

    public GenericEvent findTokenEvent(@NonNull CashuToken token, @NonNull String unit) {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        log.debug("findTokenEvent called");
        List<GenericEvent> events = this.fetchEventsInternal(List.of(Kind.WALLET_UNSPENT_PROOF), List.of(this.identity.getPublicKey()), this.getRelays());
        for (GenericEvent event : events) {
            TokenV3<T> tokenV3 = this.parseToken(event, unit);
            List<CashuToken> tokens = TokenUtil.toCashuTokens(tokenV3);
            for (CashuToken t : tokens) {
                if (!t.equals((Object)token)) continue;
                return event;
            }
        }
        return null;
    }

    public GenericEvent publishDeletionEvent(@NonNull CashuToken token, @NonNull String unit) {
        OkMessage ok;
        OkMessage okMessage;
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        log.debug("publishDeletionEvent called");
        GenericEvent event = this.findTokenEvent(token, unit);
        if (event == null) {
            throw new IllegalStateException("Event not found for token deletion");
        }
        Map<String, String> relays = this.getRelays();
        Instant start = Instant.now();
        BaseMessage deleted = this.executor.execute(() -> this.executeWithRelayMetrics(relays, () -> this.nip09.createDeletionEvent(new Deleteable[]{event}).signAndSend(relays)), this.networkRetryPolicy).join();
        Duration ackLatency = Duration.between(start, Instant.now());
        boolean ackSuccess = deleted instanceof OkMessage && (okMessage = (OkMessage)deleted).getFlag() != false;
        this.recordAck(relays, ackLatency, ackSuccess);
        if (!(deleted instanceof OkMessage) || !(ok = (OkMessage)deleted).getFlag().booleanValue()) {
            String string;
            if (deleted instanceof OkMessage) {
                OkMessage okMessage2 = (OkMessage)deleted;
                string = okMessage2.getMessage();
            } else {
                string = "";
            }
            throw new IllegalStateException("Deletion event failed: " + string);
        }
        return event;
    }

    private String decrypt(@NonNull String content, @NonNull PublicKey pubKey) {
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        if (pubKey == null) {
            throw new NullPointerException("pubKey is marked non-null but is null");
        }
        return NIP44.decrypt((Identity)this.identity, (String)content, (PublicKey)pubKey);
    }

    public GenericEvent createRelayListMetadataEvent(@NonNull Map<Relay, Marker> relays) {
        if (relays == null) {
            throw new NullPointerException("relays is marked non-null but is null");
        }
        this.nip65.createRelayListMetadataEvent(relays);
        return this.nip65.getEvent();
    }

    public void publishRelayListMetadataEvent(@NonNull Map<Relay, Marker> relays) {
        if (relays == null) {
            throw new NullPointerException("relays is marked non-null but is null");
        }
        Map<String, String> relayMap = this.getRelays();
        this.executor.execute(() -> this.executeWithRelayMetrics(relayMap, () -> {
            this.nip65.createRelayListMetadataEvent(relays).signAndSend(relayMap);
            return null;
        }), this.networkRetryPolicy).join();
    }

    public GenericEvent createRelayListMetadataEvent(@NonNull List<Relay> relays, @NonNull Marker marker) {
        if (relays == null) {
            throw new NullPointerException("relays is marked non-null but is null");
        }
        if (marker == null) {
            throw new NullPointerException("marker is marked non-null but is null");
        }
        this.nip65.createRelayListMetadataEvent(relays, marker);
        return this.nip65.getEvent();
    }

    public void publishRelayListMetadataEvent(@NonNull List<Relay> relays, @NonNull Marker marker) {
        if (relays == null) {
            throw new NullPointerException("relays is marked non-null but is null");
        }
        if (marker == null) {
            throw new NullPointerException("marker is marked non-null but is null");
        }
        Map<String, String> relayMap = this.getRelays();
        this.executor.execute(() -> this.executeWithRelayMetrics(relayMap, () -> {
            this.nip65.createRelayListMetadataEvent(relays, marker).signAndSend(relayMap);
            return null;
        }), this.networkRetryPolicy).join();
    }

    public GenericEvent createNutzapInformationalEvent(@NonNull NutZapInformation information) {
        if (information == null) {
            throw new NullPointerException("information is marked non-null but is null");
        }
        this.nip61.createNutzapInformationalEvent(information);
        return this.nip61.getEvent();
    }

    public void publishNutzapInformationalEvent(@NonNull NutZapInformation information) {
        if (information == null) {
            throw new NullPointerException("information is marked non-null but is null");
        }
        Map<String, String> relayMap = this.getRelays();
        this.executor.execute(() -> this.executeWithRelayMetrics(relayMap, () -> {
            this.nip61.createNutzapInformationalEvent(information).signAndSend(relayMap);
            return null;
        }), this.networkRetryPolicy).join();
    }

    public static Map<String, String> toRelayUriMap(Map<String, RelayOptions> relayOptions) {
        if (relayOptions == null || relayOptions.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap uris = new LinkedHashMap();
        relayOptions.forEach((alias, config) -> {
            if (config != null && config.getUri() != null && !config.getUri().isBlank()) {
                uris.put(alias, config.getUri());
            }
        });
        return Collections.unmodifiableMap(uris);
    }

    @Override
    public void close() {
        try {
            this.streamingClient.close();
        }
        catch (Exception ex) {
            log.warn("streaming_client close_failed", (Throwable)ex);
        }
    }

    private <T> T executeWithRelayMetrics(Map<String, String> relays, Supplier<T> supplier) {
        Instant start = Instant.now();
        try {
            T result = supplier.get();
            this.recordHandshake(relays, Duration.between(start, Instant.now()), true);
            return result;
        }
        catch (RuntimeException ex) {
            this.recordHandshake(relays, Duration.between(start, Instant.now()), false);
            throw ex;
        }
    }

    private void recordHandshake(Map<String, String> relays, Duration latency, boolean success) {
        if (relays == null || relays.isEmpty()) {
            return;
        }
        relays.forEach((alias, uri) -> {
            RelayHealthTracker tracker = this.trackerFor((String)alias, (String)uri);
            if (tracker != null) {
                tracker.recordHandshake(latency, success);
            }
        });
    }

    private void recordAck(Map<String, String> relays, Duration latency, boolean success) {
        if (relays == null || relays.isEmpty()) {
            return;
        }
        relays.forEach((alias, uri) -> {
            RelayHealthTracker tracker = this.trackerFor((String)alias, (String)uri);
            if (tracker != null) {
                tracker.recordAck(latency, success);
            }
        });
    }

    private RelayHealthTracker trackerFor(String alias, String uri) {
        RelayHealthTracker tracker = this.relayHealthTrackers.get(alias);
        if (tracker != null) {
            return tracker;
        }
        if (uri != null) {
            return this.relayHealthTrackersByUri.get(uri);
        }
        return null;
    }

    @Generated
    public CashuWallet getWallet() {
        return this.wallet;
    }

    @Generated
    public Identity getIdentity() {
        return this.identity;
    }

    @Generated
    public TokenParser<T> getTokenParser() {
        return this.tokenParser;
    }

    @Generated
    public SpendingHistoryParser getSpendingHistoryParser() {
        return this.spendingHistoryParser;
    }

    @Generated
    public AsyncExecutor getExecutor() {
        return this.executor;
    }

    @Generated
    public RetryPolicy getNetworkRetryPolicy() {
        return this.networkRetryPolicy;
    }

    @Generated
    public NIP60 getNip60() {
        return this.nip60;
    }

    @Generated
    public NIP61 getNip61() {
        return this.nip61;
    }

    @Generated
    public NIP01 getNip01() {
        return this.nip01;
    }

    @Generated
    public NIP09 getNip09() {
        return this.nip09;
    }

    @Generated
    public NIP65 getNip65() {
        return this.nip65;
    }

    @Generated
    public NostrCashuOptions getOptions() {
        return this.options;
    }

    @Generated
    public Map<String, RelayHealthTracker> getRelayHealthTrackers() {
        return this.relayHealthTrackers;
    }

    @Generated
    public Map<String, RelayHealthTracker> getRelayHealthTrackersByUri() {
        return this.relayHealthTrackersByUri;
    }

    @Generated
    public NostrStreamingClient getStreamingClient() {
        return this.streamingClient;
    }

    @Generated
    public boolean isOwnsStreamingClient() {
        return this.ownsStreamingClient;
    }
}

