/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.nostr.cashu.services.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import nostr.base.ElementAttribute;
import nostr.base.GenericTagQuery;
import nostr.base.Kind;
import nostr.base.PublicKey;
import nostr.event.entities.Amount;
import nostr.event.entities.CashuMint;
import nostr.event.entities.CashuProof;
import nostr.event.entities.CashuToken;
import nostr.event.entities.CashuWallet;
import nostr.event.entities.NutZap;
import nostr.event.entities.NutZapInformation;
import nostr.event.entities.SpendingHistory;
import nostr.event.filter.Filters;
import nostr.event.filter.GenericTagQueryFilter;
import nostr.event.filter.KindFilter;
import nostr.event.filter.ReferencedPublicKeyFilter;
import nostr.event.filter.SinceFilter;
import nostr.event.impl.GenericEvent;
import nostr.event.json.codec.BaseMessageDecoder;
import nostr.event.message.EventMessage;
import nostr.event.tag.EventTag;
import nostr.event.tag.GenericTag;
import nostr.event.tag.PubKeyTag;
import nostr.id.Identity;
import org.apache.commons.lang3.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.cashu.common.BlindedMessage;
import xyz.tcheeric.cashu.common.PaymentMethod;
import xyz.tcheeric.cashu.common.Proof;
import xyz.tcheeric.cashu.common.Secret;
import xyz.tcheeric.cashu.common.TokenV3;
import xyz.tcheeric.cashu.entities.rest.PostSwapRequest;
import xyz.tcheeric.nostr.cashu.config.NostrCashuOptions;
import xyz.tcheeric.nostr.cashu.operation.SwapOperation;
import xyz.tcheeric.nostr.cashu.services.impl.NostrCashuService;
import xyz.tcheeric.nostr.cashu.services.impl.NostrEventService;
import xyz.tcheeric.nostr.cashu.util.MintUtil;
import xyz.tcheeric.nostr.cashu.util.TokenUtil;
import xyz.tcheeric.nostr.cashu.util.WalletUtil;

public class NutZapService<T extends Secret>
extends NostrCashuService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NutZapService.class);
    private SwapOperation<T> swapOperation;
    private PaymentMethod paymentMethod;

    public NutZapService(@NonNull CashuWallet wallet, @NonNull Identity identity, @NonNull PaymentMethod paymentMethod) {
        this(wallet, identity, paymentMethod, null);
        if (wallet == null) {
            throw new NullPointerException("wallet is marked non-null but is null");
        }
        if (identity == null) {
            throw new NullPointerException("identity is marked non-null but is null");
        }
        if (paymentMethod == null) {
            throw new NullPointerException("paymentMethod is marked non-null but is null");
        }
    }

    public NutZapService(@NonNull CashuWallet wallet, @NonNull Identity identity, @NonNull PaymentMethod paymentMethod, NostrCashuOptions options) {
        super(wallet, identity, options);
        if (wallet == null) {
            throw new NullPointerException("wallet is marked non-null but is null");
        }
        if (identity == null) {
            throw new NullPointerException("identity is marked non-null but is null");
        }
        if (paymentMethod == null) {
            throw new NullPointerException("paymentMethod is marked non-null but is null");
        }
        this.paymentMethod = paymentMethod;
    }

    NutZapService(@NonNull CashuWallet wallet, @NonNull MintUtil mintUtil, @NonNull Identity identity) {
        super(wallet, mintUtil, identity);
        if (wallet == null) {
            throw new NullPointerException("wallet is marked non-null but is null");
        }
        if (mintUtil == null) {
            throw new NullPointerException("mintUtil is marked non-null but is null");
        }
        if (identity == null) {
            throw new NullPointerException("identity is marked non-null but is null");
        }
    }

    NutZapService(@NonNull CashuWallet wallet, @NonNull MintUtil mintUtil, @NonNull Identity identity, NostrCashuOptions options) {
        super(wallet, mintUtil, identity, options);
        if (wallet == null) {
            throw new NullPointerException("wallet is marked non-null but is null");
        }
        if (mintUtil == null) {
            throw new NullPointerException("mintUtil is marked non-null but is null");
        }
        if (identity == null) {
            throw new NullPointerException("identity is marked non-null but is null");
        }
    }

    public void send(@NonNull PublicKey recipient, @NonNull Amount amount) {
        if (recipient == null) {
            throw new NullPointerException("recipient is marked non-null but is null");
        }
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        log.debug("send called");
        this.send(recipient, amount, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(@NonNull PublicKey recipient, @NonNull Amount amount, String memo, EventTag eventTag) {
        if (recipient == null) {
            throw new NullPointerException("recipient is marked non-null but is null");
        }
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        log.debug("send called");
        if (amount.getAmount() <= 0) {
            throw new IllegalArgumentException("Amount must be greater than 0");
        }
        CashuWallet wallet = this.getWallet();
        if (amount.getAmount() > wallet.getBalance()) {
            throw new IllegalStateException("Insufficient balance");
        }
        NostrEventService nostrEventService = this.getNostrEventService();
        WalletUtil<T> walletUtil = this.getWalletUtil();
        List<GenericEvent> nutZapInformationEvents = nostrEventService.fetchNutZapInformationalEvents(recipient);
        NutZapInformation nutZapInformation = this.getNutZapInformation(nutZapInformationEvents);
        boolean success = false;
        try {
            List<CashuProof> proofs = walletUtil.extractProofsFromTokens(amount.getAmount(), this.swapOperation);
            PostSwapRequest<T> postSwapRequest = this.getPostSwapRequest(proofs);
            TokenV3<T> token = this.swapOperation.swap(postSwapRequest).getToken();
            CashuMint mint = this.getMints(amount, nutZapInformation).get(0);
            this.send(nutZapInformation, memo, eventTag, mint, token);
            success = true;
        }
        finally {
            if (success) {
                walletUtil.commitPendingTokens(this.swapOperation.getUnit());
            } else {
                walletUtil.restorePendingTokens(this.swapOperation.getUnit());
            }
        }
    }

    private void send(@NonNull NutZapInformation nutZapInformation, String memo, EventTag eventTag, @NonNull CashuMint mint, @NonNull TokenV3<T> token) {
        if (nutZapInformation == null) {
            throw new NullPointerException("nutZapInformation is marked non-null but is null");
        }
        if (mint == null) {
            throw new NullPointerException("mint is marked non-null but is null");
        }
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        PublicKey recipient = new PublicKey(nutZapInformation.getP2pkPubkey());
        NutZap nutZap = new NutZap();
        nutZap.setRecipient(recipient);
        nutZap.setProofs(NutZapService.getProofs(token));
        nutZap.setNutZappedEvent(eventTag);
        nutZap.setMint(mint);
        NostrEventService nostrEventService = this.getNostrEventService();
        String content = memo == null ? "" : memo;
        nostrEventService.publishNutZapEvent(nutZap, content);
    }

    private PostSwapRequest<T> getPostSwapRequest(@NonNull List<CashuProof> proofs) {
        if (proofs == null) {
            throw new NullPointerException("proofs is marked non-null but is null");
        }
        List cashuProofList = TokenUtil.toCashuProofList(proofs);
        List<BlindedMessage> blindMessages = WalletUtil.createBlindMessageEntities(cashuProofList);
        return new PostSwapRequest(cashuProofList, blindMessages);
    }

    private List<CashuMint> getMints(@NonNull Amount amount, @NonNull NutZapInformation nutZapInformation) {
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        if (nutZapInformation == null) {
            throw new NullPointerException("nutZapInformation is marked non-null but is null");
        }
        return nutZapInformation.getMints().stream().filter(mint -> mint.getUnits().contains(amount.getUnit())).toList();
    }

    public void receive() {
        log.debug("receive called");
        Identity self = this.getIdentity();
        Long since = this.since();
        List<String> mints = this.getMints();
        NostrEventService nostrEventService = this.getNostrEventService();
        WalletUtil walletUtil = this.getWalletUtil();
        SinceFilter sinceFilter = new SinceFilter(since);
        ReferencedPublicKeyFilter recipientFilter = new ReferencedPublicKeyFilter(new PubKeyTag(self.getPublicKey()));
        KindFilter kindFilter = new KindFilter(Kind.NUTZAP);
        ArrayList<Object> filterableList = new ArrayList<Object>();
        filterableList.add(sinceFilter);
        filterableList.add(recipientFilter);
        filterableList.add(kindFilter);
        mints.forEach(mint -> filterableList.add(new GenericTagQueryFilter(new GenericTagQuery("#u", mint))));
        Filters filters = new Filters(filterableList);
        List<GenericEvent> events = nostrEventService.getMessages(filters, nostrEventService.getRelays()).stream().map(msg -> new BaseMessageDecoder().decode(msg.toString())).filter(message -> message instanceof EventMessage).map(message -> (GenericEvent)((EventMessage)message).getEvent()).toList();
        if (events.isEmpty()) {
            log.info("No NutZap events found since {}", (Object)since);
            return;
        }
        List proofs = events.stream().map(event -> event.getTags()).flatMap(tags -> tags.stream()).filter(tag -> tag.getCode().equals("proof")).map(tag -> (GenericTag)tag).map(tag -> ((ElementAttribute)tag.getAttributes().get(0)).value().toString()).map(strJsonProof -> strJsonProof.replace("\\\\\"", "\\\\\\\"")).map(strJsonProof -> StringEscapeUtils.unescapeJson((String)strJsonProof)).map(strJsonProof -> strJsonProof.replace("\"[", "[").replace("]\"", "]").replace("\\", "")).map(strJsonProof -> {
            try {
                log.info(">>>> Proof: {}", strJsonProof);
                return (Proof)new ObjectMapper().readValue(strJsonProof, new TypeReference<Proof<T>>(this){});
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
        List<BlindedMessage> blindMessages = WalletUtil.createBlindMessageEntities(proofs);
        PostSwapRequest postSwapRequest = new PostSwapRequest(proofs, blindMessages);
        TokenV3<T> tokenV3 = this.swapOperation.swap(postSwapRequest).getToken();
        String tokenV3Unit = tokenV3.getUnit();
        walletUtil.addTokens(TokenUtil.toCashuTokens(tokenV3), tokenV3Unit);
        this.updateNutZapRedemptionHistory(tokenV3, events);
    }

    private void updateNutZapRedemptionHistory(@NonNull TokenV3<T> tokenV3, @NonNull List<GenericEvent> events) {
        if (tokenV3 == null) {
            throw new NullPointerException("tokenV3 is marked non-null but is null");
        }
        if (events == null) {
            throw new NullPointerException("events is marked non-null but is null");
        }
        NostrEventService nostrEventService = this.getNostrEventService();
        List<CashuToken> tokens = TokenUtil.toCashuTokens(tokenV3);
        String unit = tokenV3.getUnit();
        tokens.forEach(t -> {
            events.forEach(e -> t.addDestroyed(e.getId()));
            GenericEvent event = nostrEventService.publishTokenEvent((CashuToken)t);
            nostrEventService.publishSpendingHistoryEvent(event, unit, SpendingHistory.Direction.RECEIVED);
        });
    }

    private NutZapInformation getNutZapInformation(@NonNull List<GenericEvent> events) {
        if (events == null) {
            throw new NullPointerException("events is marked non-null but is null");
        }
        return events.stream().max(Comparator.comparing(GenericEvent::getCreatedAt)).map(event -> this.getNostrEventService().extractNutZapInformation((GenericEvent)event)).orElseThrow(() -> new IllegalArgumentException("No events found"));
    }

    public static <T extends Secret> List<CashuProof> getProofs(@NonNull TokenV3<T> token) {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        log.debug("getProofs called");
        return token.getMintProofs().stream().flatMap(mintProof -> mintProof.getProofs().stream()).map(proof -> TokenUtil.toCashuProof(proof)).toList();
    }

    private Long since() {
        Identity self = this.getIdentity();
        NostrEventService nostrEventService = this.getNostrEventService();
        List<GenericEvent> events = nostrEventService.fetchSpendingHistoryEvents(List.of(self.getPublicKey()));
        GenericEvent event = events.stream().max(Comparator.comparing(GenericEvent::getCreatedAt)).orElse(null);
        return event == null ? 0L : event.getCreatedAt();
    }

    private List<String> getMints() {
        Identity self = this.getIdentity();
        NostrEventService nostrEventService = this.getNostrEventService();
        List<GenericEvent> events = nostrEventService.fetchNutZapInformationalEvents(self.getPublicKey());
        GenericEvent event = events.stream().max(Comparator.comparing(GenericEvent::getCreatedAt)).orElseThrow(() -> new IllegalStateException("No events found"));
        return event.getTags().stream().filter(tag -> tag.getCode().equals("mint")).map(tag -> (GenericTag)tag).map(tag -> ((ElementAttribute)tag.getAttributes().get(0)).value().toString()).collect(Collectors.toList());
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NutZapService)) {
            return false;
        }
        NutZapService other = (NutZapService)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SwapOperation<T> this$swapOperation = this.getSwapOperation();
        SwapOperation<T> other$swapOperation = other.getSwapOperation();
        if (this$swapOperation == null ? other$swapOperation != null : !((Object)this$swapOperation).equals(other$swapOperation)) {
            return false;
        }
        PaymentMethod this$paymentMethod = this.getPaymentMethod();
        PaymentMethod other$paymentMethod = other.getPaymentMethod();
        return !(this$paymentMethod == null ? other$paymentMethod != null : !this$paymentMethod.equals(other$paymentMethod));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof NutZapService;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        SwapOperation<T> $swapOperation = this.getSwapOperation();
        result = result * 59 + ($swapOperation == null ? 43 : ((Object)$swapOperation).hashCode());
        PaymentMethod $paymentMethod = this.getPaymentMethod();
        result = result * 59 + ($paymentMethod == null ? 43 : $paymentMethod.hashCode());
        return result;
    }

    @Generated
    public SwapOperation<T> getSwapOperation() {
        return this.swapOperation;
    }

    @Generated
    public PaymentMethod getPaymentMethod() {
        return this.paymentMethod;
    }

    @Generated
    public void setSwapOperation(SwapOperation<T> swapOperation) {
        this.swapOperation = swapOperation;
    }

    @Generated
    public void setPaymentMethod(PaymentMethod paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    @Override
    @Generated
    public String toString() {
        return "NutZapService(swapOperation=" + String.valueOf(this.getSwapOperation()) + ", paymentMethod=" + String.valueOf(this.getPaymentMethod()) + ")";
    }
}

