/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.nostr.cashu.util;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.nostr.cashu.config.ExecutorOptions;
import xyz.tcheeric.nostr.cashu.util.AsyncExecutor;
import xyz.tcheeric.nostr.cashu.util.RetryPolicy;

public class DefaultAsyncExecutor
implements AsyncExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultAsyncExecutor.class);
    private final Executor executor;
    private final long timeoutSeconds;
    private final RetryPolicy retryPolicy;

    public DefaultAsyncExecutor() {
        this((Executor)Executors.newCachedThreadPool(), ExecutorOptions.defaults());
    }

    public DefaultAsyncExecutor(Executor executor, long timeoutSeconds) {
        this(executor, ExecutorOptions.builder().timeoutSeconds(timeoutSeconds).build());
    }

    public DefaultAsyncExecutor(Executor executor, ExecutorOptions options) {
        log.debug("DefaultAsyncExecutor initialised");
        Objects.requireNonNull(executor, "executor");
        Objects.requireNonNull(options, "options");
        this.executor = executor;
        this.timeoutSeconds = options.getTimeoutSeconds();
        this.retryPolicy = options.getRetryPolicy();
    }

    public DefaultAsyncExecutor(ExecutorOptions options) {
        this((Executor)Executors.newCachedThreadPool(), options);
    }

    @Override
    public RetryPolicy defaultRetryPolicy() {
        return this.retryPolicy;
    }

    @Override
    public <T> CompletableFuture<T> execute(Supplier<T> task, RetryPolicy policy) {
        RetryPolicy effectivePolicy;
        log.debug("execute called");
        Objects.requireNonNull(task, "task");
        RetryPolicy retryPolicy = effectivePolicy = policy != null ? policy : this.retryPolicy;
        if (effectivePolicy == null) {
            effectivePolicy = RetryPolicy.noRetries();
        }
        CompletableFuture result = new CompletableFuture();
        this.schedule(task, effectivePolicy, 1, result);
        if (this.timeoutSeconds > 0L) {
            result.orTimeout(this.timeoutSeconds, TimeUnit.SECONDS);
        }
        return result;
    }

    private <T> void schedule(Supplier<T> task, RetryPolicy policy, int attempt, CompletableFuture<T> target) {
        if (target.isDone()) {
            return;
        }
        CompletableFuture.supplyAsync(task, this.executor).whenComplete((value, throwable) -> {
            if (throwable == null) {
                target.complete(value);
                return;
            }
            Throwable cause = this.unwrap((Throwable)throwable);
            if (!policy.shouldRetry(attempt, cause)) {
                target.completeExceptionally(cause);
                return;
            }
            long delay = policy.nextDelayMillis(attempt);
            Runnable retry = () -> this.lambda$schedule$0((Supplier)task, policy, attempt, target);
            if (delay <= 0L) {
                CompletableFuture.runAsync(retry, this.executor);
            } else {
                CompletableFuture.runAsync(retry, CompletableFuture.delayedExecutor(delay, TimeUnit.MILLISECONDS, this.executor));
            }
        });
    }

    private Throwable unwrap(Throwable throwable) {
        CompletionException completion;
        if (throwable instanceof CompletionException && (completion = (CompletionException)throwable).getCause() != null) {
            return this.unwrap(completion.getCause());
        }
        return throwable;
    }

    private /* synthetic */ void lambda$schedule$0(Supplier task, RetryPolicy policy, int attempt, CompletableFuture target) {
        this.schedule(task, policy, attempt + 1, target);
    }
}

