/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.nostr.cashu.util;

import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import lombok.Generated;
import lombok.NonNull;

public final class RetryPolicy {
    private static final Predicate<Throwable> ALWAYS_RETRY = throwable -> true;
    private final int maxAttempts;
    @NonNull
    private final Duration initialBackoff;
    private final double multiplier;
    private final Duration maxBackoff;
    @NonNull
    private final Predicate<Throwable> retryOn;

    public RetryPolicy(int maxAttempts, @NonNull Duration initialBackoff, double multiplier, Duration maxBackoff, @NonNull Predicate<Throwable> retryOn) {
        if (initialBackoff == null) {
            throw new NullPointerException("initialBackoff is marked non-null but is null");
        }
        if (retryOn == null) {
            throw new NullPointerException("retryOn is marked non-null but is null");
        }
        if (maxAttempts < 1) {
            throw new IllegalArgumentException("maxAttempts must be at least 1");
        }
        if (initialBackoff.isNegative()) {
            throw new IllegalArgumentException("initialBackoff must be >= 0");
        }
        if (multiplier < 1.0) {
            throw new IllegalArgumentException("multiplier must be >= 1");
        }
        this.maxAttempts = maxAttempts;
        this.initialBackoff = initialBackoff;
        this.multiplier = multiplier;
        this.maxBackoff = maxBackoff == null ? Duration.ofSeconds(5L) : maxBackoff;
        this.retryOn = Objects.requireNonNull(retryOn, "retryOn");
    }

    public static RetryPolicy noRetries() {
        return RetryPolicy.builder().maxAttempts(1).initialBackoff(Duration.ZERO).multiplier(1.0).maxBackoff(Duration.ZERO).retryOn(ALWAYS_RETRY).build();
    }

    public boolean shouldRetry(int attempt, Throwable throwable) {
        if (attempt >= this.maxAttempts) {
            return false;
        }
        Throwable cause = this.unwrap(throwable);
        return this.retryOn.test(cause);
    }

    public long nextDelayMillis(int attempt) {
        if (attempt <= 0) {
            return this.initialBackoff.toMillis();
        }
        double delay = (double)this.initialBackoff.toMillis() * Math.pow(this.multiplier, Math.max(0, attempt - 1));
        long capped = Math.min((long)delay, this.maxBackoff.toMillis());
        return Math.max(0L, capped);
    }

    private Throwable unwrap(Throwable throwable) {
        ExecutionException execution;
        CompletionException completion;
        if (throwable instanceof CompletionException && (completion = (CompletionException)throwable).getCause() != null) {
            return this.unwrap(completion.getCause());
        }
        if (throwable instanceof ExecutionException && (execution = (ExecutionException)throwable).getCause() != null) {
            return this.unwrap(execution.getCause());
        }
        return throwable;
    }

    @Generated
    public static RetryPolicyBuilder builder() {
        return new RetryPolicyBuilder();
    }

    @Generated
    public RetryPolicyBuilder toBuilder() {
        return new RetryPolicyBuilder().maxAttempts(this.maxAttempts).initialBackoff(this.initialBackoff).multiplier(this.multiplier).maxBackoff(this.maxBackoff).retryOn(this.retryOn);
    }

    @Generated
    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    @NonNull
    @Generated
    public Duration getInitialBackoff() {
        return this.initialBackoff;
    }

    @Generated
    public double getMultiplier() {
        return this.multiplier;
    }

    @Generated
    public Duration getMaxBackoff() {
        return this.maxBackoff;
    }

    @NonNull
    @Generated
    public Predicate<Throwable> getRetryOn() {
        return this.retryOn;
    }

    @Generated
    public static class RetryPolicyBuilder {
        @Generated
        private int maxAttempts;
        @Generated
        private Duration initialBackoff;
        @Generated
        private double multiplier;
        @Generated
        private Duration maxBackoff;
        @Generated
        private Predicate<Throwable> retryOn;

        @Generated
        RetryPolicyBuilder() {
        }

        @Generated
        public RetryPolicyBuilder maxAttempts(int maxAttempts) {
            this.maxAttempts = maxAttempts;
            return this;
        }

        @Generated
        public RetryPolicyBuilder initialBackoff(@NonNull Duration initialBackoff) {
            if (initialBackoff == null) {
                throw new NullPointerException("initialBackoff is marked non-null but is null");
            }
            this.initialBackoff = initialBackoff;
            return this;
        }

        @Generated
        public RetryPolicyBuilder multiplier(double multiplier) {
            this.multiplier = multiplier;
            return this;
        }

        @Generated
        public RetryPolicyBuilder maxBackoff(Duration maxBackoff) {
            this.maxBackoff = maxBackoff;
            return this;
        }

        @Generated
        public RetryPolicyBuilder retryOn(@NonNull Predicate<Throwable> retryOn) {
            if (retryOn == null) {
                throw new NullPointerException("retryOn is marked non-null but is null");
            }
            this.retryOn = retryOn;
            return this;
        }

        @Generated
        public RetryPolicy build() {
            return new RetryPolicy(this.maxAttempts, this.initialBackoff, this.multiplier, this.maxBackoff, this.retryOn);
        }

        @Generated
        public String toString() {
            return "RetryPolicy.RetryPolicyBuilder(maxAttempts=" + this.maxAttempts + ", initialBackoff=" + String.valueOf(this.initialBackoff) + ", multiplier=" + this.multiplier + ", maxBackoff=" + String.valueOf(this.maxBackoff) + ", retryOn=" + String.valueOf(this.retryOn) + ")";
        }
    }
}

