/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.nostr.cashu.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import nostr.event.entities.CashuMint;
import nostr.event.entities.CashuProof;
import nostr.event.entities.CashuToken;
import nostr.event.entities.CashuWallet;
import nostr.id.Identity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.cashu.common.BlindedMessage;
import xyz.tcheeric.cashu.common.Proof;
import xyz.tcheeric.cashu.common.Secret;
import xyz.tcheeric.cashu.common.Signature;
import xyz.tcheeric.cashu.common.TokenV3;
import xyz.tcheeric.cashu.common.Witness;
import xyz.tcheeric.cashu.common.util.SecretUtil;
import xyz.tcheeric.cashu.entities.rest.PostSwapRequest;
import xyz.tcheeric.nostr.cashu.operation.SwapOperation;
import xyz.tcheeric.nostr.cashu.services.SplitService;
import xyz.tcheeric.nostr.cashu.util.MintUtil;
import xyz.tcheeric.nostr.cashu.util.WalletUtil;

public class TokenUtil<T extends Secret> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TokenUtil.class);
    private final CashuWallet wallet;
    private final MintUtil mintUtil;
    private final Identity identity;
    private final SplitService splitService;
    private final WalletUtil<T> walletUtil;

    public TokenV3<T> create(@NonNull List<Proof<T>> proofs) {
        if (proofs == null) {
            throw new NullPointerException("proofs is marked non-null but is null");
        }
        log.debug("create called");
        TokenV3 token = new TokenV3();
        token.setUnit(this.mintUtil.getUnit());
        TokenV3.MintProof mintProof = new TokenV3.MintProof();
        mintProof.setProofs(new HashSet<Proof<T>>(proofs));
        mintProof.setMint(this.mintUtil.getMintUrl());
        token.addMintProof(mintProof);
        return token;
    }

    public static <T extends Secret> TokenV3<T> toTokenV3(@NonNull CashuToken token, @NonNull String unit) {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        log.debug("toTokenV3 called");
        TokenV3 tokenV3 = new TokenV3();
        tokenV3.setUnit(unit);
        TokenV3.MintProof mintProof = new TokenV3.MintProof();
        mintProof.setMint(token.getMint().getUrl());
        HashSet<Proof> proofSet = new HashSet<Proof>();
        for (CashuProof proof : token.getProofs()) {
            log.info("\u00a3\u00a3\u00a3 Secret: {}", (Object)proof.getSecret());
            proofSet.add(new Proof(proof.getAmount().intValue(), SecretUtil.toSecret((Object)proof.getSecret()), proof.getId(), Signature.fromString((String)proof.getC()), proof.getWitness() != null ? new Witness(List.of(proof.getWitness().split(","))) : null));
        }
        mintProof.setProofs(proofSet);
        tokenV3.addMintProof(mintProof);
        return tokenV3;
    }

    public static <T extends Secret> List<CashuToken> toCashuTokens(@NonNull TokenV3<T> tokenV3) {
        if (tokenV3 == null) {
            throw new NullPointerException("tokenV3 is marked non-null but is null");
        }
        log.debug("toCashuTokens called");
        ArrayList<CashuToken> tokenList = new ArrayList<CashuToken>();
        tokenV3.getMintProofs().forEach(mintProof -> {
            CashuToken token = new CashuToken();
            token.setMint(new CashuMint(mintProof.getMint()));
            ArrayList proofList = new ArrayList();
            mintProof.getProofs().forEach(proof -> proofList.add(TokenUtil.toCashuProof(proof)));
            token.setProofs(proofList);
            tokenList.add(token);
        });
        return tokenList;
    }

    public boolean contains(@NonNull TokenV3<T> tokenV3, @NonNull Proof<T> proof) {
        if (tokenV3 == null) {
            throw new NullPointerException("tokenV3 is marked non-null but is null");
        }
        if (proof == null) {
            throw new NullPointerException("proof is marked non-null but is null");
        }
        log.debug("contains called");
        return tokenV3.getMintProofs().stream().anyMatch(mintProof -> mintProof.getProofs().contains(proof));
    }

    public boolean compare(TokenV3<T> tokenV3, Set<CashuToken> tokens) {
        log.debug("compare called");
        Set<Proof<T>> tokenProofs = tokenV3.getMintProofs().stream().flatMap(mintProof -> mintProof.getProofs().stream()).collect(Collectors.toSet());
        Set<CashuProof> walletProofs = tokens.stream().flatMap(token1 -> token1.getProofs().stream()).collect(Collectors.toSet());
        return this.compare(tokenProofs, walletProofs);
    }

    public boolean compare(@NonNull Proof<T> proof, @NonNull CashuProof p) {
        if (proof == null) {
            throw new NullPointerException("proof is marked non-null but is null");
        }
        if (p == null) {
            throw new NullPointerException("p is marked non-null but is null");
        }
        log.debug("compare called");
        return proof.getAmount() == p.getAmount().intValue() && proof.getSecret().toString().equals(p.getSecret()) && proof.getKeySetId().equals(p.getId()) && proof.getUnblindedSignature().toString().equals(p.getC());
    }

    public boolean compare(@NonNull CashuProof proof, @NonNull Proof<T> p) {
        if (proof == null) {
            throw new NullPointerException("proof is marked non-null but is null");
        }
        if (p == null) {
            throw new NullPointerException("p is marked non-null but is null");
        }
        log.debug("compare called");
        return this.compare(p, proof);
    }

    public static <T extends Secret> CashuProof toCashuProof(@NonNull Proof<T> proof) {
        if (proof == null) {
            throw new NullPointerException("proof is marked non-null but is null");
        }
        log.debug("toCashuProof: amount={}, keysetId={}", (Object)proof.getAmount(), (Object)proof.getKeySetId());
        CashuProof p = new CashuProof();
        p.setAmount(Integer.valueOf(proof.getAmount()));
        p.setSecret(proof.getSecret().toString());
        p.setId(proof.getKeySetId());
        p.setC(proof.getUnblindedSignature().toString());
        String witness = proof.getWitness() != null ? new ObjectMapper().writeValueAsString((Object)proof.getWitness()) : null;
        p.setWitness(witness);
        return p;
    }

    public static <T extends Secret> Proof<T> toCashuProof(@NonNull CashuProof cashuProof) {
        if (cashuProof == null) {
            throw new NullPointerException("cashuProof is marked non-null but is null");
        }
        log.debug("toCashuProof: amount={}, keysetId={}", (Object)cashuProof.getAmount(), (Object)cashuProof.getId());
        Witness witness = cashuProof.getWitness() != null ? (Witness)new ObjectMapper().readValue(cashuProof.getWitness(), Witness.class) : null;
        return new Proof(cashuProof.getAmount().intValue(), SecretUtil.toSecret((Object)cashuProof.getSecret()), cashuProof.getId(), Signature.fromString((String)cashuProof.getC()), witness);
    }

    public static <T extends Secret> List<Proof<T>> toCashuProofList(@NonNull List<CashuProof> proofs) {
        if (proofs == null) {
            throw new NullPointerException("proofs is marked non-null but is null");
        }
        log.debug("toCashuProofList: size={}", (Object)proofs.size());
        return proofs.stream().map(proof -> TokenUtil.toCashuProof(proof)).collect(Collectors.toList());
    }

    public static <T extends Secret> List<TokenV3<T>> toCashuTokenList(@NonNull List<CashuToken> tokens, @NonNull String unit) {
        if (tokens == null) {
            throw new NullPointerException("tokens is marked non-null but is null");
        }
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        log.debug("toCashuTokenList: size={}, unit={}", (Object)tokens.size(), (Object)unit);
        return tokens.stream().map(token -> TokenUtil.toTokenV3(token, unit)).collect(Collectors.toList());
    }

    public Integer getAmount(@NonNull TokenV3<T> tokenV3) {
        if (tokenV3 == null) {
            throw new NullPointerException("tokenV3 is marked non-null but is null");
        }
        log.debug("getAmount called");
        return tokenV3.getMintProofs().stream().flatMap(mintProof -> mintProof.getProofs().stream()).mapToInt(Proof::getAmount).sum();
    }

    public TokenV3<T> splitProof(@NonNull Integer amount, @NonNull SwapOperation<T> swapOperation) {
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        if (swapOperation == null) {
            throw new NullPointerException("swapOperation is marked non-null but is null");
        }
        log.debug("splitProof called");
        List<CashuToken> tokensToSpend = this.walletUtil.getTokensFromWallet(amount);
        CashuProof proofToSplit = TokenUtil.getProofToSplit(tokensToSpend, amount);
        return this.splitProofWithoutExplosion(proofToSplit, swapOperation);
    }

    public TokenV3<T> splitProofWithoutExplosion(@NonNull CashuProof proofToSplit, @NonNull SwapOperation<T> swapOp) {
        if (proofToSplit == null) {
            throw new NullPointerException("proofToSplit is marked non-null but is null");
        }
        if (swapOp == null) {
            throw new NullPointerException("swapOp is marked non-null but is null");
        }
        log.debug("splitProofWithoutExplosion called");
        Map<Integer, Integer> split = this.splitService.withSmallestDenomination(proofToSplit.getAmount(), this.mintUtil);
        List<Proof<T>> proofs = TokenUtil.toCashuProofList(List.of(proofToSplit));
        PostSwapRequest postSwapRequest = new PostSwapRequest();
        postSwapRequest.setInputs(proofs);
        postSwapRequest.setBlindedMessages(this.createBlindedMessages(proofs, split));
        TokenV3<T> tokenFromSplitProofs = swapOp.swap(postSwapRequest).getToken();
        this.walletUtil.removeProofFromWallet(proofToSplit, swapOp.getUnit());
        String unit = tokenFromSplitProofs.getUnit();
        this.walletUtil.addTokens(TokenUtil.toCashuTokens(tokenFromSplitProofs), unit);
        return tokenFromSplitProofs;
    }

    public static <T extends Secret> TokenV3<T> createTokenV3(@NonNull List<Proof<T>> proofs, @NonNull String unit, @NonNull String mintUrl) {
        if (proofs == null) {
            throw new NullPointerException("proofs is marked non-null but is null");
        }
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        if (mintUrl == null) {
            throw new NullPointerException("mintUrl is marked non-null but is null");
        }
        log.debug("createTokenV3 called");
        TokenV3 token = new TokenV3();
        token.setUnit(unit);
        TokenV3.MintProof mintProof = new TokenV3.MintProof();
        mintProof.setMint(mintUrl);
        mintProof.setProofs(new HashSet<Proof<T>>(proofs));
        token.addMintProof(mintProof);
        return token;
    }

    private List<BlindedMessage> createBlindedMessages(@NonNull List<Proof<T>> proofs, @NonNull Map<Integer, Integer> change) {
        if (proofs == null) {
            throw new NullPointerException("proofs is marked non-null but is null");
        }
        if (change == null) {
            throw new NullPointerException("change is marked non-null but is null");
        }
        return proofs.stream().flatMap(proof -> WalletUtil.createBlindMessageEntities(proof, change).stream()).collect(Collectors.toList());
    }

    public static CashuProof getProofToSplit(@NonNull List<CashuToken> tokenList, @NonNull Integer amount) {
        if (tokenList == null) {
            throw new NullPointerException("tokenList is marked non-null but is null");
        }
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        log.debug("getProofToSplit called");
        List allProofs = tokenList.stream().flatMap(token -> token.getProofs().stream()).toList();
        CashuProof proofToSplit = allProofs.stream().filter(proof -> proof.getAmount() > amount).min(Comparator.comparingInt(proof -> proof.getAmount() - amount)).orElse(null);
        if (proofToSplit == null) {
            throw new IllegalStateException("No proof to split");
        }
        return proofToSplit;
    }

    private void addProof(@NonNull TokenV3<T> tokenV3, @NonNull Proof<T> proof, @NonNull String mint) {
        if (tokenV3 == null) {
            throw new NullPointerException("tokenV3 is marked non-null but is null");
        }
        if (proof == null) {
            throw new NullPointerException("proof is marked non-null but is null");
        }
        if (mint == null) {
            throw new NullPointerException("mint is marked non-null but is null");
        }
        tokenV3.getMintProofs().stream().filter(mintProof -> mintProof.getMint().equals(mint)).findFirst().ifPresentOrElse(mintProof -> mintProof.getProofs().add(proof), () -> {
            TokenV3.MintProof mintProof = new TokenV3.MintProof();
            mintProof.setMint(mint);
            mintProof.addProof(proof);
            tokenV3.addMintProof(mintProof);
        });
    }

    private void removeProof(@NonNull TokenV3<T> tokenV3, @NonNull Proof<T> proof, @NonNull String mint) {
        if (tokenV3 == null) {
            throw new NullPointerException("tokenV3 is marked non-null but is null");
        }
        if (proof == null) {
            throw new NullPointerException("proof is marked non-null but is null");
        }
        if (mint == null) {
            throw new NullPointerException("mint is marked non-null but is null");
        }
        tokenV3.getMintProofs().stream().filter(mintProof -> mintProof.getMint().equals(mint)).findFirst().ifPresent(mintProof -> mintProof.getProofs().remove(proof));
    }

    boolean compare(Set<Proof<T>> proofSet, Set<CashuProof> walletProofs) {
        return proofSet.stream().allMatch(proof -> walletProofs.stream().anyMatch(p -> this.compare((Proof<T>)proof, (CashuProof)p)));
    }

    @Generated
    public CashuWallet getWallet() {
        return this.wallet;
    }

    @Generated
    public MintUtil getMintUtil() {
        return this.mintUtil;
    }

    @Generated
    public Identity getIdentity() {
        return this.identity;
    }

    @Generated
    public SplitService getSplitService() {
        return this.splitService;
    }

    @Generated
    public WalletUtil<T> getWalletUtil() {
        return this.walletUtil;
    }

    @Generated
    public TokenUtil(CashuWallet wallet, MintUtil mintUtil, Identity identity, SplitService splitService, WalletUtil<T> walletUtil) {
        this.wallet = wallet;
        this.mintUtil = mintUtil;
        this.identity = identity;
        this.splitService = splitService;
        this.walletUtil = walletUtil;
    }
}

