/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.nostr.cashu.wallet.service.impl;

import lombok.NonNull;
import xyz.tcheeric.cashu.common.PaymentMethod;
import xyz.tcheeric.cashu.common.Secret;
import xyz.tcheeric.cashu.entities.rest.PostMeltQuoteRequest;
import xyz.tcheeric.cashu.entities.rest.PostMeltQuoteResponse;
import xyz.tcheeric.cashu.entities.rest.PostMeltRequest;
import xyz.tcheeric.cashu.entities.rest.PostMeltResponse;
import xyz.tcheeric.cashu.wallet.client.impl.RequestCheckMeltQuoteState;
import xyz.tcheeric.cashu.wallet.client.impl.RequestMeltQuote;
import xyz.tcheeric.cashu.wallet.client.impl.RequestMeltToken;
import xyz.tcheeric.nostr.cashu.wallet.service.MeltException;
import xyz.tcheeric.nostr.cashu.wallet.service.MeltingService;

public class DefaultMeltingService<T extends Secret>
implements MeltingService<T> {
    private final PaymentMethod paymentMethod;
    private final String mintUrl;

    public DefaultMeltingService(@NonNull PaymentMethod paymentMethod, @NonNull String mintUrl) {
        if (paymentMethod == null) {
            throw new NullPointerException("paymentMethod is marked non-null but is null");
        }
        if (mintUrl == null) {
            throw new NullPointerException("mintUrl is marked non-null but is null");
        }
        this.paymentMethod = paymentMethod;
        this.mintUrl = mintUrl;
    }

    @Override
    public PostMeltQuoteResponse quote(PostMeltQuoteRequest request) {
        RequestMeltQuote requestMeltQuote = new RequestMeltQuote(this.mintUrl, this.paymentMethod, request);
        try {
            return (PostMeltQuoteResponse)requestMeltQuote.execute();
        }
        catch (MeltException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MeltException(this.mintUrl, this.paymentMethod, "Failed to request melt quote", e);
        }
    }

    @Override
    public PostMeltResponse melt(PostMeltRequest<T> request) {
        RequestMeltToken requestMeltToken = new RequestMeltToken(this.mintUrl, this.paymentMethod, request);
        try {
            return (PostMeltResponse)requestMeltToken.execute();
        }
        catch (MeltException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MeltException(this.mintUrl, this.paymentMethod, "Failed to request melt token", e);
        }
    }

    @Override
    public PostMeltQuoteResponse getQuote(String quoteId) {
        RequestCheckMeltQuoteState requestCheckMeltQuoteState = new RequestCheckMeltQuoteState(this.mintUrl, quoteId, this.paymentMethod.name());
        return (PostMeltQuoteResponse)requestCheckMeltQuoteState.execute();
    }
}

