/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.nostr.cashu.wallet.service.impl;

import lombok.NonNull;
import xyz.tcheeric.cashu.common.PaymentMethod;
import xyz.tcheeric.cashu.common.Secret;
import xyz.tcheeric.cashu.entities.rest.PostSwapRequest;
import xyz.tcheeric.cashu.entities.rest.PostSwapResponse;
import xyz.tcheeric.cashu.wallet.client.impl.RequestSwapToken;
import xyz.tcheeric.nostr.cashu.wallet.service.SwapException;
import xyz.tcheeric.nostr.cashu.wallet.service.SwappingService;

public class DefaultSwappingService<T extends Secret>
implements SwappingService<T> {
    private final PaymentMethod paymentMethod;
    private final String mintUrl;

    public DefaultSwappingService(@NonNull PaymentMethod paymentMethod, @NonNull String mintUrl) {
        if (paymentMethod == null) {
            throw new NullPointerException("paymentMethod is marked non-null but is null");
        }
        if (mintUrl == null) {
            throw new NullPointerException("mintUrl is marked non-null but is null");
        }
        this.paymentMethod = paymentMethod;
        this.mintUrl = mintUrl;
    }

    @Override
    public PostSwapResponse swap(PostSwapRequest<T> request) {
        RequestSwapToken requestSwapToken = new RequestSwapToken(this.mintUrl, request);
        try {
            return (PostSwapResponse)requestSwapToken.execute();
        }
        catch (SwapException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SwapException(this.mintUrl, this.paymentMethod, "Failed to request swap token", e);
        }
    }
}

